/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraftforge.common.data.ExistingFileHelper;
import oshi.util.tuples.Pair;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFRecipes;

public abstract class CrumbleHornProvider
implements class_2405 {
    private final class_2403 generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Pair<class_2680, class_2680>> builders = Maps.newLinkedHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public CrumbleHornProvider(class_2403 generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public void method_10319(class_7403 cache) {
        this.builders.clear();
        this.registerTransforms();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> class_2378.field_11146.method_10250(class_2378.field_11146.method_10221((Object)((class_2680)transform.getA()).method_26204()))).filter(s -> class_2378.field_11146.method_10250(class_2378.field_11146.method_10221((Object)((class_2680)transform.getB()).method_26204()))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Crumble Horn Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((class_2680)transform.getA(), (class_2680)transform.getB());
            Path path = this.createPath(new class_2960(this.modId, name));
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                TwilightForestMod.LOGGER.error("Couldn't save Crumble Transformation to {}", (Object)path, (Object)e);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new class_2960(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", "crumble_horn/"));
    }

    private Path createPath(class_2960 name) {
        return this.generator.method_10313().resolve("data/" + name.method_12836() + "/recipes/crumble_horn/" + name.method_12832() + ".json");
    }

    private JsonObject serializeToJson(class_2680 transformFrom, class_2680 transformTo) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", class_2378.field_17598.method_10221((Object)((class_1865)TFRecipes.CRUMBLE_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", class_2378.field_11146.method_10221((Object)transformFrom.method_26204()).toString());
        jsonobject.addProperty("to", class_2378.field_11146.method_10221((Object)transformTo.method_26204()).toString());
        return jsonobject;
    }

    public String method_10321() {
        return this.modId + " Crumble Horn Transformations";
    }

    public void addTransform(class_2248 from, class_2248 to) {
        this.builders.put(class_2378.field_11146.method_10221((Object)from).method_12832() + "_to_" + class_2378.field_11146.method_10221((Object)to).method_12832(), (Pair<class_2680, class_2680>)new Pair((Object)from.method_9564(), (Object)to.method_9564()));
    }

    public void addDissolve(class_2248 dissolveBlock) {
        this.builders.put("dissolve_" + class_2378.field_11146.method_10221((Object)dissolveBlock).method_12832(), (Pair<class_2680, class_2680>)new Pair((Object)dissolveBlock.method_9564(), (Object)class_2246.field_10124.method_9564()));
    }
}

