/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Triple;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFRecipes;

public abstract class TransformationPowderProvider
implements class_2405 {
    private final class_2403 generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Triple<class_1299<?>, class_1299<?>, Boolean>> builders = Maps.newLinkedHashMap();

    public TransformationPowderProvider(class_2403 generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public void method_10319(class_7403 cache) {
        this.builders.clear();
        this.registerTransforms();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> class_2378.field_11145.method_10250(class_2378.field_11145.method_10221((Object)((class_1299)transform.getLeft())))).filter(s -> class_2378.field_11145.method_10250(class_2378.field_11145.method_10221((Object)((class_1299)transform.getMiddle())))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Transformation Powder Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((class_1299)transform.getLeft(), (class_1299)transform.getMiddle(), (Boolean)transform.getRight());
            Path path = this.createPath(new class_2960(this.modId, name));
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                TwilightForestMod.LOGGER.error("Couldn't save Transformation Powder recipe to {}", (Object)path, (Object)e);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new class_2960(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", "crumble_horn/"));
    }

    private Path createPath(class_2960 name) {
        return this.generator.method_10313().resolve("data/" + name.method_12836() + "/recipes/transformation_powder/" + name.method_12832() + ".json");
    }

    private JsonObject serializeToJson(class_1299<?> transformFrom, class_1299<?> transformTo, boolean reversible) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", class_2378.field_17598.method_10221((Object)((class_1865)TFRecipes.TRANSFORMATION_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", class_2378.field_11145.method_10221(transformFrom).toString());
        jsonobject.addProperty("to", class_2378.field_11145.method_10221(transformTo).toString());
        jsonobject.addProperty("reversible", Boolean.valueOf(reversible));
        return jsonobject;
    }

    public String method_10321() {
        return this.modId + " Transformation Powder Transformations";
    }

    public void addOneWayTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_2378.field_11145.method_10221(from).method_12832() + "_to_" + class_2378.field_11145.method_10221(to).method_12832(), Triple.of(from, to, (Object)false));
    }

    public void addTwoWayTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_2378.field_11145.method_10221(from).method_12832() + "_to_" + class_2378.field_11145.method_10221(to).method_12832(), Triple.of(from, to, (Object)true));
    }
}

