/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7403;
import net.minecraftforge.common.data.ExistingFileHelper;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFRecipes;
import twilightforest.item.recipe.UncraftingRecipe;

public abstract class UncraftingRecipeProvider
implements class_2405 {
    private final class_2403 generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<UncraftingRecipe, String[]> builders = Maps.newLinkedHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public UncraftingRecipeProvider(class_2403 generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerUncraftingRecipes();

    public void method_10319(class_7403 cache) {
        this.builders.clear();
        this.registerUncraftingRecipes();
        this.builders.forEach((uncraftingRecipe, pattern) -> {
            List<UncraftingRecipe> list = this.builders.keySet().stream().filter(s -> {
                String name = s.method_8114().method_12832();
                return this.missing(name) && !this.builders.containsKey(uncraftingRecipe);
            }).toList();
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Uncrafting recipe: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((UncraftingRecipe)uncraftingRecipe, (String[])pattern);
            Path path = this.createPath(new class_2960(this.modId, uncraftingRecipe.method_8114().method_12832()));
            try {
                class_2405.method_10320((class_7403)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                TwilightForestMod.LOGGER.error("Couldn't save Uncrafting recipe to {}", (Object)path, (Object)e);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new class_2960(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", "crumble_horn/"));
    }

    private Path createPath(class_2960 name) {
        return this.generator.method_10313().resolve("data/" + name.method_12836() + "/recipes/uncrafting/" + name.method_12832() + ".json");
    }

    private JsonObject serializeToJson(UncraftingRecipe uncraftingRecipe, String[] pattern) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", Objects.requireNonNull(class_2378.field_17598.method_10221((Object)((class_1865)TFRecipes.UNCRAFTING_SERIALIZER.get()))).toString());
        jsonobject.add("ingredient", uncraftingRecipe.ingredient().method_8089());
        jsonobject.addProperty("count", (Number)uncraftingRecipe.count());
        jsonobject.addProperty("cost", (Number)uncraftingRecipe.cost());
        JsonArray jsonarray = new JsonArray();
        for (String line : pattern) {
            jsonarray.add(line);
        }
        jsonobject.add("pattern", (JsonElement)jsonarray);
        HashMap<Character, class_1856> keyedPattern = new HashMap<Character, class_1856>();
        for (String s : pattern) {
            for (int x = 0; x < uncraftingRecipe.width(); ++x) {
                char key = s.charAt(x);
                if (key == ' ' || keyedPattern.containsKey(Character.valueOf(key))) continue;
                keyedPattern.put(Character.valueOf(key), (class_1856)uncraftingRecipe.method_8117().get(keyedPattern.size()));
            }
        }
        JsonObject keyObject = new JsonObject();
        for (Map.Entry entry : keyedPattern.entrySet()) {
            keyObject.add(((Character)entry.getKey()).toString(), ((class_1856)entry.getValue()).method_8089());
        }
        jsonobject.add("key", (JsonElement)keyObject);
        return jsonobject;
    }

    public String method_10321() {
        return this.modId + " Uncrafting Recipes";
    }

    public void addUncraftingRecipe(String name, class_1856 input, int count, int cost, String[] pattern, class_1856 ... output) {
        int width = pattern[0].length();
        int height = pattern.length;
        if (width > 3 || height > 3) {
            TwilightForestMod.LOGGER.error("The pattern must be 3x3 in size, or smaller!");
            return;
        }
        if (width == 0) {
            TwilightForestMod.LOGGER.error("A pattern line can not be empty!");
            return;
        }
        for (String s : pattern) {
            if (s.length() == width) continue;
            TwilightForestMod.LOGGER.error("Each line of a recipe pattern must be the same length!");
            return;
        }
        this.builders.put(new UncraftingRecipe(new class_2960(name), cost, width, height, input, count, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])output)), pattern);
    }
}

