/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom.stalactites;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import twilightforest.TwilightForestMod;
import twilightforest.data.custom.stalactites.entry.Stalactite;
import twilightforest.data.custom.stalactites.entry.StalactiteReloadListener;

public abstract class StalactiteProvider
implements class_2405 {
    private final class_2403 generator;
    private final String modid;
    private final class_2403.class_7489 entryPath;
    protected final Map<Pair<class_2960, Stalactite>, Stalactite.HollowHillType> builder = Maps.newLinkedHashMap();

    public StalactiteProvider(class_2403 generator, String modid) {
        this.generator = generator;
        this.modid = modid;
        this.entryPath = generator.method_44106(class_2403.class_7490.field_39367, "stalactites/entries");
    }

    public void method_10319(class_7403 output) throws IOException {
        HashMap map = Maps.newHashMap();
        HashMap smallHillEntries = Maps.newHashMap();
        HashMap medHillEntries = Maps.newHashMap();
        HashMap largeHillEntries = Maps.newHashMap();
        this.builder.clear();
        this.createStalactites();
        this.builder.forEach((stalactiteMap, type) -> {
            if (type == Stalactite.HollowHillType.LARGE) {
                largeHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else if (type == Stalactite.HollowHillType.MEDIUM) {
                medHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            } else {
                smallHillEntries.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
            }
            map.put((class_2960)stalactiteMap.getFirst(), (Stalactite)stalactiteMap.getSecond());
        });
        map.forEach((resourceLocation, stalactite) -> {
            Path path = this.entryPath.method_44107(resourceLocation);
            try {
                class_2405.method_10320((class_7403)output, (JsonElement)StalactiteReloadListener.serialize(stalactite), (Path)path);
            }
            catch (IOException ioexception) {
                TwilightForestMod.LOGGER.error("Couldn't save stalactite entry {}", (Object)path, (Object)ioexception);
            }
        });
        Gson hillGson = new GsonBuilder().setPrettyPrinting().create();
        for (Stalactite.HollowHillType type2 : Stalactite.HollowHillType.values()) {
            Path hillPath = this.generator.method_10313().resolve("data/twilightforest/stalactites/" + type2.name().toLowerCase(Locale.ROOT) + "_hollow_hill.json");
            HashMap mapToUse = type2 == Stalactite.HollowHillType.LARGE ? largeHillEntries : (type2 == Stalactite.HollowHillType.MEDIUM ? medHillEntries : smallHillEntries);
            JsonObject object = new JsonObject();
            object.addProperty("replace", Boolean.valueOf(false));
            object.add("stalactites", hillGson.toJsonTree(mapToUse.keySet().stream().map(class_2960::toString).collect(Collectors.toList())));
            class_2405.method_10320((class_7403)output, (JsonElement)object, (Path)hillPath);
        }
    }

    protected abstract void createStalactites();

    protected void makeStalactite(Stalactite stalactite, Stalactite.HollowHillType type) {
        this.builder.putIfAbsent((Pair<class_2960, Stalactite>)Pair.of((Object)new class_2960(this.modid, class_2378.field_11146.method_10221((Object)stalactite.ore()).method_12832() + "_stalactite"), (Object)stalactite), type);
    }

    public String method_10321() {
        return this.modid + " Hollow Hill Stalactites";
    }
}

