/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.helpers;

import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.function.Consumer;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2341;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2383;
import net.minecraft.class_2403;
import net.minecraft.class_2429;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2746;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import twilightforest.TwilightForestMod;
import twilightforest.block.BanisterBlock;
import twilightforest.enums.BanisterShape;

public abstract class BlockModelHelpers
extends BlockStateProvider {
    protected static final class_2960 SOLID = new class_2960("solid");
    protected static final class_2960 CUTOUT = new class_2960("cutout");
    protected static final class_2960 CUTOUT_MIPPED = new class_2960("cutout_mipped");
    protected static final class_2960 TRANSLUCENT = new class_2960("translucent");

    public BlockModelHelpers(class_2403 gen, ExistingFileHelper exFileHelper) {
        super(gen, "twilightforest", exFileHelper);
    }

    protected void builtinEntity(class_2248 b, String particle) {
        this.simpleBlock(b, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.name(b))).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).texture("particle", particle));
    }

    protected void simpleBlockExisting(class_2248 b) {
        this.simpleBlock(b, new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getExistingFile(TwilightForestMod.prefix(this.name(b))))});
    }

    public void simpleBlockWithRenderType(class_2248 block, class_2960 type) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.name(block), this.blockTexture(block))).renderType(type));
    }

    protected void singleBlockBoilerPlate(class_2248 b, String parent, Consumer<BlockModelBuilder> modelCustomizer) {
        BlockModelBuilder bModel = (BlockModelBuilder)this.models().withExistingParent(this.name(b), parent);
        modelCustomizer.accept(bModel);
        this.simpleBlock(b, (ModelFile)bModel);
    }

    protected void logWoodSapling(class_2465 log, class_2465 slog, class_2465 wood, class_2465 swood, class_2248 sapling) {
        this.logBlock(log);
        this.logBlock(slog);
        class_2960 sideTex = this.blockTexture((class_2248)log);
        this.axisBlock(wood, sideTex, sideTex);
        class_2960 sSideTex = this.blockTexture((class_2248)slog);
        this.axisBlock(swood, sSideTex, sSideTex);
        class_2960 saplingTex = TwilightForestMod.prefix("block/" + this.name(sapling));
        this.simpleBlock(sapling, (ModelFile)((BlockModelBuilder)this.models().cross(this.name(sapling), saplingTex)).renderType(CUTOUT));
    }

    protected void plankBlocks(String variant, class_2248 plank, class_2248 slab, class_2510 stair, class_2248 button, class_2248 fence, class_2248 gate, class_2248 plate, class_2323 door, class_2533 trapdoor, BanisterBlock banister) {
        this.plankBlocks(variant, plank, slab, stair, button, fence, gate, plate, door, trapdoor, false, banister);
    }

    protected void plankBlocks(String variant, class_2248 plank, class_2248 slab, class_2510 stair, class_2248 button, class_2248 fence, class_2248 gate, class_2248 plate, class_2323 door, class_2533 trapdoor, boolean cutoutDoors, BanisterBlock banister) {
        String plankTexName = "planks_" + variant;
        String plankDir = "block/wood/planks/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + plankTexName + "_3");
        ConfiguredModel[] plankModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank), tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_1", tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_2", tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().cubeAll(plankDir + this.name(plank) + "_3", tex3)).build();
        this.simpleBlock(plank, plankModels);
        String slabDir = "block/wood/slab/" + variant + "/";
        ConfiguredModel[] bottomSlabModels = ConfiguredModel.builder().weight(10).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab), tex0, tex0, tex0)).nextModel().weight(10).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_1", tex1, tex1, tex1)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_2", tex2, tex2, tex2)).nextModel().weight(1).modelFile((ModelFile)this.models().slab(slabDir + this.name(slab) + "_3", tex3, tex3, tex3)).build();
        ConfiguredModel[] topSlabModels = ConfiguredModel.builder().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[0].model).nextModel().weight(10).uvLock(true).rotationX(180).modelFile(bottomSlabModels[1].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[2].model).nextModel().weight(1).uvLock(true).rotationX(180).modelFile(bottomSlabModels[3].model).build();
        this.getVariantBuilder(slab).partialState().with((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681).setModels(bottomSlabModels);
        this.getVariantBuilder(slab).partialState().with((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679).setModels(topSlabModels);
        this.getVariantBuilder(slab).partialState().with((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682).setModels(plankModels);
        this.woodStairs(stair, plankTexName, variant);
        this.woodButton(button, plankTexName, variant);
        this.woodFence(fence, plankTexName, variant);
        this.woodGate(gate, plankTexName, variant);
        this.woodPlate(plate, plankTexName, variant);
        String doorDir = "block/wood/door/" + variant + "/";
        String trapdoorDir = "block/wood/trapdoor/" + variant + "/";
        if (cutoutDoors) {
            this.doorBlockWithRenderType(door, doorDir + this.name((class_2248)door), TwilightForestMod.prefix("block/wood/door/" + variant + "_lower"), TwilightForestMod.prefix("block/wood/door/" + variant + "_upper"), CUTOUT);
            this.trapdoorBlockWithRenderType(trapdoor, trapdoorDir + variant, TwilightForestMod.prefix("block/wood/trapdoor/" + variant + "_trapdoor"), true, CUTOUT);
        } else {
            this.doorBlock(door, doorDir + this.name((class_2248)door), TwilightForestMod.prefix("block/wood/door/" + variant + "_lower"), TwilightForestMod.prefix("block/wood/door/" + variant + "_upper"));
            this.trapdoorBlock(trapdoor, trapdoorDir + variant, TwilightForestMod.prefix("block/wood/trapdoor/" + variant + "_trapdoor"), true);
        }
        this.banister(banister, plankTexName, variant);
    }

    protected void woodGate(class_2248 gate, String texName, String variant) {
        String gateDir = "block/wood/fence_gate/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder gate0 = this.models().fenceGate(gateDir + this.name(gate), tex0);
        ModelBuilder gate1 = this.models().fenceGate(gateDir + this.name(gate) + "_1", tex1);
        ModelBuilder gate2 = this.models().fenceGate(gateDir + this.name(gate) + "_2", tex2);
        ModelBuilder gate3 = this.models().fenceGate(gateDir + this.name(gate) + "_3", tex3);
        ModelBuilder open0 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open", tex0);
        ModelBuilder open1 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_1", tex1);
        ModelBuilder open2 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_2", tex2);
        ModelBuilder open3 = this.models().fenceGateOpen(gateDir + this.name(gate) + "_open_3", tex3);
        ModelBuilder wall0 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall", tex0);
        ModelBuilder wall1 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_1", tex1);
        ModelBuilder wall2 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_2", tex2);
        ModelBuilder wall3 = this.models().fenceGateWall(gateDir + this.name(gate) + "_wall_3", tex3);
        ModelBuilder wallOpen0 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open", tex0);
        ModelBuilder wallOpen1 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_1", tex1);
        ModelBuilder wallOpen2 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_2", tex2);
        ModelBuilder wallOpen3 = this.models().fenceGateWallOpen(gateDir + this.name(gate) + "_wall_open_3", tex3);
        this.getVariantBuilder(gate).forAllStatesExcept(arg_0 -> BlockModelHelpers.lambda$woodGate$0((ModelFile)gate0, (ModelFile)gate1, (ModelFile)gate2, (ModelFile)gate3, (ModelFile)wall0, (ModelFile)wall1, (ModelFile)wall2, (ModelFile)wall3, (ModelFile)wallOpen0, (ModelFile)open0, (ModelFile)wallOpen1, (ModelFile)open1, (ModelFile)wallOpen2, (ModelFile)open2, (ModelFile)wallOpen3, (ModelFile)open3, arg_0), new class_2769[]{class_2349.field_11021});
    }

    protected void woodFence(class_2248 fence, String texName, String variant) {
        String fenceDir = "block/wood/fence/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder post0 = this.models().fencePost(fenceDir + this.name(fence) + "_post", tex0);
        ModelBuilder post1 = this.models().fencePost(fenceDir + this.name(fence) + "_post_1", tex1);
        ModelBuilder post2 = this.models().fencePost(fenceDir + this.name(fence) + "_post_2", tex2);
        ModelBuilder post3 = this.models().fencePost(fenceDir + this.name(fence) + "_post_3", tex3);
        ModelBuilder side0 = this.models().fenceSide(fenceDir + this.name(fence) + "_side", tex0);
        ModelBuilder side1 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_1", tex1);
        ModelBuilder side2 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_2", tex2);
        ModelBuilder side3 = this.models().fenceSide(fenceDir + this.name(fence) + "_side_3", tex3);
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(fence).part().weight(10).modelFile((ModelFile)post0).nextModel().weight(10).modelFile((ModelFile)post1).nextModel().weight(1).modelFile((ModelFile)post2).nextModel().weight(1).modelFile((ModelFile)post3).addModel()).end();
        class_2429.field_11329.forEach((arg_0, arg_1) -> BlockModelHelpers.lambda$woodFence$1(builder, (ModelFile)side0, (ModelFile)side1, (ModelFile)side2, (ModelFile)side3, arg_0, arg_1));
    }

    protected void woodPlate(class_2248 plate, String texName, String variant) {
        String plateDir = "block/wood/pressure_plate/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ConfiguredModel[] unpressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate), "pressure_plate_up")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_1", "pressure_plate_up")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_2", "pressure_plate_up")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_3", "pressure_plate_up")).texture("texture", tex3)).build();
        ConfiguredModel[] pressed = ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down", "pressure_plate_down")).texture("texture", tex0)).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_1", "pressure_plate_down")).texture("texture", tex1)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_2", "pressure_plate_down")).texture("texture", tex2)).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(plateDir + this.name(plate) + "_down_3", "pressure_plate_down")).texture("texture", tex3)).build();
        this.getVariantBuilder(plate).partialState().with((class_2769)class_2440.field_11358, (Comparable)Boolean.valueOf(false)).setModels(unpressed);
        this.getVariantBuilder(plate).partialState().with((class_2769)class_2440.field_11358, (Comparable)Boolean.valueOf(true)).setModels(pressed);
    }

    protected void woodButton(class_2248 button, String texName, String variant) {
        String buttonDir = "block/wood/button/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder unpressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button), "button")).texture("texture", tex0);
        ModelBuilder pressed0 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed", "button_pressed")).texture("texture", tex0);
        ModelBuilder unpressed1 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_1", "button")).texture("texture", tex1);
        ModelBuilder pressed1 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_1", "button_pressed")).texture("texture", tex1);
        ModelBuilder unpressed2 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_2", "button")).texture("texture", tex2);
        ModelBuilder pressed2 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_2", "button_pressed")).texture("texture", tex2);
        ModelBuilder unpressed3 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_3", "button")).texture("texture", tex3);
        ModelBuilder pressed3 = ((BlockModelBuilder)this.models().withExistingParent(buttonDir + this.name(button) + "_pressed_3", "button_pressed")).texture("texture", tex3);
        this.getVariantBuilder(button).forAllStates(arg_0 -> BlockModelHelpers.lambda$woodButton$2((ModelFile)pressed0, (ModelFile)unpressed0, (ModelFile)pressed1, (ModelFile)unpressed1, (ModelFile)pressed2, (ModelFile)unpressed2, (ModelFile)pressed3, (ModelFile)unpressed3, arg_0));
    }

    protected void woodStairs(class_2510 block, String texName, String variant) {
        String stairsDir = "block/wood/stairs/" + variant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        ModelBuilder main0 = this.models().stairs(stairsDir + this.name((class_2248)block), tex0, tex0, tex0);
        ModelBuilder main1 = this.models().stairs(stairsDir + this.name((class_2248)block) + "_1", tex1, tex1, tex1);
        ModelBuilder main2 = this.models().stairs(stairsDir + this.name((class_2248)block) + "_2", tex2, tex2, tex2);
        ModelBuilder main3 = this.models().stairs(stairsDir + this.name((class_2248)block) + "_3", tex3, tex3, tex3);
        ModelBuilder inner0 = this.models().stairsInner(stairsDir + this.name((class_2248)block) + "_inner", tex0, tex0, tex0);
        ModelBuilder inner1 = this.models().stairsInner(stairsDir + this.name((class_2248)block) + "_inner_1", tex1, tex1, tex1);
        ModelBuilder inner2 = this.models().stairsInner(stairsDir + this.name((class_2248)block) + "_inner_2", tex2, tex2, tex2);
        ModelBuilder inner3 = this.models().stairsInner(stairsDir + this.name((class_2248)block) + "_inner_3", tex3, tex3, tex3);
        ModelBuilder outer0 = this.models().stairsOuter(stairsDir + this.name((class_2248)block) + "_outer", tex0, tex0, tex0);
        ModelBuilder outer1 = this.models().stairsOuter(stairsDir + this.name((class_2248)block) + "_outer_1", tex1, tex1, tex1);
        ModelBuilder outer2 = this.models().stairsOuter(stairsDir + this.name((class_2248)block) + "_outer_2", tex2, tex2, tex2);
        ModelBuilder outer3 = this.models().stairsOuter(stairsDir + this.name((class_2248)block) + "_outer_3", tex3, tex3, tex3);
        this.getVariantBuilder((class_2248)block).forAllStatesExcept(arg_0 -> BlockModelHelpers.lambda$woodStairs$3((ModelFile)main0, (ModelFile)inner0, (ModelFile)outer0, (ModelFile)main1, (ModelFile)inner1, (ModelFile)outer1, (ModelFile)main2, (ModelFile)inner2, (ModelFile)outer2, (ModelFile)main3, (ModelFile)inner3, (ModelFile)outer3, arg_0), new class_2769[]{class_2510.field_11573});
    }

    protected void banister(BanisterBlock banister, String texName, String woodVariant) {
        String banisterDir = "block/wood/banister/" + woodVariant + "/";
        class_2960 tex0 = TwilightForestMod.prefix("block/wood/" + texName + "_0");
        class_2960 tex1 = TwilightForestMod.prefix("block/wood/" + texName + "_1");
        class_2960 tex2 = TwilightForestMod.prefix("block/wood/" + texName + "_2");
        class_2960 tex3 = TwilightForestMod.prefix("block/wood/" + texName + "_3");
        this.getVariantBuilder((class_2248)banister).forAllStatesExcept(state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)BanisterBlock.field_11177);
            int yRot = (int)facing.method_10144();
            String extended = (Boolean)state.method_11654((class_2769)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)((Object)((Object)state.method_11654(BanisterBlock.SHAPE)))).method_15434() + extended;
            String newModelName = banisterDir + this.name((class_2248)banister) + "_" + variant;
            return ConfiguredModel.builder().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName, TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex0)).rotationY(yRot).nextModel().weight(10).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_1", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex1)).rotationY(yRot).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_2", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex2)).rotationY(yRot).nextModel().weight(1).modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(newModelName + "_3", TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex3)).rotationY(yRot).build();
        }, new class_2769[]{BanisterBlock.WATERLOGGED});
    }

    protected void banisterVanilla(BanisterBlock banister, String texName, String woodVariant) {
        String banisterDir = "block/wood/banister/" + woodVariant + "/";
        class_2960 tex0 = new class_2960("block/" + texName);
        this.getVariantBuilder((class_2248)banister).forAllStatesExcept(state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)BanisterBlock.field_11177);
            int yRot = (int)facing.method_10144();
            String extended = (Boolean)state.method_11654((class_2769)BanisterBlock.EXTENDED) != false ? "_extended" : "";
            String variant = ((BanisterShape)((Object)((Object)state.method_11654(BanisterBlock.SHAPE)))).method_15434() + extended;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(banisterDir + this.name((class_2248)banister) + "_" + variant, TwilightForestMod.prefix("banister_" + variant))).texture("texture", tex0)).rotationY(yRot).build();
        }, new class_2769[]{BanisterBlock.WATERLOGGED});
    }

    protected void bisectedStairsBlock(RegistryObject<class_2510> block, class_2960 side, class_2960 end, class_2960 middle) {
        this.bisectedStairsBlock(block, block.getId().method_12832(), side, end, middle);
    }

    protected void bisectedStairsBlock(RegistryObject<class_2510> block, String name, class_2960 side, class_2960 end, class_2960 middle) {
        ModelBuilder stairs = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, TwilightForestMod.prefix("block/util/bisected_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        ModelBuilder stairsInner = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_inner", TwilightForestMod.prefix("block/util/bisected_inner_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        ModelBuilder stairsOuter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + "_outer", TwilightForestMod.prefix("block/util/bisected_outer_stairs"))).texture("side", side)).texture("end", end)).texture("middle", middle);
        this.stairsBlock((class_2510)block.get(), (ModelFile)stairs, (ModelFile)stairsInner, (ModelFile)stairsOuter);
    }

    protected class_2960 key(class_2248 block) {
        return class_2378.field_11146.method_10221((Object)block);
    }

    protected String name(class_2248 block) {
        return this.key(block).method_12832();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodStairs$3(ModelFile main0, ModelFile inner0, ModelFile outer0, ModelFile main1, ModelFile inner1, ModelFile outer1, ModelFile main2, ModelFile inner2, ModelFile outer2, ModelFile main3, ModelFile inner3, ModelFile outer3, class_2680 state) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
        class_2760 half = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
        class_2778 shape = (class_2778)state.method_11654((class_2769)class_2510.field_11565);
        int yRot = (int)facing.method_10170().method_10144();
        if (shape == class_2778.field_12712 || shape == class_2778.field_12708) {
            yRot += 270;
        }
        if (shape != class_2778.field_12710 && half == class_2760.field_12619) {
            yRot += 90;
        }
        boolean uvlock = (yRot %= 360) != 0 || half == class_2760.field_12619;
        return ConfiguredModel.builder().weight(10).modelFile(shape == class_2778.field_12710 ? main0 : (shape == class_2778.field_12712 || shape == class_2778.field_12713 ? inner0 : outer0)).rotationX(half == class_2760.field_12617 ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(10).modelFile(shape == class_2778.field_12710 ? main1 : (shape == class_2778.field_12712 || shape == class_2778.field_12713 ? inner1 : outer1)).rotationX(half == class_2760.field_12617 ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == class_2778.field_12710 ? main2 : (shape == class_2778.field_12712 || shape == class_2778.field_12713 ? inner2 : outer2)).rotationX(half == class_2760.field_12617 ? 0 : 180).rotationY(yRot).uvLock(uvlock).nextModel().weight(1).modelFile(shape == class_2778.field_12710 ? main3 : (shape == class_2778.field_12712 || shape == class_2778.field_12713 ? inner3 : outer3)).rotationX(half == class_2760.field_12617 ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodButton$2(ModelFile pressed0, ModelFile unpressed0, ModelFile pressed1, ModelFile unpressed1, ModelFile pressed2, ModelFile unpressed2, ModelFile pressed3, ModelFile unpressed3, class_2680 state) {
        ModelFile model0 = (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false ? pressed0 : unpressed0;
        ModelFile model1 = (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false ? pressed1 : unpressed1;
        ModelFile model2 = (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false ? pressed2 : unpressed2;
        ModelFile model3 = (Boolean)state.method_11654((class_2769)class_2269.field_10729) != false ? pressed3 : unpressed3;
        int rotX = switch ((class_2738)state.method_11654((class_2769)class_2341.field_11007)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2738.field_12471 -> 90;
            case class_2738.field_12475 -> 0;
            case class_2738.field_12473 -> 180;
        };
        int rotY = 0;
        if (state.method_11654((class_2769)class_2341.field_11007) == class_2738.field_12473) {
            switch ((class_2350)state.method_11654((class_2769)class_2383.field_11177)) {
                case field_11043: {
                    rotY = 180;
                    break;
                }
                case field_11039: {
                    rotY = 90;
                    break;
                }
                case field_11034: {
                    rotY = 270;
                }
            }
        } else {
            switch ((class_2350)state.method_11654((class_2769)class_2383.field_11177)) {
                case field_11035: {
                    rotY = 180;
                    break;
                }
                case field_11039: {
                    rotY = 270;
                    break;
                }
                case field_11034: {
                    rotY = 90;
                }
            }
        }
        boolean uvlock = state.method_11654((class_2769)class_2341.field_11007) == class_2738.field_12471;
        return ConfiguredModel.builder().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model0).nextModel().weight(10).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model1).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model2).nextModel().weight(1).uvLock(uvlock).rotationX(rotX).rotationY(rotY).modelFile(model3).build();
    }

    private static /* synthetic */ void lambda$woodFence$1(MultiPartBlockStateBuilder builder, ModelFile side0, ModelFile side1, ModelFile side2, ModelFile side3, class_2350 dir, class_2746 value) {
        if (dir.method_10166().method_10179()) {
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().weight(10).modelFile(side0).rotationY(((int)dir.method_10144() + 180) % 360).uvLock(true).nextModel().weight(10).modelFile(side1).rotationY(((int)dir.method_10144() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side2).rotationY(((int)dir.method_10144() + 180) % 360).uvLock(true).nextModel().weight(1).modelFile(side3).rotationY(((int)dir.method_10144() + 180) % 360).uvLock(true).addModel()).condition((class_2769)value, (Comparable[])new Boolean[]{true});
        }
    }

    private static /* synthetic */ ConfiguredModel[] lambda$woodGate$0(ModelFile gate0, ModelFile gate1, ModelFile gate2, ModelFile gate3, ModelFile wall0, ModelFile wall1, ModelFile wall2, ModelFile wall3, ModelFile wallOpen0, ModelFile open0, ModelFile wallOpen1, ModelFile open1, ModelFile wallOpen2, ModelFile open2, ModelFile wallOpen3, ModelFile open3, class_2680 state) {
        ModelFile model0 = gate0;
        ModelFile model1 = gate1;
        ModelFile model2 = gate2;
        ModelFile model3 = gate3;
        if (((Boolean)state.method_11654((class_2769)class_2349.field_11024)).booleanValue()) {
            model0 = wall0;
            model1 = wall1;
            model2 = wall2;
            model3 = wall3;
        }
        if (((Boolean)state.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
            model0 = model0 == wall0 ? wallOpen0 : open0;
            model1 = model1 == wall1 ? wallOpen1 : open1;
            model2 = model2 == wall2 ? wallOpen2 : open2;
            model3 = model3 == wall3 ? wallOpen3 : open3;
        }
        return ConfiguredModel.builder().weight(10).modelFile(model0).rotationY((int)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10144()).uvLock(true).nextModel().weight(10).modelFile(model1).rotationY((int)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10144()).uvLock(true).nextModel().weight(1).modelFile(model2).rotationY((int)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10144()).uvLock(true).nextModel().weight(1).modelFile(model3).rotationY((int)((class_2350)state.method_11654((class_2769)class_2383.field_11177)).method_10144()).uvLock(true).build();
    }
}

