/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import twilightforest.entity.boss.Naga;
import twilightforest.init.TFSounds;
import twilightforest.util.EntityUtil;

public class NagaMovementPattern
extends class_1352 {
    private final Naga naga;
    private MovementState state;
    private int stateCounter;
    private boolean clockwise;

    public NagaMovementPattern(Naga naga) {
        this.naga = naga;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.method_6270();
    }

    public boolean method_6264() {
        return this.naga.method_5968() != null && this.naga.areSelfAndTargetInHome((class_1297)this.naga.method_5968());
    }

    public void method_6270() {
        this.state = MovementState.CIRCLE;
        this.stateCounter = 15;
        this.clockwise = false;
    }

    public void method_6268() {
        if (!this.naga.method_5942().method_6357()) {
            if (this.naga.method_5942().method_31267()) {
                this.naga.method_5942().method_6340();
            }
            return;
        }
        switch (this.state) {
            case INTIMIDATE: {
                this.naga.method_5942().method_6340();
                this.naga.method_5988().method_6226((class_1297)this.naga.method_5968(), 30.0f, 30.0f);
                this.naga.method_5951((class_1297)this.naga.method_5968(), 30.0f, 30.0f);
                this.naga.field_6250 = 0.1f;
                break;
            }
            case CRUMBLE: {
                this.naga.method_5942().method_6340();
                this.crumbleBelowTarget(2);
                this.crumbleBelowTarget(3);
                break;
            }
            case CHARGE: {
                class_2338 tpoint = this.findCirclePoint(this.clockwise, 14.0, Math.PI);
                this.naga.method_5942().method_6337((double)tpoint.method_10263(), (double)tpoint.method_10264(), (double)tpoint.method_10260(), 1.0);
                this.naga.setCharging(true);
                break;
            }
            case CIRCLE: {
                double radius = this.stateCounter % 2 == 0 ? 12.0 : 14.0;
                double rotation = 1.0;
                if (this.stateCounter == 2) {
                    radius = 16.0;
                }
                if (this.stateCounter == 1) {
                    rotation = 0.1;
                }
                class_2338 tpoint = this.findCirclePoint(this.clockwise, radius, rotation);
                this.naga.method_5942().method_6337((double)tpoint.method_10263(), (double)tpoint.method_10264(), (double)tpoint.method_10260(), 1.0);
                break;
            }
            case DAZE: {
                this.naga.method_5942().method_6340();
                this.naga.setDazed(true);
                this.naga.setCharging(false);
            }
        }
        --this.stateCounter;
        if (this.stateCounter <= 0) {
            this.transitionState();
        }
    }

    private void transitionState() {
        this.naga.setDazed(false);
        this.naga.setCharging(false);
        switch (this.state) {
            case INTIMIDATE: {
                boolean bl = this.clockwise = !this.clockwise;
                if (this.naga.method_5968().method_5829().field_1322 > this.naga.method_5829().field_1325) {
                    this.doCrumblePlayer();
                    break;
                }
                this.doCharge();
                break;
            }
            case CRUMBLE: {
                this.doCharge();
                break;
            }
            case CHARGE: 
            case DAZE: {
                this.doCircle();
                break;
            }
            case CIRCLE: {
                this.doIntimidate();
            }
        }
    }

    public void doDaze() {
        this.state = MovementState.DAZE;
        this.naga.method_5942().method_6340();
        this.stateCounter = 60 + this.naga.method_6051().method_43048(40);
    }

    public void doCircle() {
        this.state = MovementState.CIRCLE;
        this.stateCounter += 10 + this.naga.method_6051().method_43048(10);
        this.naga.goNormal();
    }

    public void doCrumblePlayer() {
        this.state = MovementState.CRUMBLE;
        this.stateCounter = 20 + this.naga.method_6051().method_43048(20);
        this.naga.goSlow();
    }

    private void doCharge() {
        this.state = MovementState.CHARGE;
        this.stateCounter = 3;
        this.naga.goFast();
    }

    private void doIntimidate() {
        this.state = MovementState.INTIMIDATE;
        this.naga.method_5783((class_3414)TFSounds.NAGA_RATTLE.get(), 4.0f, this.naga.method_6017());
        this.naga.method_32876(class_5712.field_28728);
        this.stateCounter += 15 + this.naga.method_6051().method_43048(10);
        this.naga.goSlow();
    }

    private void crumbleBelowTarget(int range) {
        if (!this.naga.method_37908().method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        int targetY = (int)this.naga.method_5968().method_5829().field_1322;
        int floor = (int)this.naga.method_5829().field_1322;
        if (targetY > floor) {
            int dx = (int)this.naga.method_5968().method_23317() + this.naga.method_6051().method_43048(range) - this.naga.method_6051().method_43048(range);
            int dz = (int)this.naga.method_5968().method_23321() + this.naga.method_6051().method_43048(range) - this.naga.method_6051().method_43048(range);
            int dy = targetY - this.naga.method_6051().method_43048(range) + this.naga.method_6051().method_43048(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            class_2338 pos = new class_2338(dx, dy, dz);
            if (EntityUtil.canDestroyBlock(this.naga.method_37908(), pos, (class_1297)this.naga)) {
                this.naga.method_37908().method_22352(pos, true);
                for (int k = 0; k < 20; ++k) {
                    double d = this.naga.method_6051().method_43059() * 0.02;
                    double d1 = this.naga.method_6051().method_43059() * 0.02;
                    double d2 = this.naga.method_6051().method_43059() * 0.02;
                    this.naga.method_37908().method_8406((class_2394)class_2398.field_11205, this.naga.method_23317() + (double)(this.naga.method_6051().method_43057() * this.naga.method_17681() * 2.0f) - (double)this.naga.method_17681(), this.naga.method_23318() + (double)(this.naga.method_6051().method_43057() * this.naga.method_17682()), this.naga.method_23321() + (double)(this.naga.method_6051().method_43057() * this.naga.method_17681() * 2.0f) - (double)this.naga.method_17681(), d, d1, d2);
                }
            }
        }
    }

    private class_2338 findCirclePoint(boolean clockwise, double radius, double rotation) {
        class_1309 toCircle = this.naga.method_5968();
        double vecx = this.naga.method_23317() - toCircle.method_23317();
        double vecz = this.naga.method_23321() - toCircle.method_23321();
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + (clockwise ? rotation : -rotation));
        double dx = (double)class_3532.method_15362((float)rangle) * radius;
        double dz = (double)class_3532.method_15374((float)rangle) * radius;
        double dy = Math.min(this.naga.method_5829().field_1322, toCircle.method_23318());
        return new class_2338(toCircle.method_23317() + dx, dy, toCircle.method_23321() + dz);
    }

    public MovementState getState() {
        return this.state;
    }

    public static enum MovementState {
        INTIMIDATE,
        CRUMBLE,
        CHARGE,
        CIRCLE,
        DAZE;

    }
}

