/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraMortarHead;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;

public class HydraHeadContainer {
    private static final int FLAME_BURN_FACTOR = 3;
    private static final int FLAME_DAMAGE = 19;
    private static final int BITE_DAMAGE = 48;
    private static double FLAME_BREATH_TRACKING_SPEED = 0.04;
    private static final State NEXT_AUTOMATIC = null;
    public final HydraHead headEntity;
    public final HydraNeck necka;
    public final HydraNeck neckb;
    public final HydraNeck neckc;
    public final HydraNeck neckd;
    public final HydraNeck necke;
    public class_1297 targetEntity;
    private double targetX;
    private double targetY;
    private double targetZ;
    private State prevState;
    private State currentState;
    private State nextState;
    public boolean isSecondaryAttacking;
    private int ticksNeeded;
    private int ticksProgress;
    private final int headNum;
    private int damageTaken;
    private int respawnCounter;
    private final Hydra hydra;
    private final Map<State, Float>[] stateNeckLength;
    private final Map<State, Float>[] stateXRotations;
    private final Map<State, Float>[] stateYRotations;
    private final Map<State, Float>[] stateMouthOpen;

    public HydraHeadContainer(Hydra hydra, int number, boolean startActive) {
        this.headNum = number;
        this.hydra = hydra;
        this.damageTaken = 0;
        this.respawnCounter = -1;
        this.headEntity = new HydraHead(hydra);
        this.headEntity.method_5814(hydra.method_23317(), hydra.method_23318(), hydra.method_23321());
        this.necka = new HydraNeck(this.headEntity);
        this.neckb = new HydraNeck(this.headEntity);
        this.neckc = new HydraNeck(this.headEntity);
        this.neckd = new HydraNeck(this.headEntity);
        this.necke = new HydraNeck(this.headEntity);
        this.stateNeckLength = new Map[this.hydra.numHeads];
        this.stateXRotations = new Map[this.hydra.numHeads];
        this.stateYRotations = new Map[this.hydra.numHeads];
        this.stateMouthOpen = new Map[this.hydra.numHeads];
        for (int i = 0; i < this.hydra.numHeads; ++i) {
            this.stateNeckLength[i] = new EnumMap<State, Float>(State.class);
            this.stateXRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateYRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateMouthOpen[i] = new EnumMap<State, Float>(State.class);
        }
        this.setupStateRotations();
        if (startActive) {
            this.prevState = State.IDLE;
            this.currentState = State.IDLE;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 60;
            this.ticksProgress = 60;
        } else {
            this.prevState = State.DEAD;
            this.currentState = State.DEAD;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 20;
            this.ticksProgress = 20;
        }
        this.setHeadPosition();
        this.setNeckPosition();
    }

    protected void setupStateRotations() {
        this.setAnimation(0, State.IDLE, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.IDLE, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.IDLE, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.IDLE, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.IDLE, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.IDLE, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.IDLE, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ATTACK_COOLDOWN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.ATTACK_COOLDOWN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.ATTACK_COOLDOWN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.ATTACK_COOLDOWN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.ATTACK_COOLDOWN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.ATTACK_COOLDOWN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.ATTACK_COOLDOWN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.FLAME_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.FLAME_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.FLAME_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.FLAME_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.FLAME_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.FLAME_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.FLAME_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.FLAMING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.FLAMING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.FLAMING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.FLAMING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.FLAMING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.FLAMING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.FLAMING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.FLAME_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.FLAME_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.FLAME_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.FLAME_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.FLAME_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.FLAME_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.FLAME_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.BITE_BEGINNING, -5.0f, 60.0f, 5.0f, 0.25f);
        this.setAnimation(1, State.BITE_BEGINNING, -10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.BITE_BEGINNING, -10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.BITE_READY, -5.0f, 60.0f, 5.0f, 1.0f);
        this.setAnimation(1, State.BITE_READY, -10.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.BITE_READY, -10.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.BITING, -5.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(1, State.BITING, -10.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(2, State.BITING, -10.0f, 30.0f, 5.0f, 0.2f);
        this.setAnimation(0, State.BITE_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BITE_ENDING, -10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BITE_ENDING, -10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.MORTAR_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.MORTAR_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.MORTAR_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.MORTAR_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.MORTAR_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.MORTAR_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.MORTAR_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.MORTAR_SHOOTING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.MORTAR_SHOOTING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.MORTAR_SHOOTING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.MORTAR_SHOOTING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.MORTAR_SHOOTING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.MORTAR_SHOOTING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.MORTAR_SHOOTING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.MORTAR_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.MORTAR_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.MORTAR_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.MORTAR_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.MORTAR_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.MORTAR_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.MORTAR_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DYING, -20.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.DYING, -20.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.DYING, -20.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.DYING, -20.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.DYING, -20.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.DYING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.DYING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(1, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(2, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(3, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(4, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(5, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(6, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(0, State.BORN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BORN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BORN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.BORN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.BORN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.BORN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.BORN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ROAR_START, 60.0f, 0.0f, 7.0f, 0.25f);
        this.setAnimation(1, State.ROAR_START, 10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.ROAR_START, 10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(3, State.ROAR_START, 50.0f, 90.0f, 8.0f, 0.25f);
        this.setAnimation(4, State.ROAR_START, 50.0f, -90.0f, 8.0f, 0.25f);
        this.setAnimation(5, State.ROAR_START, -10.0f, 90.0f, 9.0f, 0.25f);
        this.setAnimation(6, State.ROAR_START, -10.0f, -90.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.ROAR_RAWR, 60.0f, 0.0f, 9.0f, 1.0f);
        this.setAnimation(1, State.ROAR_RAWR, 10.0f, 60.0f, 11.0f, 1.0f);
        this.setAnimation(2, State.ROAR_RAWR, 10.0f, -60.0f, 11.0f, 1.0f);
        this.setAnimation(3, State.ROAR_RAWR, 50.0f, 90.0f, 10.0f, 1.0f);
        this.setAnimation(4, State.ROAR_RAWR, 50.0f, -90.0f, 10.0f, 1.0f);
        this.setAnimation(5, State.ROAR_RAWR, -10.0f, 90.0f, 11.0f, 1.0f);
        this.setAnimation(6, State.ROAR_RAWR, -10.0f, -90.0f, 11.0f, 1.0f);
    }

    private void setAnimation(int head, State state, float xRotation, float yRotation, float neckLength, float mouthOpen) {
        this.stateXRotations[head].put(state, Float.valueOf(xRotation));
        this.stateYRotations[head].put(state, Float.valueOf(yRotation));
        this.stateNeckLength[head].put(state, Float.valueOf(neckLength));
        this.stateMouthOpen[head].put(state, Float.valueOf(mouthOpen));
    }

    public HydraNeck[] getNeckArray() {
        return new HydraNeck[]{this.necka, this.neckb, this.neckc, this.neckd, this.necke};
    }

    public void tick() {
        this.headEntity.method_5773();
        this.necka.method_5773();
        this.neckb.method_5773();
        this.neckc.method_5773();
        this.neckd.method_5773();
        this.necke.method_5773();
        this.setDifficultyVariables();
        if (!this.hydra.method_37908().method_8608()) {
            if (this.isActive() && this.headEntity.field_18065.field_18067 == 0.0f) {
                this.headEntity.activate();
                this.necka.activate();
                this.neckb.activate();
                this.neckc.activate();
                this.neckd.activate();
                this.necke.activate();
            } else if (!this.isActive() && this.headEntity.field_18065.field_18067 > 0.0f) {
                this.headEntity.deactivate();
                this.necka.deactivate();
                this.neckb.deactivate();
                this.neckc.deactivate();
                this.neckd.deactivate();
                this.necke.deactivate();
            }
            this.advanceRespawnCounter();
            this.advanceHeadState();
            this.setHeadPosition();
            this.setHeadFacing();
            this.executeAttacks();
            this.playSounds();
        } else {
            this.clientAnimateHeadDeath();
            this.addMouthParticles();
        }
        this.setNeckPosition();
    }

    public boolean canRespawn() {
        return this.currentState == State.DEAD && this.respawnCounter == -1;
    }

    private void advanceRespawnCounter() {
        if (this.currentState == State.DEAD && this.respawnCounter > -1 && --this.respawnCounter <= 0) {
            this.setNextState(State.BORN);
            this.damageTaken = 0;
            this.endCurrentAction();
            this.respawnCounter = -1;
        }
    }

    private void clientAnimateHeadDeath() {
        if (this.headEntity.getState() == State.DYING) {
            ++this.headEntity.deathTime;
            if (this.headEntity.deathTime > 0) {
                if (this.headEntity.deathTime < 20) {
                    this.doExplosionOn(this.headEntity, true);
                } else if (this.headEntity.deathTime < 30) {
                    this.doExplosionOn(this.necka, false);
                } else if (this.headEntity.deathTime < 40) {
                    this.doExplosionOn(this.neckb, false);
                } else if (this.headEntity.deathTime < 50) {
                    this.doExplosionOn(this.neckc, false);
                } else if (this.headEntity.deathTime < 60) {
                    this.doExplosionOn(this.neckd, false);
                } else if (this.headEntity.deathTime < 70) {
                    this.doExplosionOn(this.necke, false);
                }
            }
            this.necka.hurtTime = 20;
            this.neckb.hurtTime = 20;
            this.neckc.hurtTime = 20;
            this.neckd.hurtTime = 20;
            this.necke.hurtTime = 20;
        } else {
            this.headEntity.deathTime = 0;
            Objects.requireNonNull(this.headEntity);
            this.headEntity.health = 1000.0f;
        }
    }

    private void doExplosionOn(HydraPart part, boolean large) {
        for (int i = 0; i < 5; ++i) {
            double vx = part.method_37908().method_8409().method_43059() * 0.02;
            double vy = part.method_37908().method_8409().method_43059() * 0.02;
            double vz = part.method_37908().method_8409().method_43059() * 0.02;
            part.method_37908().method_8406((class_2394)(part.method_37908().method_8409().method_43048(5) == 0 || large ? class_2398.field_11236 : class_2398.field_11203), part.method_23317() + (double)(part.method_37908().method_8409().method_43057() * 2.0f), part.method_23318() + (double)(part.method_37908().method_8409().method_43057() * 2.0f), part.method_23321() + (double)(part.method_37908().method_8409().method_43057() * 2.0f), vx, vy, vz);
        }
    }

    private void advanceHeadState() {
        if (++this.ticksProgress >= this.ticksNeeded) {
            State myNext;
            if (this.nextState == NEXT_AUTOMATIC) {
                myNext = State.NEXT_STATE.get((Object)this.currentState);
                if (myNext != this.currentState && this.isSecondaryAttacking && myNext == State.ATTACK_COOLDOWN) {
                    this.isSecondaryAttacking = false;
                    myNext = State.IDLE;
                }
            } else {
                myNext = this.nextState;
                this.nextState = NEXT_AUTOMATIC;
            }
            this.ticksNeeded = myNext.duration;
            this.ticksProgress = 0;
            this.prevState = this.currentState;
            this.currentState = myNext;
        }
        if (this.headEntity.getState() != this.currentState) {
            this.headEntity.setState(this.currentState);
        }
    }

    private void setHeadFacing() {
        if (this.currentState == State.BITE_READY) {
            float yawOffOffset;
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.method_5978());
            float biteMaxYaw = -60.0f;
            float biteMinYaw = -90.0f;
            if (this.headNum == 2) {
                biteMaxYaw = 60.0f;
                biteMinYaw = 90.0f;
            }
            if ((yawOffOffset = class_3532.method_15393((float)(this.headEntity.method_36454() - this.hydra.field_6283))) > biteMaxYaw) {
                this.headEntity.method_36456(this.hydra.field_6283 + biteMaxYaw);
            }
            if (yawOffOffset < biteMinYaw) {
                this.headEntity.method_36456(this.hydra.field_6283 + biteMinYaw);
            }
            class_243 look = this.headEntity.method_5720();
            double distance = 16.0;
            this.targetX = this.headEntity.method_23317() + look.method_10216() * distance;
            this.targetY = this.headEntity.method_23318() + 1.5 + look.method_10214() * distance;
            this.targetZ = this.headEntity.method_23321() + look.method_10215() * distance;
        } else if (this.currentState == State.BITING || this.currentState == State.BITE_ENDING) {
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.method_5978());
            this.headEntity.method_36457((float)((double)this.headEntity.method_36455() + 0.7853981633974483));
        } else if (this.currentState == State.ROAR_RAWR) {
            this.faceVec(this.targetX, this.targetY, this.targetZ, 10.0f, this.hydra.method_5978());
        } else if (this.currentState == State.FLAMING || this.currentState == State.FLAME_BEGINNING) {
            this.moveTargetCoordsTowardsTargetEntity(FLAME_BREATH_TRACKING_SPEED);
            this.faceVec(this.targetX, this.targetY, this.targetZ, 5.0f, this.hydra.method_5978());
        } else if (this.isActive()) {
            if (this.targetEntity != null) {
                this.faceEntity(this.targetEntity, 5.0f, this.hydra.method_5978());
            } else {
                this.faceIdle(1.5f, this.hydra.method_5978());
            }
        }
    }

    private void moveTargetCoordsTowardsTargetEntity(double distance) {
        if (this.targetEntity != null) {
            class_243 vect = new class_243(this.targetEntity.method_23317() - this.targetX, this.targetEntity.method_23318() - this.targetY, this.targetEntity.method_23321() - this.targetZ);
            vect = vect.method_1029();
            this.targetX += vect.method_10216() * distance;
            this.targetY += vect.method_10214() * distance;
            this.targetZ += vect.method_10215() * distance;
        }
    }

    private void addMouthParticles() {
        class_243 vector = this.headEntity.method_5720();
        double dist = 3.5;
        double px = this.headEntity.method_23317() + vector.method_10216() * dist;
        double py = this.headEntity.method_23318() + 1.0 + vector.method_10214() * dist;
        double pz = this.headEntity.method_23321() + vector.method_10215() * dist;
        if (this.headEntity.getState() == State.FLAME_BEGINNING) {
            this.headEntity.method_37908().method_8494((class_2394)class_2398.field_11240, px + this.headEntity.method_37908().method_8409().method_43058() - 0.5, py + this.headEntity.method_37908().method_8409().method_43058() - 0.5, pz + this.headEntity.method_37908().method_8409().method_43058() - 0.5, 0.0, 0.0, 0.0);
            this.headEntity.method_37908().method_8494((class_2394)class_2398.field_11251, px + this.headEntity.method_37908().method_8409().method_43058() - 0.5, py + this.headEntity.method_37908().method_8409().method_43058() - 0.5, pz + this.headEntity.method_37908().method_8409().method_43058() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.FLAMING) {
            class_243 look = this.headEntity.method_5720();
            for (int i = 0; i < 5; ++i) {
                double dx = look.method_10216();
                double dy = look.method_10214();
                double dz = look.method_10215();
                double spread = 5.0 + this.headEntity.method_37908().method_8409().method_43058() * 2.5;
                double velocity = 1.0 + this.headEntity.method_37908().method_8409().method_43058();
                dx += this.headEntity.method_37908().method_8409().method_43059() * 0.0075 * spread;
                dy += this.headEntity.method_37908().method_8409().method_43059() * 0.0075 * spread;
                dz += this.headEntity.method_37908().method_8409().method_43059() * 0.0075 * spread;
                this.headEntity.method_37908().method_8494((class_2394)TFParticleType.LARGE_FLAME.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
        if (this.headEntity.getState() == State.BITE_BEGINNING || this.headEntity.getState() == State.BITE_READY) {
            this.headEntity.method_37908().method_8494((class_2394)class_2398.field_11202, px + this.headEntity.method_37908().method_8409().method_43058() - 0.5, py + this.headEntity.method_37908().method_8409().method_43058() - 0.5, pz + this.headEntity.method_37908().method_8409().method_43058() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.MORTAR_BEGINNING) {
            this.headEntity.method_37908().method_8494((class_2394)class_2398.field_11237, px + this.headEntity.method_37908().method_8409().method_43058() - 0.5, py + this.headEntity.method_37908().method_8409().method_43058() - 0.5, pz + this.headEntity.method_37908().method_8409().method_43058() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void playSounds() {
        if (this.headEntity.getState() == State.FLAMING && this.headEntity.field_6012 % 5 == 0) {
            this.headEntity.method_5783((class_3414)TFSounds.HYDRA_SHOOT_FIRE.get(), 0.5f + this.headEntity.method_37908().method_8409().method_43057(), this.headEntity.method_37908().method_8409().method_43057() * 0.7f + 0.3f);
            this.headEntity.method_32876(class_5712.field_28161);
        }
        if (this.headEntity.getState() == State.ROAR_RAWR) {
            this.headEntity.method_5783((class_3414)TFSounds.HYDRA_ROAR.get(), 1.25f, this.headEntity.method_37908().method_8409().method_43057() * 0.3f + 0.7f);
            this.headEntity.method_32876(class_5712.field_28728);
        }
        if (this.headEntity.getState() == State.BITE_READY && this.ticksProgress == 60) {
            this.headEntity.method_5783((class_3414)TFSounds.HYDRA_WARN.get(), 2.0f, this.headEntity.method_37908().method_8409().method_43057() * 0.3f + 0.7f);
        }
    }

    protected void setNeckPosition() {
        class_243 vector = null;
        float neckRotation = 0.0f;
        if (this.headNum == 0) {
            vector = new class_243(0.0, 3.0, -1.0);
            neckRotation = 0.0f;
        }
        if (this.headNum == 1) {
            vector = new class_243(-1.0, 3.0, 3.0);
            neckRotation = 90.0f;
        }
        if (this.headNum == 2) {
            vector = new class_243(1.0, 3.0, 3.0);
            neckRotation = -90.0f;
        }
        if (this.headNum == 3) {
            vector = new class_243(-1.0, 3.0, 3.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 4) {
            vector = new class_243(1.0, 3.0, 3.0);
            neckRotation = -135.0f;
        }
        if (this.headNum == 5) {
            vector = new class_243(-1.0, 3.0, 5.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 6) {
            vector = new class_243(1.0, 3.0, 5.0);
            neckRotation = -135.0f;
        }
        vector = vector.method_1024(-(this.hydra.field_6283 + neckRotation) * (float)Math.PI / 180.0f);
        this.setNeckPosition(this.hydra.method_23317() + vector.method_10216(), this.hydra.method_23318() + vector.method_10214(), this.hydra.method_23321() + vector.method_10215(), this.hydra.field_6283);
    }

    protected void setHeadPosition() {
        float periodX;
        float neckLength = this.getCurrentNeckLength();
        float xRotation = this.getCurrentHeadXRotation();
        float yRotation = this.getCurrentHeadYRotation();
        float f = this.headNum == 0 || this.headNum == 3 ? 20.0f : (periodX = this.headNum == 1 || this.headNum == 4 ? 5.0f : 7.0f);
        float periodY = this.headNum == 0 || this.headNum == 4 ? 10.0f : (this.headNum == 1 || this.headNum == 6 ? 6.0f : 5.0f);
        float xSwing = class_3532.method_15374((float)((float)this.hydra.field_6012 / periodX)) * 3.0f;
        float ySwing = class_3532.method_15374((float)((float)this.hydra.field_6012 / periodY)) * 5.0f;
        if (!this.isActive()) {
            ySwing = 0.0f;
            xSwing = 0.0f;
        }
        class_243 vector = new class_243(0.0, 0.0, (double)neckLength);
        vector = vector.method_1037((xRotation * (float)Math.PI + xSwing) / 180.0f);
        vector = vector.method_1024(-(this.hydra.field_6283 + yRotation + ySwing) * (float)Math.PI / 180.0f);
        double dx = this.hydra.method_23317() + vector.method_10216();
        double dy = this.hydra.method_23318() + vector.method_10214() + 3.0;
        double dz = this.hydra.method_23321() + vector.method_10215();
        this.headEntity.method_5814(dx, dy, dz);
        this.headEntity.setMouthOpen(this.getCurrentMouthOpen());
    }

    private void executeAttacks() {
        class_1297 target;
        if (this.currentState == State.MORTAR_SHOOTING && this.ticksProgress % 10 == 0) {
            HydraMortarHead mortar = new HydraMortarHead((class_1299<? extends HydraMortarHead>)((class_1299)TFEntities.HYDRA_MORTAR.get()), this.headEntity.method_37908(), this.headEntity);
            if (this.targetEntity != null && !this.headEntity.canEntityBeSeen(this.targetEntity)) {
                mortar.setToBlasting();
            }
            this.headEntity.method_5783((class_3414)TFSounds.HYDRA_SHOOT.get(), 10.0f, (this.headEntity.method_37908().method_8409().method_43057() - this.headEntity.method_37908().method_8409().method_43057()) * 0.2f + 1.0f);
            this.headEntity.method_37908().method_8649((class_1297)mortar);
        }
        if (this.headEntity.getState() == State.BITING) {
            List nearbyList = this.headEntity.method_37908().method_8335((class_1297)this.headEntity, this.headEntity.method_5829().method_1009(0.0, 1.0, 0.0));
            for (class_1297 nearby : nearbyList) {
                class_1657 player;
                if (!(nearby instanceof class_1309)) continue;
                class_1309 living = (class_1309)nearby;
                if (nearby == this.hydra) continue;
                if (nearby instanceof class_1657 && (player = (class_1657)nearby).method_6115() && player.method_6030().method_7909() instanceof class_1819) {
                    if (!player.method_7357().method_7904(player.method_6030().method_7909())) {
                        this.headEntity.method_37908().method_8396(null, player.method_24515(), player.method_6030().method_31574(class_1802.field_8255) ? (class_3414)TFSounds.WOOD_SHIELD_SHATTERS.get() : (class_3414)TFSounds.METAL_SHIELD_SHATTERS.get(), class_3419.field_15248, 1.0f, player.method_6017());
                        player.method_6030().method_7956(112, (class_1309)player, event -> event.method_20236(player.method_6058()));
                    }
                    player.method_7357().method_7906(player.method_6030().method_7909(), 200);
                    TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new ThrowPlayerPacket((float)(-this.headEntity.method_5735().method_10148()) * 0.5f, 0.15f, (float)(-this.headEntity.method_5735().method_10165()) * 0.5f), (class_3222)player);
                }
                nearby.method_5643(TFDamageSources.HYDRA_BITE, 48.0f);
                if (living instanceof class_1657) {
                    player = (class_1657)living;
                    TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new ThrowPlayerPacket((float)(-this.headEntity.method_5735().method_10148()) * 0.5f, 0.1f, (float)(-this.headEntity.method_5735().method_10165()) * 0.5f), (class_3222)player);
                    continue;
                }
                living.method_6005((double)(-this.headEntity.method_5735().method_10148()), (double)0.1f, (double)(-this.headEntity.method_5735().method_10165()));
            }
        }
        if (!(this.headEntity.getState() != State.FLAMING || (target = this.getHeadLookTarget()) == null || target == this.headEntity.getParent() || target instanceof HydraPart && ((HydraPart)target).getParent() == this.headEntity.getParent() || target.method_5753() || !target.method_5643(TFDamageSources.HYDRA_FIRE, 19.0f))) {
            target.method_5639(3);
        }
    }

    private void setDifficultyVariables() {
        FLAME_BREATH_TRACKING_SPEED = this.hydra.method_37908().method_8407() != class_1267.field_5807 ? 0.04 : 0.1;
    }

    @Nullable
    private class_1297 getHeadLookTarget() {
        class_1297 pointedEntity = null;
        double range = 30.0;
        class_243 srcVec = new class_243(this.headEntity.method_23317(), this.headEntity.method_23318() + 1.0, this.headEntity.method_23321());
        class_243 lookVec = this.headEntity.method_5828(1.0f);
        class_3965 raytrace = this.headEntity.method_37908().method_17742(new class_3959(srcVec, srcVec.method_1031(lookVec.method_10216() * range, lookVec.method_10214() * range, lookVec.method_10215() * range), class_3959.class_3960.field_17559, class_3959.class_242.field_1347, (class_1297)this.headEntity));
        class_2338 hitpos = raytrace != null ? raytrace.method_17777() : null;
        double rx = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.method_23317() - (double)hitpos.method_10263()));
        double ry = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.method_23318() - (double)hitpos.method_10264()));
        double rz = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.method_23321() - (double)hitpos.method_10260()));
        class_243 destVec = srcVec.method_1031(lookVec.method_10216() * range, lookVec.method_10214() * range, lookVec.method_10215() * range);
        float var9 = 3.0f;
        List possibleList = this.headEntity.method_37908().method_8335((class_1297)this.headEntity, this.headEntity.method_5829().method_989(lookVec.method_10216() * rx, lookVec.method_10214() * ry, lookVec.method_10215() * rz).method_1009((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (class_1297 possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.method_5863() || possibleEntity == this.headEntity || possibleEntity == this.necka || possibleEntity == this.neckb || possibleEntity == this.neckc) continue;
            float borderSize = possibleEntity.method_5871();
            class_238 collisionBB = possibleEntity.method_5829().method_1009((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.method_992(srcVec, destVec);
            if (collisionBB.method_1006(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.method_1022((class_243)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void setNextState(State next) {
        this.nextState = next;
    }

    public void endCurrentAction() {
        this.ticksProgress = this.ticksNeeded;
    }

    private float getCurrentNeckLength() {
        float prevLength = this.stateNeckLength[this.headNum].get((Object)this.prevState).floatValue();
        float curLength = this.stateNeckLength[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return class_3532.method_37166((float)prevLength, (float)curLength, (float)progress);
    }

    private float getCurrentHeadXRotation() {
        float prevRotation = this.stateXRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateXRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return class_3532.method_37166((float)prevRotation, (float)currentRotation, (float)progress);
    }

    private float getCurrentHeadYRotation() {
        float prevRotation = this.stateYRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateYRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return class_3532.method_37166((float)prevRotation, (float)currentRotation, (float)progress);
    }

    protected float getCurrentMouthOpen() {
        float prevOpen = this.stateMouthOpen[this.headNum].get((Object)this.prevState).floatValue();
        float curOpen = this.stateMouthOpen[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return class_3532.method_37166((float)prevOpen, (float)curOpen, (float)progress);
    }

    protected void setNeckPosition(double startX, double startY, double startZ, float startYaw) {
        double endX = this.headEntity.method_23317();
        double endY = this.headEntity.method_23318();
        double endZ = this.headEntity.method_23321();
        float endYaw = this.headEntity.method_36454();
        float endPitch = this.headEntity.method_36455();
        while (startYaw - endYaw < -180.0f) {
            endYaw -= 360.0f;
        }
        while (startYaw - endYaw >= 180.0f) {
            endYaw += 360.0f;
        }
        while (0.0f - endPitch < -180.0f) {
            endPitch -= 360.0f;
        }
        while (0.0f - endPitch >= 180.0f) {
            endPitch += 360.0f;
        }
        if (endPitch > 0.0f) {
            vector = new class_243(0.0, 0.0, -1.0).method_1024(-endYaw * 3.141593f / 180.0f);
            endX += vector.method_10216();
            endY += vector.method_10214();
            endZ += vector.method_10215();
        } else {
            vector = this.headEntity.method_5720();
            float dist = 1.0f;
            endX -= vector.method_10216() * (double)dist;
            endY -= vector.method_10214() * (double)dist;
            endZ -= vector.method_10215() * (double)dist;
        }
        float factor = 0.0f;
        this.necka.method_5814(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necka.method_36456(endYaw + (startYaw - endYaw) * factor);
        this.necka.method_36457(endPitch + (0.0f - endPitch) * factor);
        factor = 0.25f;
        this.neckb.method_5814(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckb.method_36456(endYaw + (startYaw - endYaw) * factor);
        this.neckb.method_36457(endPitch + (0.0f - endPitch) * factor);
        factor = 0.5f;
        this.neckc.method_5814(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckc.method_36456(endYaw + (startYaw - endYaw) * factor);
        this.neckc.method_36457(endPitch + (0.0f - endPitch) * factor);
        factor = 0.75f;
        this.neckd.method_5814(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckd.method_36456(endYaw + (startYaw - endYaw) * factor);
        this.neckd.method_36457(endPitch + (0.0f - endPitch) * factor);
        factor = 1.0f;
        this.necke.method_5814(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necke.method_36456(endYaw + (startYaw - endYaw) * factor);
        this.necke.method_36457(endPitch + (0.0f - endPitch) * factor);
    }

    private void faceIdle(float yawConstraint, float pitchConstraint) {
        float angle = this.hydra.method_36454() * 3.141593f / 180.0f;
        float distance = 30.0f;
        double dx = this.hydra.method_23317() - (double)(class_3532.method_15374((float)angle) * distance);
        double dy = this.hydra.method_23318() + 3.0;
        double dz = this.hydra.method_23321() + (double)(class_3532.method_15362((float)angle) * distance);
        this.faceVec(dx, dy, dz, yawConstraint, pitchConstraint);
    }

    public void faceEntity(class_1297 entity, float yawConstraint, float pitchConstraint) {
        double yTarget;
        if (entity instanceof class_1309) {
            class_1309 entityliving = (class_1309)entity;
            yTarget = entityliving.method_23318() + (double)entityliving.method_5751();
        } else {
            yTarget = (entity.method_5829().field_1322 + entity.method_5829().field_1325) / 2.0;
        }
        this.faceVec(entity.method_23317(), yTarget, entity.method_23321(), yawConstraint, pitchConstraint);
        this.targetX = entity.method_23317();
        this.targetY = entity.method_23318();
        this.targetZ = entity.method_23321();
    }

    private void faceVec(double x, double y, double z, float yawConstraint, float pitchConstraint) {
        double xOffset = x - this.headEntity.method_23317();
        double zOffset = z - this.headEntity.method_23321();
        double yOffset = this.headEntity.method_23318() + 1.0 - y;
        double distance = class_3532.method_15355((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.headEntity.method_36457(-this.updateRotation(this.headEntity.method_36455(), zdAngle, pitchConstraint));
        this.headEntity.method_36456(this.updateRotation(this.headEntity.method_36454(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float intended, float increment) {
        float delta = class_3532.method_15393((float)(intended - current));
        if (delta > increment) {
            delta = increment;
        }
        if (delta < -increment) {
            delta = -increment;
        }
        return class_3532.method_15393((float)(current + delta));
    }

    public void setTargetEntity(@Nullable class_1297 targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setHurtTime(int hurtTime) {
        if (this.headEntity != null) {
            this.headEntity.hurtTime = hurtTime;
        }
        this.necka.hurtTime = hurtTime;
        this.neckb.hurtTime = hurtTime;
        this.neckc.hurtTime = hurtTime;
        this.neckd.hurtTime = hurtTime;
        this.necke.hurtTime = hurtTime;
    }

    public boolean shouldRenderHead() {
        return this.headEntity.getState() != State.DEAD && this.headEntity.deathTime < 20;
    }

    public boolean isActive() {
        return this.currentState != State.DYING && this.currentState != State.DEAD;
    }

    public boolean isIdle() {
        return this.currentState == State.IDLE && (this.nextState == NEXT_AUTOMATIC || this.nextState == State.IDLE);
    }

    public boolean isAttacking() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.currentState == State.FLAME_BEGINNING || this.currentState == State.FLAMING || this.currentState == State.MORTAR_BEGINNING || this.currentState == State.MORTAR_SHOOTING;
    }

    public boolean isBiting() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.nextState == State.BITE_BEGINNING;
    }

    public void addDamage(float damageAmount) {
        this.damageTaken = (int)((float)this.damageTaken + damageAmount);
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public void setRespawnCounter(int count) {
        this.respawnCounter = count;
    }

    static enum State {
        IDLE(10),
        BITE_BEGINNING(40),
        BITE_READY(80),
        BITING(7),
        BITE_ENDING(40),
        FLAME_BEGINNING(40),
        FLAMING(100),
        FLAME_ENDING(30),
        MORTAR_BEGINNING(40),
        MORTAR_SHOOTING(25),
        MORTAR_ENDING(30),
        DYING(70),
        DEAD(20),
        ATTACK_COOLDOWN(80),
        BORN(20),
        ROAR_START(10),
        ROAR_RAWR(50);

        private static final Map<State, State> NEXT_STATE;
        public final int duration;

        private State(int duration) {
            this.duration = duration;
        }

        static {
            EnumMap<State, State> b = new EnumMap<State, State>(State.class);
            b.put(IDLE, IDLE);
            b.put(BITE_BEGINNING, BITE_READY);
            b.put(BITE_READY, BITING);
            b.put(BITING, BITE_ENDING);
            b.put(BITE_ENDING, ATTACK_COOLDOWN);
            b.put(FLAME_BEGINNING, FLAMING);
            b.put(FLAMING, FLAME_ENDING);
            b.put(FLAME_ENDING, ATTACK_COOLDOWN);
            b.put(MORTAR_BEGINNING, MORTAR_SHOOTING);
            b.put(MORTAR_SHOOTING, MORTAR_ENDING);
            b.put(MORTAR_ENDING, ATTACK_COOLDOWN);
            b.put(ATTACK_COOLDOWN, IDLE);
            b.put(DYING, DEAD);
            b.put(DEAD, DEAD);
            b.put(BORN, ROAR_START);
            b.put(ROAR_START, ROAR_RAWR);
            b.put(ROAR_RAWR, IDLE);
            NEXT_STATE = ImmutableMap.copyOf(b);
        }
    }
}

