/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFChestBlock;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.goal.GroundAttackGoal;
import twilightforest.entity.monster.Minotaur;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;
import twilightforest.util.EntityUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class Minoshroom
extends Minotaur
implements EnforcedHomePoint {
    private static final class_2940<Boolean> GROUND_ATTACK = class_2945.method_12791(Minoshroom.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GROUND_CHARGE = class_2945.method_12791(Minoshroom.class, (class_2941)class_2943.field_13327);
    private float prevClientSideChargeAnimation;
    private float clientSideChargeAnimation;
    private boolean groundSmashState = false;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795);

    public Minoshroom(class_1299<? extends Minoshroom> type, class_1937 level) {
        super(type, level);
        this.field_6194 = 100;
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new GroundAttackGoal(this));
        this.addRestrictionGoals((class_1314)this, this.field_6201);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GROUND_ATTACK, (Object)false);
        this.field_6011.method_12784(GROUND_CHARGE, (Object)0);
    }

    public boolean isGroundAttackCharge() {
        return (Boolean)this.field_6011.method_12789(GROUND_ATTACK);
    }

    public void setGroundAttackCharge(boolean flag) {
        this.field_6011.method_12778(GROUND_ATTACK, (Object)flag);
    }

    public static class_5132.class_5133 registerAttributes() {
        return Minotaur.registerAttributes().method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23718, 0.5);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    protected void method_5958() {
        super.method_5958();
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5652(class_2487 compound) {
        this.saveHomePointToNbt(compound);
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadHomePointFromNbt(compound, 20);
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.prevClientSideChargeAnimation = this.clientSideChargeAnimation;
            if (this.isGroundAttackCharge()) {
                this.clientSideChargeAnimation = class_3532.method_15363((float)(this.clientSideChargeAnimation + 1.0f / (float)((Integer)this.field_6011.method_12789(GROUND_CHARGE)).intValue() * 6.0f), (float)0.0f, (float)6.0f);
                this.groundSmashState = true;
            } else {
                this.clientSideChargeAnimation = class_3532.method_15363((float)(this.clientSideChargeAnimation - 1.0f), (float)0.0f, (float)6.0f);
                if (this.groundSmashState) {
                    class_2680 block = this.method_37908().method_8320(this.method_24515().method_10074());
                    for (int i = 0; i < 80; ++i) {
                        double cx = (float)this.method_24515().method_10263() + this.method_37908().method_8409().method_43057() * 10.0f - 5.0f;
                        double cy = this.method_5829().field_1322 + (double)0.1f + (double)(this.method_37908().method_8409().method_43057() * 0.3f);
                        double cz = (float)this.method_24515().method_10260() + this.method_37908().method_8409().method_43057() * 10.0f - 5.0f;
                        this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, block), cx, cy, cz, 0.0, 0.0, 0.0);
                    }
                    this.groundSmashState = false;
                }
            }
        }
    }

    @Override
    protected class_3414 method_5994() {
        return (class_3414)TFSounds.MINOSHROOM_AMBIENT.get();
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.MINOSHROOM_HURT.get();
    }

    @Override
    protected class_3414 method_6002() {
        return (class_3414)TFSounds.MINOSHROOM_DEATH.get();
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783((class_3414)TFSounds.MINOSHROOM_STEP.get(), 0.15f, 0.8f);
    }

    @Override
    protected class_3414 getChargeSound() {
        return (class_3414)TFSounds.MINOSHROOM_ATTACK.get();
    }

    @Environment(value=EnvType.CLIENT)
    public float getChargeAnimationScale(float scale) {
        return (this.prevClientSideChargeAnimation + (this.clientSideChargeAnimation - this.prevClientSideChargeAnimation) * scale) / 6.0f;
    }

    public void setMaxCharge(int charge) {
        this.field_6011.method_12778(GROUND_CHARGE, (Object)charge);
    }

    @Override
    protected void method_5964(class_5819 source, class_1266 difficulty) {
        super.method_5964(source, difficulty);
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.DIAMOND_MINOTAUR_AXE.get()));
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_3222 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return super.method_5643(source, amount);
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.method_37908().method_8608()) {
            TFGenerationSettings.markStructureConquered(this.method_37908(), new class_2338((class_2382)this.method_24515()), TFLandmark.LABYRINTH);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFLootTables.entityDropsIntoContainer((class_1309)this, this.method_16079(true, cause).method_309(class_173.field_1173), ((TFChestBlock)((Object)TFBlocks.MANGROVE_CHEST.get())).method_9564(), EntityUtil.bossChestLocation((class_1308)this));
        }
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean method_5974(double distance) {
        return false;
    }

    public void method_5982() {
        if (this.method_37908().method_8407() == class_1267.field_5801) {
            if (this.method_18410()) {
                this.method_37908().method_8501(this.method_18412(), ((class_2248)TFBlocks.MINOSHROOM_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    protected boolean method_5860(class_1297 entity) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    @Override
    public class_2338 getRestrictionCenter() {
        return this.method_18412();
    }

    @Override
    public void setRestriction(class_2338 pos, int dist) {
        this.method_18408(pos, dist);
    }
}

