/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1541;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import twilightforest.entity.Chain;
import twilightforest.entity.SpikeBlock;
import twilightforest.entity.TFPart;
import twilightforest.entity.ai.goal.AvoidAnyEntityGoal;
import twilightforest.entity.ai.goal.ThrowSpikeBlockGoal;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFSounds;

public class BlockChainGoblin
extends class_1588
implements MultiPartEntity {
    private static final float CHAIN_SPEED = 16.0f;
    private static final class_2940<Byte> DATA_CHAINLENGTH = class_2945.method_12791(BlockChainGoblin.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> DATA_CHAINPOS = class_2945.method_12791(BlockChainGoblin.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> IS_THROWING = class_2945.method_12791(BlockChainGoblin.class, (class_2941)class_2943.field_13323);
    private int recoilCounter;
    private float chainAngle;
    private float chainMoveLength;
    public final SpikeBlock block = new SpikeBlock((class_1297)this);
    public final Chain chain1 = new Chain((class_1297)this);
    public final Chain chain2 = new Chain((class_1297)this);
    public final Chain chain3 = new Chain((class_1297)this);
    private final MultipartGenericsAreDumb[] partsArray = new MultipartGenericsAreDumb[]{this.block, this.chain1, this.chain2, this.chain3};

    public BlockChainGoblin(class_1299<? extends BlockChainGoblin> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, new AvoidAnyEntityGoal<class_1541>((class_1314)this, class_1541.class, 2.0f, 1.0, 2.0));
        this.field_6201.method_6277(4, (class_1352)new ThrowSpikeBlockGoal(this, this.block));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CHAINLENGTH, (Object)0);
        this.field_6011.method_12784(DATA_CHAINPOS, (Object)0);
        this.field_6011.method_12784(IS_THROWING, (Object)false);
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.28).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 11.0);
    }

    public float method_18381(class_4050 pose) {
        return this.method_17682() * 0.78f;
    }

    protected class_3414 method_5994() {
        return (class_3414)TFSounds.BLOCKCHAIN_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)TFSounds.BLOCKCHAIN_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)TFSounds.BLOCKCHAIN_DEATH.get();
    }

    public double getChainYOffset() {
        return 1.5 - (double)this.getChainLength() / 4.0;
    }

    public class_243 getChainPosition() {
        return this.getChainPosition(this.getChainAngle(), this.getChainLength());
    }

    public class_243 getChainPosition(float angle, float distance) {
        double dx = Math.cos((double)angle * Math.PI / 180.0) * (double)distance;
        double dz = Math.sin((double)angle * Math.PI / 180.0) * (double)distance;
        return new class_243(this.method_23317() + dx, this.method_23318() + this.getChainYOffset(), this.method_23321() + dz);
    }

    public boolean isSwingingChain() {
        return this.field_6252 || this.method_5968() != null && this.recoilCounter == 0;
    }

    public boolean method_6121(class_1297 entity) {
        this.method_6104(class_1268.field_5808);
        entity.method_5643(TFDamageSources.spiked((class_1297)this.block, (class_1297)this), (float)this.method_26825(class_5134.field_23721));
        return false;
    }

    public void method_5773() {
        super.method_5773();
        this.block.method_5773();
        this.chain1.method_5773();
        this.chain2.method_5773();
        this.chain3.method_5773();
        if (this.recoilCounter > 0) {
            --this.recoilCounter;
        }
        this.chainAngle += 16.0f;
        this.chainAngle %= 360.0f;
        if (!this.method_37908().method_8608()) {
            this.field_6011.method_12778(DATA_CHAINLENGTH, (Object)((byte)Math.floor(this.getChainLength() * 127.0f)));
            this.field_6011.method_12778(DATA_CHAINPOS, (Object)((byte)Math.floor(this.getChainAngle() / 360.0f * 255.0f)));
        } else if (Math.abs(this.chainAngle - this.getChainAngle()) > 32.0f) {
            this.chainAngle = this.getChainAngle();
        }
        if (this.method_5805()) {
            if (this.chainMoveLength > 0.0f) {
                class_243 blockPos = this.getThrowPos();
                double sx2 = this.method_23317();
                double sy2 = this.method_23318() + (double)this.method_17682() - 0.1;
                double sz2 = this.method_23321();
                double ox2 = sx2 - blockPos.method_10216();
                double oy2 = sy2 - blockPos.method_10214() - 0.25;
                double oz2 = sz2 - blockPos.method_10215();
                if (this.chainMoveLength >= 6.0f || !this.method_5805()) {
                    this.setThrowing(false);
                }
                this.chain1.method_5814(sx2 - ox2 * 0.25, sy2 - oy2 * 0.25, sz2 - oz2 * 0.25);
                this.chain2.method_5814(sx2 - ox2 * 0.5, sy2 - oy2 * 0.5, sz2 - oz2 * 0.5);
                this.chain3.method_5814(sx2 - ox2 * 0.85, sy2 - oy2 * 0.85, sz2 - oz2 * 0.85);
                this.block.method_5814(sx2 - ox2, sy2 - oy2, sz2 - oz2);
            } else {
                class_243 blockPos = this.getChainPosition();
                this.block.method_5814(blockPos.method_10216(), blockPos.method_10214(), blockPos.method_10215());
                this.block.method_36456(this.getChainAngle());
                double sx = this.method_23317();
                double sy = this.method_23318() + (double)this.method_17682() - 0.1;
                double sz = this.method_23321();
                double ox = sx - blockPos.method_10216();
                double oy = sy - blockPos.method_10214() - (double)this.block.method_17682() / 3.0;
                double oz = sz - blockPos.method_10215();
                this.chain1.method_5814(sx - ox * 0.4, sy - oy * 0.4, sz - oz * 0.4);
                this.chain2.method_5814(sx - ox * 0.5, sy - oy * 0.5, sz - oz * 0.5);
                this.chain3.method_5814(sx - ox * 0.6, sy - oy * 0.6, sz - oz * 0.6);
            }
        }
        if (!this.field_6002.field_9236 && this.method_5805() && (this.isThrowing() || this.isSwingingChain())) {
            this.applyBlockCollisions((class_1297)this.block);
        }
        this.chainMove();
    }

    private class_243 getThrowPos() {
        class_243 vec3d = this.method_5828(1.0f);
        return new class_243(this.method_23317() + vec3d.method_10216() * (double)this.chainMoveLength, this.method_23318() + (double)this.method_5751(), this.method_23321() + vec3d.method_10215() * (double)this.chainMoveLength);
    }

    private void chainMove() {
        this.chainMoveLength = this.isThrowing() ? class_3532.method_15363((float)(this.chainMoveLength + 0.5f), (float)0.0f, (float)6.0f) : class_3532.method_15363((float)(this.chainMoveLength - 1.5f), (float)0.0f, (float)6.0f);
    }

    public float getChainMoveLength() {
        return this.chainMoveLength;
    }

    protected void applyBlockCollisions(class_1297 collider) {
        List list = this.method_37908().method_8335(collider, collider.method_5829().method_1009(0.2, 0.0, 0.2));
        for (class_1297 entity : list) {
            if (!entity.method_5810()) continue;
            this.applyBlockCollision(collider, entity);
        }
        if (this.isThrowing() && collider.method_5757()) {
            this.setThrowing(false);
            collider.method_5783((class_3414)TFSounds.BLOCKCHAIN_COLLIDE.get(), 0.65f, 0.75f);
            this.method_32876(class_5712.field_28159);
        }
    }

    protected void applyBlockCollision(class_1297 collider, class_1297 collided) {
        if (collided != this) {
            collided.method_5697(collider);
            if (collided instanceof class_1309 && super.method_6121(collided)) {
                collided.method_5762(0.0, 0.4, 0.0);
                this.method_5783((class_3414)TFSounds.BLOCKCHAIN_HIT.get(), 1.0f, 1.0f);
                this.method_32876(class_5712.field_28162);
                this.recoilCounter = 40;
                if (this.isThrowing()) {
                    this.setThrowing(false);
                }
            }
        }
    }

    public boolean isThrowing() {
        return (Boolean)this.field_6011.method_12789(IS_THROWING);
    }

    public void setThrowing(boolean isThrowing) {
        this.field_6011.method_12778(IS_THROWING, (Object)isThrowing);
    }

    private float getChainAngle() {
        if (!this.method_37908().method_8608()) {
            return this.chainAngle;
        }
        return (float)((Byte)this.field_6011.method_12789(DATA_CHAINPOS) & 0xFF) / 255.0f * 360.0f;
    }

    private float getChainLength() {
        if (!this.method_37908().method_8608()) {
            if (this.isSwingingChain()) {
                return 0.9f;
            }
            return 0.3f;
        }
        return (float)((Byte)this.field_6011.method_12789(DATA_CHAINLENGTH) & 0xFF) / 127.0f;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        TFPart.assignPartIDs((class_1297)this);
    }

    public MultipartGenericsAreDumb[] getParts() {
        return this.partsArray;
    }

    public static abstract class MultipartGenericsAreDumb
    extends TFPart<class_1297> {
        public MultipartGenericsAreDumb(class_1297 parent) {
            super(parent);
        }
    }
}

