/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import twilightforest.TFConfig;
import twilightforest.block.TFPortalBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.thrown.YetiThrowCapability;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;

public class CapabilityEvents {
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";

    public static void init() {
        LivingEntityEvents.TICK.register(CapabilityEvents::updateCaps);
        LivingEntityEvents.ATTACK.register(CapabilityEvents::livingAttack);
        ServerPlayerEvents.AFTER_RESPAWN.register(CapabilityEvents::onPlayerRespawn);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(CapabilityEvents::playerPortals);
        EntityTrackingEvents.START_TRACKING.register(CapabilityEvents::onStartTracking);
    }

    public static void updateCaps(class_1309 entity) {
        CapabilityList.SHIELDS.maybeGet((Object)entity).ifPresent(IShieldCapability::update);
        CapabilityList.FEATHER_FAN_FALLING.maybeGet((Object)entity).ifPresent(FeatherFanFallCapability::update);
        CapabilityList.YETI_THROWN.maybeGet((Object)entity).ifPresent(YetiThrowCapability::update);
    }

    public static boolean livingAttack(class_1309 living, class_1282 source, float damage) {
        AtomicBoolean cancel = new AtomicBoolean(false);
        if (!living.method_37908().method_8608() && !source.method_5537()) {
            CapabilityList.SHIELDS.maybeGet((Object)living).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    cancel.set(true);
                }
            });
        }
        return cancel.get();
    }

    public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 serverPlayer, boolean alive) {
        if (alive) {
            CapabilityEvents.updateCapabilities(serverPlayer, (class_1297)serverPlayer);
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get()).booleanValue() && serverPlayer.method_26280() == null) {
            class_2487 tagCompound = serverPlayer.getExtraCustomData();
            class_2487 playerData = tagCompound.method_10562("PlayerPersisted");
            playerData.method_10556(NBT_TAG_TWILIGHT, false);
            tagCompound.method_10566("PlayerPersisted", (class_2520)playerData);
            CapabilityEvents.banishNewbieToTwilightZone((class_1657)serverPlayer);
        }
    }

    public static void playerLogsIn(class_3222 player) {
        CapabilityEvents.updateCapabilities(player, (class_1297)player);
        CapabilityEvents.banishNewbieToTwilightZone((class_1657)player);
    }

    public static void playerPortals(class_3222 player, class_3218 origin, class_3218 destination) {
        CapabilityEvents.updateCapabilities(player, (class_1297)player);
    }

    public static void onStartTracking(class_1297 trackedEntity, class_3222 player) {
        CapabilityEvents.updateCapabilities(player, trackedEntity);
    }

    private static void updateCapabilities(class_3222 clientTarget, class_1297 shielded) {
        CapabilityList.SHIELDS.maybeGet((Object)shielded).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new UpdateShieldPacket(shielded, (IShieldCapability)cap), clientTarget);
            }
        });
    }

    private static void banishNewbieToTwilightZone(class_1657 player) {
        class_2487 tagCompound = player.getExtraCustomData();
        class_2487 playerData = tagCompound.method_10562("PlayerPersisted");
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.method_10577(NBT_TAG_TWILIGHT);
        playerData.method_10556(NBT_TAG_TWILIGHT, true);
        tagCompound.method_10566("PlayerPersisted", (class_2520)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendEntity((class_1297)player, true, (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.portalForNewPlayerSpawn.get());
        }
    }
}

