/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import io.github.fabricators_of_create.porting_lib.event.common.LivingEntityEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_3965;
import net.minecraft.class_5281;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.monster.Kobold;
import twilightforest.init.TFLandmark;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.EnforceProgressionStatusPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFGenerationSettings;

public class ProgressionEvents {
    public static void init() {
        LivingEntityEvents.ATTACK.register(ProgressionEvents::livingAttack);
        UseBlockCallback.EVENT.register(ProgressionEvents::onPlayerRightClick);
        PlayerBlockBreakEvents.BEFORE.register(ProgressionEvents::breakBlock);
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register(ProgressionEvents::playerPortals);
    }

    public static boolean breakBlock(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (level.method_8608()) {
            return true;
        }
        return !ProgressionEvents.isBlockProtectedFromBreaking(level, pos) || !ProgressionEvents.isAreaProtected(level, player, pos);
    }

    public static class_1269 onPlayerRightClick(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!level.method_8608() && ProgressionEvents.isBlockProtectedFromInteraction(level, hitResult.method_17777()) && ProgressionEvents.isAreaProtected(level, player, hitResult.method_17777())) {
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static boolean isBlockProtectedFromInteraction(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26164(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(class_1937 level, class_2338 pos) {
        return !level.method_8320(pos).method_26164(BlockTagGenerator.PROGRESSION_ALLOW_BREAKING);
    }

    private static boolean isAreaProtected(class_1937 level, class_1657 player, class_2338 pos) {
        TFLandmark nearbyFeature;
        class_3449 structure;
        Optional<class_3449> struct;
        if (player.method_31549().field_7477 || player.method_7325() || !TFGenerationSettings.isProgressionEnforced(level) || player instanceof class_3222 && player.getClass() != class_3222.class) {
            return false;
        }
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((class_1936)level);
        if (chunkGenerator != null && (struct = TFGenerationSettings.locateTFStructureInRange((class_5281)((class_3218)level), pos, 0)).isPresent() && (structure = struct.get()).method_14969().method_14662((class_2382)pos) && !(nearbyFeature = LegacyLandmarkPlacements.pickLandmarkAtBlock(pos.method_10263(), pos.method_10260(), (class_5281)((class_3218)level))).doesPlayerHaveRequiredAdvancements(player)) {
            if (nearbyFeature == TFLandmark.KNIGHT_STRONGHOLD && pos.method_10264() >= 0) {
                return false;
            }
            ArrayList<class_3341> boxes = new ArrayList<class_3341>();
            structure.method_14963().forEach(piece -> {
                if (piece.method_14935().method_14662((class_2382)pos)) {
                    boxes.add(piece.method_14935());
                }
            });
            ProgressionEvents.sendAreaProtectionPacket(level, pos, boxes);
            nearbyFeature.trySpawnHintMonster(level, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(class_1937 level, class_2338 pos, List<class_3341> sbb) {
        TFPacketHandler.CHANNEL.sendToClientsAround((S2CPacket)new AreaProtectionPacket(sbb, pos), (class_3218)level, (class_2382)pos, 64.0);
    }

    public static boolean livingAttack(class_1309 living, class_1282 source, float amount) {
        return !living.method_37908().method_8608() && living instanceof class_1569 && source.method_5529() instanceof class_1657 && !(living instanceof Kobold) && ProgressionEvents.isAreaProtected(living.method_37908(), (class_1657)source.method_5529(), new class_2338((class_2382)living.method_24515()));
    }

    public static void playerPortals(class_3222 player, class_3218 origin, class_3218 destination) {
        if (!player.method_14220().method_8608() && TFGenerationSettings.usesTwilightChunkGenerator(player.method_14220())) {
            ProgressionEvents.sendEnforcedProgressionStatus(player, TFGenerationSettings.isProgressionEnforced((class_1937)player.method_14220()));
        }
    }

    public static void playerLogsIn(class_3222 player) {
        if (!player.method_14220().method_8608()) {
            ProgressionEvents.sendEnforcedProgressionStatus(player, TFGenerationSettings.isProgressionEnforced((class_1937)player.method_14220()));
        }
    }

    private static void sendEnforcedProgressionStatus(class_3222 player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new EnforceProgressionStatusPacket(isEnforced), player);
    }
}

