/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import io.github.fabricators_of_create.porting_lib.item.CustomMapItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3620;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFMagicMapData;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFItems;
import twilightforest.init.TFLandmark;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.registration.TFGenerationSettings;

public class MagicMapItem
extends class_1806
implements CustomMapItem {
    public static final String STR_ID = "magicmap";
    private static final Map<class_2960, MapColorBrightness> BIOME_COLORS = new HashMap<class_2960, MapColorBrightness>();
    private static final Map<class_1923, class_2960[]> CACHE = new HashMap<class_1923, class_2960[]>();
    private static final class_2960 NULL_BIOME = new class_2960("null");

    public MagicMapItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static class_1799 setupNewMap(class_1937 level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        class_1799 itemstack = new class_1799((class_1935)TFItems.FILLED_MAGIC_MAP.get());
        MagicMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (class_5321<class_1937>)level.method_27983());
        return itemstack;
    }

    @Nullable
    public static TFMagicMapData getData(class_1799 stack, class_1937 level) {
        Integer id = MagicMapItem.method_8003((class_1799)stack);
        return id == null ? null : TFMagicMapData.getMagicMapData(level, MagicMapItem.getMapName(id));
    }

    @Nullable
    public TFMagicMapData getCustomMapData(class_1799 stack, class_1937 level) {
        TFMagicMapData mapdata = MagicMapItem.getData(stack, level);
        if (mapdata == null && !level.method_8608()) {
            mapdata = MagicMapItem.createMapData(stack, level, level.method_8401().method_215(), level.method_8401().method_166(), 3, false, false, (class_5321<class_1937>)level.method_27983());
        }
        return mapdata;
    }

    private static TFMagicMapData createMapData(class_1799 stack, class_1937 level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, class_5321<class_1937> dimension) {
        int i = level.method_17889();
        int mapSize = 2048;
        int roundX = (int)Math.round((double)(x - 1024) / (double)mapSize);
        int roundZ = (int)Math.round((double)(z - 1024) / (double)mapSize);
        int scaledX = roundX * mapSize + 1024;
        int scaledZ = roundZ * mapSize + 1024;
        TFMagicMapData mapdata = new TFMagicMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        TFMagicMapData.registerMagicMapData(level, mapdata, MagicMapItem.getMapName(i));
        stack.method_7948().method_10569("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "magicmap_" + id;
    }

    public void method_7998(class_1937 level, class_1297 viewer, class_22 data) {
        class_3218 serverLevel;
        if (level.method_27983() == data.field_118 && viewer instanceof class_1657 && level instanceof class_3218 && TFGenerationSettings.usesTwilightChunkGenerator(serverLevel = (class_3218)level)) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.field_116;
            int centerZ = data.field_115;
            int viewerX = class_3532.method_15357((double)(viewer.method_23317() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = class_3532.method_15357((double)(viewer.method_23321() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            class_2960[] biomes = CACHE.computeIfAbsent(new class_1923(startX, startZ), pos -> {
                class_2960[] array = new class_2960[128 * biomesPerPixel * 128 * biomesPerPixel];
                for (int l = 0; l < 128 * biomesPerPixel; ++l) {
                    for (int i1 = 0; i1 < 128 * biomesPerPixel; ++i1) {
                        array[l * 128 * biomesPerPixel + i1] = level.method_23753(new class_2338(startX * biomesPerPixel + i1 * biomesPerPixel, 0, startZ * biomesPerPixel + l * biomesPerPixel)).method_40230().map(class_5321::method_29177).orElse(NULL_BIOME);
                    }
                }
                return array;
            });
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    class_2960 biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    class_2960 overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    class_2960 downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    biome = overBiome != null && BiomeKeys.STREAM.method_29177().equals((Object)overBiome) ? overBiome : (downBiome != null && BiomeKeys.STREAM.method_29177().equals((Object)downBiome) ? downBiome : biome);
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(level, biome);
                    class_3620 mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.field_122[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.field_16021 * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.method_32370(xPixel, zPixel, ourPixel);
                        data.method_80();
                    }
                    if (!LegacyLandmarkPlacements.blockIsInLandmarkCenter(worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    TFLandmark feature = LegacyLandmarkPlacements.pickLandmarkAtBlock(worldX, worldZ, (class_5281)((class_3218)level));
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    tfData.tfDecorations.add(new TFMagicMapData.TFMapDecoration(feature, mapX, mapZ, 8));
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(class_1937 level, class_2960 biome) {
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        if (biome == NULL_BIOME) {
            return new MapColorBrightness(class_3620.field_16009);
        }
        MapColorBrightness color = BIOME_COLORS.get(biome);
        if (color != null) {
            return color;
        }
        return new MapColorBrightness(class_3620.field_15998);
    }

    private static void setupBiomeColors() {
        MagicMapItem.putBiomeColor(BiomeKeys.FOREST, new MapColorBrightness(class_3620.field_16004, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_FOREST, new MapColorBrightness(class_3620.field_16004, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.LAKE, new MapColorBrightness(class_3620.field_16019, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.STREAM, new MapColorBrightness(class_3620.field_16019, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.SWAMP, new MapColorBrightness(class_3620.field_15983, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FIRE_SWAMP, new MapColorBrightness(class_3620.field_16012, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.CLEARING, new MapColorBrightness(class_3620.field_15999, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.OAK_SAVANNAH, new MapColorBrightness(class_3620.field_15999, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.HIGHLANDS, new MapColorBrightness(class_3620.field_16000, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.THORNLANDS, new MapColorBrightness(class_3620.field_15996, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FINAL_PLATEAU, new MapColorBrightness(class_3620.field_15993, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.FIREFLY_FOREST, new MapColorBrightness(class_3620.field_16001, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST, new MapColorBrightness(class_3620.field_15995, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST_CENTER, new MapColorBrightness(class_3620.field_15987, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.SNOWY_FOREST, new MapColorBrightness(class_3620.field_16022, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.GLACIER, new MapColorBrightness(class_3620.field_16016, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.MUSHROOM_FOREST, new MapColorBrightness(class_3620.field_15987, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_MUSHROOM_FOREST, new MapColorBrightness(class_3620.field_16030, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.ENCHANTED_FOREST, new MapColorBrightness(class_3620.field_16026, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.SPOOKY_FOREST, new MapColorBrightness(class_3620.field_16014, 0));
    }

    private static void putBiomeColor(class_5321<class_1959> biome, MapColorBrightness color) {
        BIOME_COLORS.put(biome.method_29177(), color);
    }

    public static int getBiomeColor(class_1937 level, class_1959 biome) {
        MapColorBrightness c;
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        return (c = BIOME_COLORS.get(level.method_30349().method_33309(class_2378.field_25114).method_10221((Object)biome))) != null ? MagicMapItem.getMapColor(c) : -16777216;
    }

    public static int getMapColor(MapColorBrightness mcb) {
        int i = switch (mcb.color.field_16021) {
            case 3 -> 135;
            case 2 -> 255;
            case 0 -> 180;
            default -> 220;
        };
        int j = (mcb.color.field_16011 >> 16 & 0xFF) * i / 255;
        int k = (mcb.color.field_16011 >> 8 & 0xFF) * i / 255;
        int l = (mcb.color.field_16011 & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
    }

    @Nullable
    public class_2596<?> method_7757(class_1799 stack, class_1937 world, class_1657 player) {
        Integer id = MagicMapItem.method_8003((class_1799)stack);
        TFMagicMapData mapdata = this.getCustomMapData(stack, world);
        return id == null || mapdata == null ? null : mapdata.method_100(id, player);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        TFMagicMapData mapitemsaveddata;
        Integer integer = MagicMapItem.method_8003((class_1799)stack);
        TFMagicMapData tFMagicMapData = mapitemsaveddata = level == null ? null : MagicMapItem.getData(stack, level);
        if (flag.method_8035()) {
            if (mapitemsaveddata != null) {
                tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.id", (Object[])new Object[]{integer}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.scale", (Object[])new Object[]{1 << mapitemsaveddata.field_119}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"filled_map.level", (Object[])new Object[]{mapitemsaveddata.field_119, 4}).method_27692(class_124.field_1080));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"filled_map.unknown").method_27692(class_124.field_1080));
            }
        } else if (integer != null) {
            tooltip.add((class_2561)class_2561.method_43470((String)("#" + integer)).method_27692(class_124.field_1080));
        }
    }

    private static class MapColorBrightness {
        public final class_3620 color;
        public final int brightness;

        public MapColorBrightness(class_3620 color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(class_3620 color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

