/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.armor.TFArmorModel;
import twilightforest.client.renderer.TFArmorRenderer;
import twilightforest.data.tags.CustomTagGenerator;

public class PhantomArmorItem
extends class_1738
implements CustomEnchantingBehaviorItem {
    private static final class_5250 TOOLTIP = class_2561.method_43471((String)"item.twilightforest.phantom_armor.tooltip").method_10862(class_2583.field_24360.method_10977(class_124.field_1080));

    public PhantomArmorItem(class_1741 material, class_1304 slot, class_1792.class_1793 properties) {
        super(material, slot, properties);
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::initializeClient);
    }

    public static String getArmorTexture(class_1799 stack, class_1297 entity, class_1304 slot, String layer) {
        return "twilightforest:textures/armor/phantom_1.png";
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return !((class_6885.class_6888)class_2378.field_11160.method_40266(CustomTagGenerator.EnchantmentTagGenerator.PHANTOM_ARMOR_BANNED_ENCHANTS).get()).method_40241(class_6880.method_40223((Object)enchantment)) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        AtomicBoolean badEnchant = new AtomicBoolean();
        class_1890.method_8222((class_1799)book).forEach((enchantment, integer) -> {
            for (class_6880 banned : (class_6885.class_6888)class_2378.field_11160.method_40266(CustomTagGenerator.EnchantmentTagGenerator.PHANTOM_ARMOR_BANNED_ENCHANTS).get()) {
                if (!Objects.equals(banned.comp_349(), enchantment)) continue;
                badEnchant.set(true);
                break;
            }
        });
        return !badEnchant.get();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        tooltip.add((class_2561)TOOLTIP);
    }

    @Environment(value=EnvType.CLIENT)
    public void initializeClient() {
        ArmorRenderer.register((ArmorRenderer)ArmorRender.INSTANCE, (class_1935[])new class_1935[]{this});
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ArmorRender
    implements ArmorRenderer {
        private static final ArmorRender INSTANCE = new ArmorRender();
        private TFArmorModel armorModel;

        private ArmorRender() {
        }

        public void render(class_4587 matrices, class_4597 vertexConsumers, class_1799 itemStack, class_1309 entityLiving, class_1304 armorSlot, int light, class_572<class_1309> parentModel) {
            if (this.armorModel == null) {
                class_5599 models = class_310.method_1551().method_31974();
                class_630 root = models.method_32072(armorSlot == class_1304.field_6172 ? TFModelLayers.PHANTOM_ARMOR_INNER : TFModelLayers.PHANTOM_ARMOR_OUTER);
                this.armorModel = new TFArmorModel(root);
            }
            parentModel.method_2818((class_572)this.armorModel);
            TFArmorRenderer.setPartVisibility(this.armorModel, armorSlot);
            ArmorRenderer.renderPart((class_4587)matrices, (class_4597)vertexConsumers, (int)light, (class_1799)itemStack, (class_3879)this.armorModel, (class_2960)new class_2960(PhantomArmorItem.getArmorTexture(itemStack, (class_1297)entityLiving, armorSlot, null)));
        }
    }
}

