/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.modifiers;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.fabricators_of_create.porting_lib.loot.IGlobalLootModifier;
import io.github.fabricators_of_create.porting_lib.loot.LootModifier;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;
import twilightforest.block.GiantBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.giant_pick.GiantPickMineCapability;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFItems;

public class GiantToolGroupingModifier
extends LootModifier {
    public static final Codec<GiantToolGroupingModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GiantToolGroupingModifier::new));
    private static boolean isBreakingWithGiantPick;
    private static boolean shouldMakeGiantCobble;
    private static int amountOfCobbleToReplace;

    public GiantToolGroupingModifier(class_5341[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<class_1799> doApply(ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        ObjectArrayList<class_1799> newLoot = new ObjectArrayList<class_1799>();
        boolean flag = false;
        if (shouldMakeGiantCobble && generatedLoot.size() > 0 && ((class_1799)generatedLoot.get(0)).method_7909() == class_1792.method_7867((class_2248)class_2246.field_10445)) {
            generatedLoot.remove(0);
            if (amountOfCobbleToReplace == 64) {
                newLoot.add((Object)new class_1799((class_1935)TFBlocks.GIANT_COBBLESTONE.get()));
                flag = true;
            }
            if (--amountOfCobbleToReplace <= 0) {
                shouldMakeGiantCobble = false;
            }
        }
        return flag ? newLoot : generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static boolean breakBlock(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (!isBreakingWithGiantPick && GiantToolGroupingModifier.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            class_1792 cobbleItem = class_2246.field_10445.method_8389();
            boolean bl = allCobble = state.method_26204().method_8389() == cobbleItem;
            if (allCobble) {
                for (class_2338 dPos : GiantBlock.getVolume(pos)) {
                    class_2680 stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = world.method_8320(dPos)).method_26204().method_8389() == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.method_31549().field_7477) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof class_3222) {
                class_3222 playerMP = (class_3222)player;
                for (class_2338 dPos : GiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state.method_26204() != world.method_8320(dPos).method_26204()) continue;
                    playerMP.field_13974.method_14266(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
        return true;
    }

    private static boolean canHarvestWithGiantPick(class_1657 player, class_2680 state) {
        return player.method_6047().method_31574((class_1792)TFItems.GIANT_PICKAXE.get()) && player.method_7305(state) && CapabilityList.GIANT_PICK_MINE.maybeGet((Object)player).map(GiantPickMineCapability::getMining).orElse(1L).longValue() == player.field_6002.method_8510();
    }

    static {
        PlayerBlockBreakEvents.BEFORE.register(GiantToolGroupingModifier::breakBlock);
        isBreakingWithGiantPick = false;
        shouldMakeGiantCobble = false;
        amountOfCobbleToReplace = 0;
    }
}

