/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFLandmark;
import twilightforest.util.Vec2i;
import twilightforest.util.XZQuadrantIterator;

public class LegacyLandmarkPlacements {
    private static final Map<class_2960, TFLandmark> BIOME_FEATURES = new ImmutableMap.Builder().put((Object)BiomeKeys.ENCHANTED_FOREST.method_29177(), (Object)TFLandmark.QUEST_GROVE).put((Object)BiomeKeys.LAKE.method_29177(), (Object)TFLandmark.QUEST_ISLAND).put((Object)BiomeKeys.SWAMP.method_29177(), (Object)TFLandmark.LABYRINTH).put((Object)BiomeKeys.FIRE_SWAMP.method_29177(), (Object)TFLandmark.HYDRA_LAIR).put((Object)BiomeKeys.DARK_FOREST.method_29177(), (Object)TFLandmark.KNIGHT_STRONGHOLD).put((Object)BiomeKeys.DARK_FOREST_CENTER.method_29177(), (Object)TFLandmark.DARK_TOWER).put((Object)BiomeKeys.SNOWY_FOREST.method_29177(), (Object)TFLandmark.YETI_CAVE).put((Object)BiomeKeys.GLACIER.method_29177(), (Object)TFLandmark.ICE_TOWER).put((Object)BiomeKeys.HIGHLANDS.method_29177(), (Object)TFLandmark.TROLL_CAVE).put((Object)BiomeKeys.FINAL_PLATEAU.method_29177(), (Object)TFLandmark.FINAL_CASTLE).build();

    public static TFLandmark getLandmarkDirectlyAt(int chunkX, int chunkZ, class_5281 world) {
        if (LegacyLandmarkPlacements.blockIsInLandmarkCenter(chunkX << 4, chunkZ << 4)) {
            return LegacyLandmarkPlacements.pickLandmarkAtBlock(chunkX << 4, chunkZ << 4, world);
        }
        return TFLandmark.NOTHING;
    }

    public static boolean blockIsInLandmarkCenter(int blockX, int blockZ) {
        return LegacyLandmarkPlacements.chunkHasLandmarkCenter(blockX >> 4, blockZ >> 4);
    }

    public static boolean chunkHasLandmarkCenter(class_1923 chunkPos) {
        return LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkPos.field_9181, chunkPos.field_9180);
    }

    public static boolean chunkHasLandmarkCenter(int chunkX, int chunkZ) {
        class_2338 nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        return chunkX == nearestCenter.method_10263() >> 4 && chunkZ == nearestCenter.method_10260() >> 4;
    }

    public static float distanceFromCenter(class_2338 posXZ, boolean euclidean) {
        class_2338 nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(posXZ.method_10263() >> 4, posXZ.method_10260() >> 4);
        float dX = posXZ.method_10263() - nearestCenter.method_10263();
        float dZ = posXZ.method_10260() - nearestCenter.method_10260();
        if (euclidean) {
            return class_3532.method_15355((float)(dX * dX + dZ * dZ));
        }
        return class_3532.method_15379((float)dX) + class_3532.method_15379((float)dZ);
    }

    public static TFLandmark pickLandmarkAtBlock(int blockX, int blockZ, class_5281 world) {
        return LegacyLandmarkPlacements.pickLandmarkForChunk(blockX >> 4, blockZ >> 4, world);
    }

    public static TFLandmark pickLandmarkForChunk(int chunkX, int chunkZ, class_5281 world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        class_1959 biomeAt = (class_1959)world.method_23753(new class_2338((chunkX << 4) + 8, 0, (chunkZ << 4) + 8)).comp_349();
        return LegacyLandmarkPlacements.pickBiomeLandmarkLegacy(world.method_30349(), chunkX, chunkZ, biomeAt, world.method_8412());
    }

    public static TFLandmark pickBiomeLandmarkLegacy(class_5455 access, int chunkX, int chunkZ, class_1959 biome, long seed) {
        TFLandmark biomeFeature;
        Optional registryOpt = access.method_33310(class_2378.field_25114);
        if (registryOpt.isPresent() && (biomeFeature = BIOME_FEATURES.get(((class_2378)registryOpt.get()).method_10221((Object)biome))) != null) {
            return biomeFeature;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed);
    }

    public static TFLandmark pickVarietyLandmark(int chunkX, int chunkZ, long seed) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return TFLandmark.LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return TFLandmark.NAGA_COURTYARD;
        }
        return switch (new Random(seed + (long)chunkX * 25117L + (long)chunkZ * 151121L).nextInt(16)) {
            case 6, 7, 8 -> TFLandmark.MEDIUM_HILL;
            case 9 -> TFLandmark.LARGE_HILL;
            case 10, 11 -> TFLandmark.HEDGE_MAZE;
            case 12, 13 -> TFLandmark.NAGA_COURTYARD;
            case 14, 15 -> TFLandmark.LICH_TOWER;
            default -> TFLandmark.SMALL_HILL;
        };
    }

    public static TFLandmark getNearestLandmark(int cx, int cz, class_5281 world) {
        return LegacyLandmarkPlacements.getNearestLandmark(cx, cz, world, null);
    }

    public static TFLandmark getNearestLandmark(int cx, int cz, class_5281 world, @Nullable Vec2i center) {
        int maxSize = TFLandmark.getMaxSearchSize();
        int diam = maxSize * 2 + 1;
        TFLandmark[] features = new TFLandmark[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFLandmark directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = LegacyLandmarkPlacements.getLandmarkDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return TFLandmark.NOTHING;
    }

    public static TFLandmark getFeatureForRegion(int chunkX, int chunkZ, class_5281 world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return LegacyLandmarkPlacements.pickLandmarkForChunk(featureX, featureZ, world);
    }

    public static TFLandmark getFeatureForRegionPos(int posX, int posZ, class_5281 world) {
        return LegacyLandmarkPlacements.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static XZQuadrantIterator<class_2338> landmarkCenterScanner(class_2338 searchFocus, int gridSearchRadius) {
        return new XZQuadrantIterator<class_2338>(searchFocus.method_10263() >> 4 & 0xFFFFFFF0, searchFocus.method_10260() >> 4 & 0xFFFFFFF0, false, gridSearchRadius, 16, LegacyLandmarkPlacements::getNearestCenterXZ);
    }

    public static class_2338 getNearestCenterXZ(int chunkX, int chunkZ) {
        return LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ, 0);
    }

    public static class_2338 getNearestCenterXZ(int chunkX, int chunkZ, int height) {
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new class_2338(ccx, height, ccz);
    }

    public static boolean isTheseFeatures(TFLandmark feature, TFLandmark ... predicates) {
        for (TFLandmark predicate : predicates) {
            if (feature != predicate) continue;
            return true;
        }
        return false;
    }
}

