/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.biomesources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.components.layer.GenLayerTFBiomeStabilize;
import twilightforest.world.components.layer.GenLayerTFBiomes;
import twilightforest.world.components.layer.GenLayerTFCompanionBiomes;
import twilightforest.world.components.layer.GenLayerTFKeyBiomes;
import twilightforest.world.components.layer.GenLayerTFRiverMix;
import twilightforest.world.components.layer.GenLayerTFStream;
import twilightforest.world.components.layer.GenLayerTFThornBorder;
import twilightforest.world.components.layer.vanillalegacy.Layer;
import twilightforest.world.components.layer.vanillalegacy.SmoothLayer;
import twilightforest.world.components.layer.vanillalegacy.ZoomLayer;
import twilightforest.world.components.layer.vanillalegacy.area.Area;
import twilightforest.world.components.layer.vanillalegacy.area.AreaFactory;
import twilightforest.world.components.layer.vanillalegacy.context.BigContext;
import twilightforest.world.components.layer.vanillalegacy.context.LazyAreaContext;

@Deprecated
public class TFBiomeProvider
extends class_1966 {
    public static final Codec<TFBiomeProvider> TF_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().orElseGet(() -> TFFeatureModifiers.seed).forGetter(o -> o.seed), (App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(o -> o.registry), (App)class_1959.field_24677.fieldOf("underground_biome").forGetter(o -> o.undergroundBiome), (App)TerrainColumn.CODEC.listOf().fieldOf("biome_landscape").xmap(l -> l.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), m -> List.copyOf(m.values())).forGetter(o -> o.biomeList), (App)Codec.FLOAT.fieldOf("base_offset").forGetter(o -> Float.valueOf(o.baseOffset)), (App)Codec.FLOAT.fieldOf("base_factor").forGetter(o -> Float.valueOf(o.baseFactor))).apply((Applicative)instance, instance.stable(TFBiomeProvider::new)));
    private final class_2378<class_1959> registry;
    private final class_6880<class_1959> undergroundBiome;
    private final Map<class_5321<class_1959>, TerrainColumn> biomeList;
    private final Layer genBiomes;
    private final long seed;
    private final float baseOffset;
    private final float baseFactor;

    public TFBiomeProvider(long seed, class_2378<class_1959> registryIn, class_6880<class_1959> undergroundBiome, List<TerrainColumn> list, float offset, float factor) {
        this(seed, registryIn, undergroundBiome, list.stream().collect(Collectors.toMap(TerrainColumn::getResourceKey, Function.identity())), offset, factor);
    }

    public TFBiomeProvider(long seed, class_2378<class_1959> registryIn, class_6880<class_1959> undergroundBiome, Map<class_5321<class_1959>, TerrainColumn> list, float offset, float factor) {
        super(list.values().stream().flatMap(TerrainColumn::getBiomes));
        this.seed = seed;
        this.baseOffset = offset;
        this.baseFactor = factor;
        this.registry = registryIn;
        this.undergroundBiome = undergroundBiome;
        this.biomeList = list;
        this.genBiomes = TFBiomeProvider.makeLayers(seed, registryIn);
    }

    public static int getBiomeId(class_5321<class_1959> biome, class_2378<class_1959> registry) {
        return registry.method_10206((Object)((class_1959)registry.method_29107(biome)));
    }

    private static <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> seed, class_2378<class_1959> registry, long rawSeed) {
        AreaFactory biomes = GenLayerTFBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1L));
        biomes = GenLayerTFKeyBiomes.INSTANCE.setup(registry, rawSeed).run((BigContext)seed.apply(1000L), biomes);
        biomes = GenLayerTFCompanionBiomes.INSTANCE.setup(registry).run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1001L), biomes);
        biomes = GenLayerTFBiomeStabilize.INSTANCE.run((BigContext)seed.apply(700L), biomes);
        biomes = GenLayerTFThornBorder.INSTANCE.setup(registry).run((BigContext)seed.apply(500L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)seed.apply(1005L), biomes);
        AreaFactory riverLayer = GenLayerTFStream.INSTANCE.setup(registry).run((BigContext)seed.apply(1L), biomes);
        riverLayer = SmoothLayer.INSTANCE.run((BigContext)seed.apply(7000L), riverLayer);
        biomes = GenLayerTFRiverMix.INSTANCE.setup(registry).run((BigContext)seed.apply(100L), biomes, riverLayer);
        return biomes;
    }

    public static Layer makeLayers(long seed, class_2378<class_1959> registry) {
        AreaFactory areaFactory = TFBiomeProvider.makeLayers(context -> new LazyAreaContext(25, seed, context), registry, seed);
        return new Layer(areaFactory){

            @Override
            public class_6880<class_1959> get(class_2378<class_1959> registry, int p_242936_2_, int p_242936_3_) {
                int i = this.area.get(p_242936_2_, p_242936_3_);
                Optional biome = registry.method_40265(i);
                if (biome.isEmpty()) {
                    throw new IllegalStateException("Unknown biome id emitted by layers: " + i);
                }
                return (class_6880)biome.get();
            }
        };
    }

    protected Codec<? extends class_1966> method_28442() {
        return TF_CODEC;
    }

    public float getBaseOffset() {
        return this.baseOffset;
    }

    public float getBaseFactor() {
        return this.baseFactor;
    }

    public float getBiomeDepth(int x, int z) {
        return this.getBiomeDepth(this.genBiomes.get(this.registry, x, z));
    }

    public float getBiomeDepth(class_6880<class_1959> biome) {
        return this.getBiomeValue(biome, TerrainColumn::depth, Float.valueOf(0.0f)).floatValue();
    }

    public Optional<TerrainColumn> getTerrainColumn(int x, int z) {
        return this.getTerrainColumn(this.genBiomes.get(this.registry, x, z));
    }

    public Optional<TerrainColumn> getTerrainColumn(class_6880<class_1959> biome) {
        return this.biomeList.values().stream().filter(p -> p.is(biome)).findFirst();
    }

    public <T> T getBiomeValue(class_6880<class_1959> biome, Function<TerrainColumn, T> function, T other) {
        return this.getTerrainColumn(biome).map(function).orElse(other);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        class_6880<class_1959> columnBiome = this.genBiomes.get(this.registry, x, z);
        return this.biomeList.get(columnBiome.method_40230().get()).getBiome(y, columnBiome);
    }
}

