/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_244;
import net.minecraft.class_251;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2944;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3614;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4662;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7387;
import twilightforest.init.TFBlocks;

public class DarkCanopyTreeFeature
extends class_3031<class_4643> {
    int difference = 0;
    class_2338 validPos = new class_2338(0, 0, 0);

    public DarkCanopyTreeFeature(Codec<class_4643> config) {
        super(config);
    }

    public boolean method_13151(class_5821<class_4643> ctx) {
        class_5281 reader = ctx.method_33652();
        class_2338 pos = ctx.method_33655();
        class_5819 rand = ctx.method_33654();
        boolean foundDirt = false;
        for (int dy = pos.method_10264(); dy >= reader.method_31607(); --dy) {
            class_3614 materialUnder = reader.method_8320(new class_2338(pos.method_10263(), dy - 1, pos.method_10260())).method_26207();
            if (materialUnder == class_3614.field_15945 || materialUnder == class_3614.field_15941) {
                foundDirt = true;
                this.validPos = pos = new class_2338(pos.method_10263(), dy, pos.method_10260());
                break;
            }
            if (materialUnder == class_3614.field_15914 || materialUnder == class_3614.field_15916) break;
        }
        if (!foundDirt) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (class_2944.method_27371((class_3746)reader, (class_2338)pos.method_10079(class_2350.field_11036, i))) continue;
            return false;
        }
        for (class_2350 e : class_2350.class_2353.field_11062) {
            if (reader.method_8320(pos.method_10093(e)).method_26207() != class_3614.field_15932) continue;
            return false;
        }
        class_4643 treeconfiguration = (class_4643)ctx.method_33656();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<class_2338, class_2680> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.method_10062());
            reader.method_8652(p_160555_, p_160556_, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.method_10062());
            reader.method_8652(p_160548_, p_160549_, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer2 = (p_160543_, p_160544_) -> {
            set2.add(p_160543_.method_10062());
            reader.method_8652(p_160543_, p_160544_, 19);
        };
        BiConsumer<class_2338, class_2680> biconsumer3 = (p_225290_, p_225291_) -> {
            set3.add(p_225290_.method_10062());
            reader.method_8652(p_225290_, p_225291_, 19);
        };
        boolean flag = this.doPlace(reader, rand, pos, biconsumer, biconsumer1, biconsumer2, treeconfiguration);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.field_21290.isEmpty()) {
                class_4662.class_7402 treedecorator$context = new class_4662.class_7402((class_3746)reader, biconsumer3, rand, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.field_21290.forEach(p_225282_ -> p_225282_.method_23469(treedecorator$context));
            }
            return class_3341.method_35411((Iterable)Iterables.concat((Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_160521_ -> {
                class_251 shape = DarkCanopyTreeFeature.updateLeaves((class_1936)reader, p_160521_, set1, set3);
                class_3499.method_20532((class_1936)reader, (int)3, (class_251)shape, (int)p_160521_.method_35415(), (int)p_160521_.method_35416(), (int)p_160521_.method_35417());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private boolean doPlace(class_5281 level, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> consumer, BiConsumer<class_2338, class_2680> consumer1, BiConsumer<class_2338, class_2680> consumer2, class_4643 config) {
        pos = new class_2338(pos.method_10263(), this.validPos.method_10264(), pos.method_10260());
        int i = config.field_24136.method_26993(random);
        int j = config.field_24135.method_26989(random, i, config);
        int k = i - j;
        int l = config.field_24135.method_23452(random, k);
        class_2338 finalPos = pos;
        class_2338 blockpos = config.field_38767.map(placer -> placer.method_43309(finalPos, random)).orElse(pos);
        int i1 = Math.min(pos.method_10264(), blockpos.method_10264());
        int j1 = Math.max(pos.method_10264(), blockpos.method_10264()) + i + 1;
        if (i1 >= level.method_31607() + 1 && j1 <= level.method_31600()) {
            OptionalInt optionalint = config.field_24137.method_27377();
            int k1 = this.getMaxFreeTreeHeight((class_3746)level, i, blockpos, config);
            if (k1 >= i || !optionalint.isEmpty() && k1 >= optionalint.getAsInt()) {
                if (config.field_38767.isPresent() && !((class_7387)config.field_38767.get()).method_43168((class_3746)level, consumer, random, pos, blockpos, config)) {
                    return false;
                }
                List list = config.field_24136.method_26991((class_3746)level, consumer1, random, k1, blockpos, config);
                list.forEach(attachment -> config.field_24135.method_27385((class_3746)level, consumer2, random, config, k1, attachment, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(class_3746 level, int trunkHeight, class_2338 pos, class_4643 config) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int i = 0; i <= trunkHeight + 1; ++i) {
            int j = config.field_24137.method_27378(trunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    mutable.method_25504((class_2382)pos, k, i, l);
                    if (DarkCanopyTreeFeature.isFree(level, (class_2338)mutable) && config.field_24138) continue;
                    return i - 2;
                }
            }
        }
        return trunkHeight;
    }

    protected void method_13153(class_1945 world, class_2338 pos, class_2680 state) {
        DarkCanopyTreeFeature.setBlockKnownShape(world, pos, state);
    }

    public static void setBlockKnownShape(class_1945 p_236408_0_, class_2338 p_236408_1_, class_2680 p_236408_2_) {
        p_236408_0_.method_8652(p_236408_1_, p_236408_2_, 19);
    }

    private static class_251 updateLeaves(class_1936 p_67203_, class_3341 p_67204_, Set<class_2338> p_67205_, Set<class_2338> p_67206_) {
        ArrayList list = Lists.newArrayList();
        class_244 discretevoxelshape = new class_244(p_67204_.method_35414(), p_67204_.method_14660(), p_67204_.method_14663());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        for (class_2338 blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.method_14662((class_2382)blockpos)) continue;
            discretevoxelshape.method_1049(blockpos.method_10263() - p_67204_.method_35415(), blockpos.method_10264() - p_67204_.method_35416(), blockpos.method_10260() - p_67204_.method_35417());
        }
        for (class_2338 blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.method_14662((class_2382)blockpos1)) {
                discretevoxelshape.method_1049(blockpos1.method_10263() - p_67204_.method_35415(), blockpos1.method_10264() - p_67204_.method_35416(), blockpos1.method_10260() - p_67204_.method_35417());
            }
            for (class_2350 direction : class_2350.values()) {
                class_2680 blockstate;
                blockpos$mutableblockpos.method_25505((class_2382)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.method_10062());
                DarkCanopyTreeFeature.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, (class_2680)blockstate.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) continue;
                discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (class_2338 blockpos2 : set) {
                if (p_67204_.method_14662((class_2382)blockpos2)) {
                    discretevoxelshape.method_1049(blockpos2.method_10263() - p_67204_.method_35415(), blockpos2.method_10264() - p_67204_.method_35416(), blockpos2.method_10260() - p_67204_.method_35417());
                }
                for (class_2350 direction1 : class_2350.values()) {
                    int k;
                    class_2680 blockstate1;
                    blockpos$mutableblockpos.method_25505((class_2382)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.method_8320((class_2338)blockpos$mutableblockpos)).method_28498((class_2769)class_2741.field_12541) || (k = ((Integer)blockstate1.method_11654((class_2769)class_2741.field_12541)).intValue()) <= l + 1) continue;
                    class_2680 blockstate2 = (class_2680)blockstate1.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(l + 1));
                    DarkCanopyTreeFeature.setBlockKnownShape((class_1945)p_67203_, (class_2338)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.method_14662((class_2382)blockpos$mutableblockpos)) {
                        discretevoxelshape.method_1049(blockpos$mutableblockpos.method_10263() - p_67204_.method_35415(), blockpos$mutableblockpos.method_10264() - p_67204_.method_35416(), blockpos$mutableblockpos.method_10260() - p_67204_.method_35417());
                    }
                    set1.add(blockpos$mutableblockpos.method_10062());
                }
            }
        }
        return discretevoxelshape;
    }

    public static boolean isFree(class_3746 pLevel, class_2338 pPos) {
        return DarkCanopyTreeFeature.validTreePos(pLevel, pPos) || pLevel.method_16358(pPos, p_67281_ -> p_67281_.method_26164(class_3481.field_15475));
    }

    private static boolean isBlockWater(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_67271_ -> p_67271_.method_27852(class_2246.field_10382));
    }

    public static boolean isAirOrLeaves(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_67266_ -> p_67266_.method_26215() || p_67266_.method_26164(class_3481.field_15503) || p_67266_.method_27852((class_2248)TFBlocks.HARDENED_DARK_LEAVES.get()));
    }

    private static boolean isReplaceablePlant(class_3746 pLevel, class_2338 pPos) {
        return pLevel.method_16358(pPos, p_160551_ -> {
            class_3614 material = p_160551_.method_26207();
            return material == class_3614.field_15956;
        });
    }

    public static boolean validTreePos(class_3746 pLevel, class_2338 pPos) {
        return DarkCanopyTreeFeature.isAirOrLeaves(pLevel, pPos) || DarkCanopyTreeFeature.isReplaceablePlant(pLevel, pPos) || DarkCanopyTreeFeature.isBlockWater(pLevel, pPos);
    }
}

