/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.IPlantable;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeFeature;

public class MiningTreeFeature
extends TFTreeFeature<TFTreeFeatureConfig> {
    public MiningTreeFeature(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        if (world.method_31601(pos.method_10264() + 12)) {
            return false;
        }
        class_2680 state = world.method_8320(pos.method_10074());
        if (!state.method_26204().canSustainPlant(state, (class_1922)world, pos.method_10074(), class_2350.field_11036, (IPlantable)TFBlocks.MINING_SAPLING.get())) {
            return false;
        }
        for (int dy = 0; dy <= 9; ++dy) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10086(dy), config.trunkProvider);
        }
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 9, 1), true, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 9, 2), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 8, 3), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 7, 4), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 6, 5), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 9, -1), true, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 9, -2), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 8, -3), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 7, -4), false, config);
        MiningTreeFeature.putBranchWithLeaves((class_1936)world, trunkPlacer, leavesPlacer, random, pos.method_10069(0, 6, -5), false, config);
        world.method_8652(pos.method_10084(), (class_2680)((class_2248)TFBlocks.MINING_LOG_CORE.get()).method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)class_2350.class_2351.field_11052), 3);
        world.method_39279(pos.method_10084(), (class_2248)TFBlocks.MINING_LOG_CORE.get(), 20);
        if (FeatureUtil.hasAirAround((class_1936)world, pos.method_10074())) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10074(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((class_3746)world, decorationPlacer, random, pos.method_10074(), config.rootsProvider);
        }
        int numRoots = 3 + random.method_43048(2);
        float offset = random.method_43057();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((class_1936)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    protected static void putBranchWithLeaves(class_1936 world, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, class_5819 rand, class_2338 pos, boolean bushy, TFTreeFeatureConfig config) {
        FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, rand, pos, config.branchProvider);
        for (int lx = -1; lx <= 1; ++lx) {
            for (int ly = -1; ly <= 1; ++ly) {
                for (int lz = -1; lz <= 1; ++lz) {
                    if (!bushy && Math.abs(ly) > 0 && Math.abs(lx) > 0) continue;
                    FeaturePlacers.placeProvidedBlock((class_3746)world, leavesPlacer, FeaturePlacers.VALID_TREE_POS, pos.method_10069(lx, ly, lz), config.leavesProvider, rand);
                }
            }
        }
    }
}

