/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import twilightforest.init.BiomeKeys;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer0;

public enum GenLayerTFBiomes implements AreaTransformer0
{
    INSTANCE;

    private static final int RARE_BIOME_CHANCE = 15;
    private static final List<class_5321<class_1959>> commonBiomes;
    private static final List<class_5321<class_1959>> rareBiomes;
    private class_2378<class_1959> registry;

    public GenLayerTFBiomes setup(class_2378<class_1959> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int applyPixel(Context iNoiseRandom, int x, int y) {
        if (iNoiseRandom.nextRandom(15) == 0) {
            return this.getRandomBiome(iNoiseRandom, rareBiomes);
        }
        return this.getRandomBiome(iNoiseRandom, commonBiomes);
    }

    private int getRandomBiome(Context random, List<class_5321<class_1959>> biomes) {
        return TFBiomeProvider.getBiomeId(biomes.get(random.nextRandom(biomes.size())), this.registry);
    }

    static {
        commonBiomes = ImmutableList.of(BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST);
        rareBiomes = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.CLEARING, BiomeKeys.SPOOKY_FOREST);
    }
}

