/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import com.google.common.collect.Lists;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.PaintingAccessor;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1530;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2510;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFEntities;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.loot.TFLootTables;
import twilightforest.util.RotationUtil;
import twilightforest.util.TFStructureHelper;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerBeardAttachedComponent;
import twilightforest.world.components.structures.lichtower.TowerBeardComponent;
import twilightforest.world.components.structures.lichtower.TowerBridgeComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofAttachedSlabComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofFenceComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofGableForwardsComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofPointyOverhangComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofSlabComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofSlabForwardsComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofStairsComponent;
import twilightforest.world.components.structures.lichtower.TowerRoofStairsOverhangComponent;

public class TowerWingComponent
extends TFStructureComponentOld {
    public int size;
    protected int height;
    protected Class<? extends TowerRoofComponent> roofType;
    protected ArrayList<class_2338> openings = new ArrayList();
    protected int highestOpening;
    protected boolean[] openingTowards = new boolean[]{false, false, true, false};

    public TowerWingComponent(class_6625 ctx, class_2487 nbt) {
        this((class_3773)TFStructurePieceTypes.TFLTWin.get(), nbt);
    }

    public TowerWingComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.size = nbt.method_10550("towerSize");
        this.height = nbt.method_10550("towerHeight");
        this.readOpeningsFromArray(nbt.method_10561("doorInts"));
        this.highestOpening = nbt.method_10550("highestOpening");
        this.openingTowards[0] = nbt.method_10577("openingTowards0");
        this.openingTowards[1] = nbt.method_10577("openingTowards1");
        this.openingTowards[2] = nbt.method_10577("openingTowards2");
        this.openingTowards[3] = nbt.method_10577("openingTowards3");
    }

    protected TowerWingComponent(class_3773 type, TFLandmark feature, int i, int x, int y, int z) {
        super(type, feature, i, x, y, z);
        this.highestOpening = 0;
    }

    protected TowerWingComponent(class_3773 type, TFLandmark feature, int i, int x, int y, int z, int pSize, int pHeight, class_2350 direction) {
        super(type, feature, i, x, y, z);
        this.size = pSize;
        this.height = pHeight;
        this.method_14926(direction);
        this.highestOpening = 0;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    private int[] getDoorsAsIntArray() {
        IntBuffer ibuffer = IntBuffer.allocate(this.openings.size() * 3);
        for (class_2338 door : this.openings) {
            ibuffer.put(door.method_10263());
            ibuffer.put(door.method_10264());
            ibuffer.put(door.method_10260());
        }
        return ibuffer.array();
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10569("towerSize", this.size);
        tagCompound.method_10569("towerHeight", this.height);
        tagCompound.method_10539("doorInts", this.getDoorsAsIntArray());
        tagCompound.method_10569("highestOpening", this.highestOpening);
        tagCompound.method_10556("openingTowards0", this.openingTowards[0]);
        tagCompound.method_10556("openingTowards1", this.openingTowards[1]);
        tagCompound.method_10556("openingTowards2", this.openingTowards[2]);
        tagCompound.method_10556("openingTowards3", this.openingTowards[3]);
    }

    private void readOpeningsFromArray(int[] intArray) {
        for (int i = 0; i < intArray.length; i += 3) {
            class_2338 door = new class_2338(intArray[i], intArray[i + 1], intArray[i + 2]);
            this.openings.add(door);
        }
    }

    public void method_14918(class_3443 parent, class_6130 list, class_5819 rand) {
        this.addOpening(0, 1, this.size / 2, class_2470.field_11464);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 4) {
            for (class_2470 towerRotation : RotationUtil.ROTATIONS) {
                int[] dest;
                if (towerRotation == class_2470.field_11464 || this.makeTowerWing(list, rand, 1, (dest = this.getValidOpening(rand, towerRotation))[0], dest[1], dest[2], this.size - 2, this.height - 4, towerRotation) || this.size <= 8 || this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 4, this.height - 6, towerRotation)) continue;
                this.makeTowerWing(list, rand, 1, dest[0], dest[1], dest[2], this.size - 6, this.height - 12, towerRotation);
            }
        }
    }

    public boolean makeTowerWing(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        if (wingHeight < 6) {
            return false;
        }
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (rand.method_43048(6) == 0) {
            return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation);
        }
        TowerWingComponent wing = new TowerWingComponent((class_3773)TFStructurePieceTypes.TFLTWin.get(), this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        class_3443 intersect = list.method_35461(wing.field_15315);
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)wing);
            wing.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        if (rand.method_43048(3) > 0) {
            return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation);
        }
        return false;
    }

    protected boolean makeBridge(class_6130 list, class_5819 rand, int index, int x, int y, int z, int wingSize, int wingHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        if (wingSize == 3 && wingHeight > 10) {
            wingHeight = 6 + rand.method_43048(5);
        }
        TowerBridgeComponent bridge = new TowerBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        class_3443 intersect = list.method_35461(bridge.field_15315);
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = list.method_35461(bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)bridge);
            bridge.method_14918(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    public void addOpening(int dx, int dy, int dz, class_2470 direction) {
        this.openingTowards[direction.ordinal()] = true;
        if (dy > this.highestOpening) {
            this.highestOpening = dy;
        }
        this.openings.add(new class_2338(dx, dy, dz));
    }

    public void addOpening(int dx, int dy, int dz, class_2350 facing) {
        this.addOpening(dx, dy, dz, RotationUtil.getRelativeRotation(this.method_14934(), facing));
    }

    public void makeABeard(class_3443 parent, class_6130 list, class_5819 rand) {
        boolean attached = parent.method_14935().method_35416() < this.field_15315.method_35416();
        int index = this.method_14923();
        TowerBeardComponent beard = attached ? new TowerBeardAttachedComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()) : new TowerBeardComponent((class_3773)TFStructurePieceTypes.TFLTBea.get(), this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
        list.method_35462((class_3443)beard);
        beard.method_14918(this, list, rand);
    }

    public void makeARoof(class_3443 parent, class_6130 list, class_5819 rand) {
        boolean attached;
        boolean bl = attached = parent.method_14935().method_35419() > this.field_15315.method_35419();
        if (attached) {
            this.makeAttachedRoof(list, rand);
        } else {
            this.makeFreestandingRoof(list, rand);
        }
    }

    protected void makeAttachedRoof(class_6130 list, class_5819 rand) {
        TowerRoofComponent roof;
        int index = this.method_14923();
        if (this.roofType == null && rand.method_43048(32) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofGableForwardsComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()));
        }
        if (this.roofType == null && rand.method_43048(8) != 0) {
            this.tryToFitRoof(list, rand, new TowerRoofSlabForwardsComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260()));
        }
        if (this.roofType == null && rand.method_43048(32) != 0) {
            roof = new TowerRoofAttachedSlabComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofFenceComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
    }

    protected void tryToFitRoof(class_6130 list, class_5819 rand, TowerRoofComponent roof) {
        if (roof.fits(this, list)) {
            list.method_35462((class_3443)roof);
            roof.method_14918(this, list, rand);
            this.roofType = roof.getClass();
        }
    }

    protected void makeFreestandingRoof(class_6130 list, class_5819 rand) {
        TowerRoofComponent roof;
        int index = this.method_14923();
        if (this.roofType == null && rand.method_43048(8) != 0) {
            roof = new TowerRoofPointyOverhangComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofStairsOverhangComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofStairsComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null && rand.method_43048(53) != 0) {
            roof = new TowerRoofSlabComponent((class_3773)TFStructurePieceTypes.TFLTRS.get(), this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new TowerRoofFenceComponent(this.getFeatureType(), index + 1, this, this.method_35458().method_10263(), this.method_35458().method_10264(), this.method_35458().method_10260());
            this.tryToFitRoof(list, rand, roof);
        }
    }

    public void method_14931(class_5281 worldIn, class_5138 manager, class_2794 generator, class_5819 rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        this.method_14938(worldIn, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, TFStructureComponentOld.getStrongholdStones());
        this.method_14942(worldIn, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        if (this.highestOpening > 1) {
            this.makeStairs(worldIn, rand, sbb);
        }
        this.decorateThisTower(worldIn, sbb);
        this.makeWindows(worldIn, sbb, this.size < 4);
        this.makeOpenings(worldIn, sbb);
    }

    protected void makeOpeningMarkers(class_5281 world, class_5819 rand, int numMarkers, class_3341 sbb) {
        if (this.size > 4) {
            int[] spot;
            int i;
            class_2680 woolWhite = class_2246.field_10446.method_9564();
            class_2680 woolOrange = class_2246.field_10095.method_9564();
            class_2680 woolMagenta = class_2246.field_10215.method_9564();
            class_2680 woolLightBlue = class_2246.field_10294.method_9564();
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, class_2470.field_11467);
                this.method_14917(world, woolWhite, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, class_2470.field_11463);
                this.method_14917(world, woolOrange, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, class_2470.field_11464);
                this.method_14917(world, woolMagenta, spot[0], spot[1], spot[2], sbb);
            }
            for (i = 0; i < numMarkers; ++i) {
                spot = this.getValidOpening(rand, class_2470.field_11465);
                this.method_14917(world, woolLightBlue, spot[0], spot[1], spot[2], sbb);
            }
        }
    }

    protected void decorateThisTower(class_5281 world, class_3341 sbb) {
        class_5819 decoRNG = class_5819.method_43049((long)(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L * ((long)this.field_15315.method_35417() * 756839L)));
        if (this.size > 3) {
            if (this.isDeadEnd()) {
                this.decorateDeadEnd(world, decoRNG, sbb);
            } else {
                this.decorateStairTower(world, decoRNG, sbb);
            }
        }
    }

    protected void decorateDeadEnd(class_5281 world, class_5819 rand, class_3341 sbb) {
        class_2680 birchPlanks = class_2246.field_10148.method_9564();
        int floors = (this.height - 1) / 5;
        int floorHeight = this.height / floors;
        for (int i = 1; i < floors; ++i) {
            for (int x = 1; x < this.size - 1; ++x) {
                for (int z = 1; z < this.size - 1; ++z) {
                    this.method_14917(world, birchPlanks, x, i * floorHeight, z, sbb);
                }
            }
        }
        if (floors > 1) {
            class_2470 ladderDir = class_2470.field_11465;
            this.decorateFloor(world, rand, 0, 1, floorHeight, ladderDir, null, sbb);
            for (int i = 1; i < floors - 1; ++i) {
                int bottom = 1 + floorHeight * i;
                int top = floorHeight * (i + 1);
                class_2470 downLadderDir = ladderDir;
                ladderDir = ladderDir.method_10501(class_2470.field_11463);
                this.decorateFloor(world, rand, i, bottom, top, ladderDir, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, 1 + floorHeight * (floors - 1), this.height - 1, null, ladderDir, sbb);
        } else {
            this.decorateFloor(world, rand, 0, 1, this.height - 1, null, null, sbb);
        }
    }

    protected void decorateFloor(class_5281 world, class_5819 rand, int floor, int bottom, int top, @Nullable class_2470 ladderUpDir, @Nullable class_2470 ladderDownDir, class_3341 sbb) {
        int dy;
        int dz;
        int dx;
        class_2680 ladder = class_2246.field_9983.method_9564();
        if (ladderUpDir != null) {
            class_2680 ladderUp = (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)ladderUpDir.method_10503(class_2350.field_11034));
            dx = this.getLadderX(ladderUpDir);
            dz = this.getLadderZ(ladderUpDir);
            for (dy = bottom; dy < top; ++dy) {
                this.method_14917(world, ladderUp, dx, dy, dz, sbb);
            }
        }
        if (ladderDownDir != null) {
            class_2680 ladderDown = (class_2680)ladder.method_11657((class_2769)class_2399.field_11253, (Comparable)ladderDownDir.method_10503(class_2350.field_11034));
            dx = this.getLadderX(ladderDownDir);
            dz = this.getLadderZ(ladderDownDir);
            for (dy = bottom - 1; dy < bottom + 2; ++dy) {
                this.method_14917(world, ladderDown, dx, dy, dz, sbb);
            }
        }
        if (rand.method_43048(7) == 0 && ladderDownDir == null) {
            this.decorateWell(world, rand, bottom, sbb);
        } else if (rand.method_43048(7) == 0 && ladderDownDir == null) {
            this.decorateSkeletonRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.method_43048(6) == 0 && ladderDownDir == null) {
            this.decorateZombieRoom(world, rand, bottom, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.method_43048(5) == 0 && ladderDownDir == null) {
            this.decorateCactusRoom(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.method_43048(4) == 0 && ladderDownDir != null) {
            this.decorateTreasureChest(world, bottom, top, sbb);
        } else if (rand.method_43048(5) == 0) {
            this.decorateSpiderWebs(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.method_43048(12) == 0 && ladderDownDir != null) {
            this.decorateSolidRock(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else if (rand.method_43048(3) == 0) {
            this.decorateFullLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        } else {
            this.decorateLibrary(world, rand, bottom, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateWell(class_5281 world, class_5819 rand, int bottom, class_3341 sbb) {
        class_2680 waterOrLava;
        int cx = this.size / 2;
        class_2680 class_26802 = waterOrLava = rand.method_43048(4) == 0 ? class_2246.field_10164.method_9564() : class_2246.field_10382.method_9564();
        if (this.size > 5) {
            class_2680 stoneBricks = class_2246.field_10056.method_9564();
            class_2680 stoneSlabs = TFStructureHelper.stoneSlab;
            this.method_14917(world, stoneBricks, cx - 1, bottom, cx - 1, sbb);
            this.method_14917(world, stoneSlabs, cx - 1, bottom + 1, cx - 1, sbb);
            this.method_14917(world, stoneBricks, cx, bottom, cx - 1, sbb);
            this.method_14917(world, stoneBricks, cx + 1, bottom, cx - 1, sbb);
            this.method_14917(world, stoneSlabs, cx + 1, bottom + 1, cx - 1, sbb);
            this.method_14917(world, stoneBricks, cx - 1, bottom, cx, sbb);
            this.method_14917(world, waterOrLava, cx, bottom, cx, sbb);
            this.method_14917(world, stoneBricks, cx + 1, bottom, cx, sbb);
            this.method_14917(world, stoneBricks, cx - 1, bottom, cx + 1, sbb);
            this.method_14917(world, stoneSlabs, cx - 1, bottom + 1, cx + 1, sbb);
            this.method_14917(world, stoneBricks, cx, bottom, cx + 1, sbb);
            this.method_14917(world, stoneBricks, cx + 1, bottom, cx + 1, sbb);
            this.method_14917(world, stoneSlabs, cx + 1, bottom + 1, cx + 1, sbb);
        }
        this.method_14917(world, waterOrLava, cx, bottom - 1, cx, sbb);
    }

    protected void decorateSkeletonRoom(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, class_1299.field_6137);
        ArrayList<class_2338> chainList = new ArrayList<class_2338>();
        chainList.add(new class_2338(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 2; ++i) {
            class_2338 chain = new class_2338(2 + rand.method_43048(this.size - 4), this.height - 2, 2 + rand.method_43048(this.size - 4));
            if (this.chainCollides(chain, chainList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.method_14917(world, class_2246.field_10576.method_9564(), chain.method_10263(), dy, chain.method_10260(), sbb);
            }
            chainList.add(chain);
        }
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                this.method_14917(world, class_2246.field_10343.method_9564(), dx, top - 1, dz, sbb);
            }
        }
    }

    protected void decorateZombieRoom(class_5281 world, class_5819 rand, int bottom, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, class_1299.field_6051);
        class_2680 ironBars = class_2246.field_10576.method_9564();
        class_2680 soulSand = class_2246.field_10114.method_9564();
        class_2680 brownMushroom = class_2246.field_10251.method_9564();
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.method_43048(5) != 0) continue;
                this.method_14917(world, brownMushroom, dx, bottom, dz, sbb);
            }
        }
        ArrayList<class_2338> slabList = new ArrayList<class_2338>();
        slabList.add(new class_2338(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size - 1; ++i) {
            class_2338 slab = new class_2338(2 + rand.method_43048(this.size - 4), this.height - 2, 2 + rand.method_43048(this.size - 4));
            if (this.chainCollides(slab, slabList)) continue;
            this.method_14917(world, ironBars, slab.method_10263(), bottom, slab.method_10260(), sbb);
            this.method_14917(world, TFStructureHelper.birchSlab, slab.method_10263(), bottom + 1, slab.method_10260(), sbb);
            this.method_14917(world, soulSand, slab.method_10263(), bottom + 2, slab.method_10260(), sbb);
            slabList.add(slab);
        }
    }

    protected void decorateCactusRoom(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                this.method_14917(world, class_2246.field_10102.method_9564(), dx, bottom - 1, dz, sbb);
                if (this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.method_43048(4) != 0) continue;
                this.method_14917(world, class_2246.field_10428.method_9564(), dx, bottom, dz, sbb);
            }
        }
        ArrayList<class_2338> cactusList = new ArrayList<class_2338>();
        cactusList.add(new class_2338(this.size / 2, bottom + 2, this.size / 2));
        for (int i = 0; i < this.size + 12; ++i) {
            class_2338 cactus = new class_2338(2 + rand.method_43048(this.size - 4), this.height - 2, 2 + rand.method_43048(this.size - 4));
            if (this.chainCollides(cactus, cactusList)) continue;
            for (int dy = bottom; dy < top; ++dy) {
                this.method_14917(world, class_2246.field_10029.method_9564(), cactus.method_10263(), dy, cactus.method_10260(), sbb);
            }
            cactusList.add(cactus);
        }
    }

    protected void decorateTreasureChest(class_5281 world, int bottom, int top, class_3341 sbb) {
        int cx = this.size / 2;
        class_2680 stoneBrick = class_2246.field_10056.method_9564();
        class_2680 stoneBrickStairs = class_2246.field_10392.method_9564();
        class_2680 topStoneBrickStairs = (class_2680)stoneBrickStairs.method_11657((class_2769)class_2510.field_11572, (Comparable)class_2760.field_12619);
        this.method_14917(world, stoneBrick, cx, bottom, cx, sbb);
        this.method_14917(world, stoneBrick, cx, top - 1, cx, sbb);
        if (this.size < 6) {
            this.surroundBlockCardinalRotated(world, stoneBrickStairs, cx, bottom, cx, sbb);
            this.surroundBlockCardinalRotated(world, topStoneBrickStairs, cx, top - 1, cx, sbb);
        } else {
            this.surroundBlockCardinalRotated(world, stoneBrickStairs, cx, bottom, cx, sbb);
            this.surroundBlockCorners(world, stoneBrick, cx, bottom, cx, sbb);
            for (int cy = bottom + 1; cy < top - 1; ++cy) {
                this.surroundBlockCorners(world, stoneBrick, cx, cy, cx, sbb);
            }
            this.surroundBlockCardinalRotated(world, topStoneBrickStairs, cx, top - 1, cx, sbb);
            this.surroundBlockCorners(world, stoneBrick, cx, top - 1, cx, sbb);
        }
        this.placeTreasureAtCurrentPosition(world, cx, bottom + 1, cx, TFLootTables.TOWER_ROOM, sbb);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void decorateSpiderWebs(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        int dy = bottom;
        while (true) {
            int chance;
            if (dy < top) {
                chance = top - dy + 2;
            } else {
                if (rand.method_43048(5) != 0) {
                    this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
                    return;
                }
                class_1299 spiderName = switch (rand.method_43048(4)) {
                    case 3 -> class_1299.field_6084;
                    case 2 -> (class_1299)TFEntities.SWARM_SPIDER.get();
                    case 1 -> (class_1299)TFEntities.HEDGE_SPIDER.get();
                    default -> class_1299.field_6079;
                };
                this.setSpawner(world, this.size / 2, bottom + 2, this.size / 2, sbb, spiderName);
                return;
            }
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.method_43048(chance) != 0) continue;
                    this.method_14917(world, class_2246.field_10343.method_9564(), dx, dy, dz, sbb);
                }
            }
            ++dy;
        }
    }

    protected void decorateFurniture(class_5281 world, class_5819 rand, int bottom, int freeSpace, class_3341 sbb) {
        if (rand.method_43048(3) > 0) {
            this.method_14917(world, class_2246.field_10620.method_9564(), this.size / 2, bottom, this.size / 2, sbb);
            this.method_14917(world, class_2246.field_10484.method_9564(), this.size / 2, bottom + 1, this.size / 2, sbb);
        }
        class_2680 spruceStairs = class_2246.field_10569.method_9564();
        if (rand.method_43048(3) == 0 && freeSpace > 1) {
            this.method_14917(world, (class_2680)spruceStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11039), this.size / 2 + 1, bottom, this.size / 2, sbb);
        }
        if (rand.method_43048(3) == 0 && freeSpace > 1) {
            this.method_14917(world, (class_2680)spruceStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11043), this.size / 2, bottom, this.size / 2 + 1, sbb);
        }
        if (rand.method_43048(3) == 0 && freeSpace > 1) {
            this.method_14917(world, (class_2680)spruceStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11034), this.size / 2 - 1, bottom, this.size / 2, sbb);
        }
        if (rand.method_43048(3) == 0 && freeSpace > 1) {
            this.method_14917(world, (class_2680)spruceStairs.method_11657((class_2769)class_2510.field_11571, (Comparable)class_2350.field_11035), this.size / 2, bottom, this.size / 2 - 1, sbb);
        }
    }

    protected void decorateSolidRock(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        for (int dy = bottom; dy < top; ++dy) {
            for (int dx = 1; dx <= this.size - 2; ++dx) {
                for (int dz = 1; dz <= this.size - 2; ++dz) {
                    if (this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir) || rand.method_43048(9) == 0) continue;
                    this.method_14917(world, class_2246.field_10340.method_9564(), dx, dy, dz, sbb);
                }
            }
        }
    }

    protected void decorateLibrary(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top - 1; ++dy) {
                    if (dx != 1 && dx != this.size - 2 && dz != 1 && dz != this.size - 2 || this.isWindowPos(dx, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.method_14917(world, class_2246.field_10504.method_9564(), dx, dy, dz, sbb);
                }
            }
        }
        if (rand.method_43048(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, top, ladderUpDir, ladderDownDir, sbb);
        }
        if (rand.method_43048(2) == 0 && this.size > 5) {
            this.decorateFurniture(world, rand, bottom, this.size - 2, sbb);
        }
    }

    protected void decorateLibraryTreasure(class_5281 world, class_5819 rand, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        switch (rand.method_43048(4)) {
            default: {
                if (!this.isLadderPos(2, 1, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, 2, top - 2, 1, TFLootTables.TOWER_LIBRARY, sbb);
                    break;
                }
            }
            case 1: {
                if (!this.isLadderPos(this.size - 2, 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, this.size - 2, top - 2, 2, TFLootTables.TOWER_LIBRARY, sbb);
                    break;
                }
            }
            case 2: {
                if (!this.isLadderPos(this.size - 3, this.size - 2, ladderUpDir, ladderDownDir)) {
                    this.placeTreasureAtCurrentPosition(world, this.size - 3, top - 2, this.size - 2, TFLootTables.TOWER_LIBRARY, sbb);
                    break;
                }
            }
            case 3: {
                if (this.isLadderPos(1, this.size - 3, ladderUpDir, ladderDownDir)) break;
                this.placeTreasureAtCurrentPosition(world, 1, top - 2, this.size - 3, TFLootTables.TOWER_LIBRARY, sbb);
            }
        }
    }

    protected void decorateFullLibrary(class_5281 world, class_5819 rand, int bottom, int top, class_2470 ladderUpDir, class_2470 ladderDownDir, class_3341 sbb) {
        for (int dx = 1; dx <= this.size - 2; ++dx) {
            for (int dz = 1; dz <= this.size - 2; ++dz) {
                for (int dy = bottom; dy < top; ++dy) {
                    if (!(dx % 2 != 0 && (dz >= dx && dz <= this.size - dx - 1 || dz >= this.size - dx - 1 && dz <= dx)) && (dz % 2 == 0 || (dx < dz || dx > this.size - dz - 1) && (dx < this.size - dz - 1 || dx > dz)) || this.isWindowPos(dx, dy, dz) || this.isOpeningPos(dx, dy, dz) || this.isLadderPos(dx, dz, ladderUpDir, ladderDownDir)) continue;
                    this.method_14917(world, class_2246.field_10504.method_9564(), dx, dy, dz, sbb);
                }
            }
        }
        if (rand.method_43048(2) == 0 && this.size > 5) {
            this.decorateLibraryTreasure(world, rand, top, ladderUpDir, ladderDownDir, sbb);
        }
    }

    protected void decorateTrap(class_5281 world, int bottom, int top, class_3341 sbb) {
        for (int dx = 2; dx <= this.size - 3; ++dx) {
            for (int dz = 2; dz <= this.size - 3; ++dz) {
                if (dx != 2 && dx != this.size - 3 && dz != 2 && dz != this.size - 3) continue;
                this.method_14917(world, class_2246.field_10375.method_9564(), dx, -1, dz, sbb);
            }
        }
        for (int dy = bottom - 2; dy < top - 2; ++dy) {
            this.method_14917(world, class_2246.field_10375.method_9564(), 1, dy, 1, sbb);
            this.method_14917(world, class_2246.field_10375.method_9564(), 1, dy, this.size - 2, sbb);
            this.method_14917(world, class_2246.field_10375.method_9564(), this.size - 2, dy, 1, sbb);
            this.method_14917(world, class_2246.field_10375.method_9564(), this.size - 2, dy, this.size - 2, sbb);
        }
    }

    protected boolean isWindowPos(int x, int z) {
        if (x == 1 && z == this.size / 2) {
            return true;
        }
        if (x == this.size - 2 && z == this.size / 2) {
            return true;
        }
        if (x == this.size / 2 && z == 1) {
            return true;
        }
        return x == this.size / 2 && z == this.size - 2;
    }

    protected boolean isWindowPos(int x, int y, int z) {
        int checkYDir = -1;
        if (x == 1 && z == this.size / 2) {
            checkYDir = 2;
        } else if (x == this.size - 2 && z == this.size / 2) {
            checkYDir = 0;
        } else if (x == this.size / 2 && z == 1) {
            checkYDir = 3;
        } else if (x == this.size / 2 && z == this.size - 2) {
            checkYDir = 1;
        }
        if (checkYDir > -1) {
            return !this.openingTowards[checkYDir] && (y == 2 || y == 3 || this.height > 8 && (y == this.height - 3 || y == this.height - 4));
        }
        return false;
    }

    protected boolean isOpeningPos(int x, int y, int z) {
        for (class_2338 door : this.openings) {
            class_2338.class_2339 inside = new class_2338.class_2339(door.method_10263(), door.method_10264(), door.method_10260());
            if (inside.method_10263() == 0) {
                inside.method_10098(class_2350.field_11034);
            } else if (inside.method_10263() == this.size - 1) {
                inside.method_10098(class_2350.field_11039);
            } else if (inside.method_10260() == 0) {
                inside.method_10098(class_2350.field_11035);
            } else if (inside.method_10260() == this.size - 1) {
                inside.method_10098(class_2350.field_11043);
            }
            if (inside.method_10263() != x || inside.method_10260() != z || inside.method_10264() != y && inside.method_10264() + 1 != y) continue;
            return true;
        }
        return false;
    }

    protected boolean isLadderPos(int x, int z, class_2470 ladderUpDir, class_2470 ladderDownDir) {
        if (ladderUpDir != null && x == this.getLadderX(ladderUpDir) && z == this.getLadderZ(ladderUpDir)) {
            return true;
        }
        return ladderDownDir != null && x == this.getLadderX(ladderDownDir) && z == this.getLadderZ(ladderDownDir);
    }

    protected int getLadderX(class_2470 ladderDir) {
        return switch (ladderDir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> this.size - 2;
            case class_2470.field_11463 -> this.size / 2 + 1;
            case class_2470.field_11464 -> 1;
            case class_2470.field_11465 -> this.size / 2 - 1;
        };
    }

    protected int getLadderZ(class_2470 ladderDir) {
        return switch (ladderDir) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> this.size / 2 - 1;
            case class_2470.field_11463 -> this.size - 2;
            case class_2470.field_11464 -> this.size / 2 + 1;
            case class_2470.field_11465 -> 1;
        };
    }

    protected void decorateStairTower(class_5281 world, class_5819 rand, class_3341 sbb) {
        if (this.height - this.highestOpening > 8) {
            int base = this.highestOpening + 3;
            int floors = (this.height - base) / 5;
            int floorHeight = (this.height - base) / floors;
            for (int i = 0; i < floors; ++i) {
                for (int x = 1; x < this.size - 1; ++x) {
                    for (int z = 1; z < this.size - 1; ++z) {
                        this.method_14917(world, TFStructureHelper.birchPlanks, x, i * floorHeight + base, z, sbb);
                    }
                }
            }
            class_2470 ladderDir = class_2470.field_11467;
            int dx = this.getLadderX(ladderDir);
            int dz = this.getLadderZ(ladderDir);
            class_2680 defaultState = (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)ladderDir.method_10503(class_2350.field_11034));
            for (int dy = 1; dy < 3; ++dy) {
                this.method_14917(world, defaultState, dx, base - dy, dz, sbb);
            }
            for (int i = 0; i < floors - 1; ++i) {
                int bottom = base + 1 + floorHeight * i;
                int top = base + floorHeight * (i + 1);
                class_2470 downLadderDir = ladderDir;
                ladderDir = ladderDir.method_10501(class_2470.field_11463);
                this.decorateFloor(world, rand, i, bottom, top, ladderDir, downLadderDir, sbb);
            }
            this.decorateFloor(world, rand, floors, base + 1 + floorHeight * (floors - 1), this.height - 1, null, ladderDir, sbb);
            if (base > 8) {
                switch (rand.method_43048(4)) {
                    case 0: {
                        this.decorateChandelier(world, rand, base + 1, sbb);
                        break;
                    }
                    case 1: {
                        this.decorateHangingChains(world, rand, base + 1, sbb);
                        break;
                    }
                    case 2: {
                        this.decorateFloatingBooks(world, rand, base + 1, sbb);
                        break;
                    }
                    case 3: {
                        this.decorateFloatingVines(world, rand, base + 1, sbb);
                    }
                }
            }
        } else if (this.size > 5) {
            switch (rand.method_43048(4)) {
                case 0: {
                    this.decorateChandelier(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 3: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        } else if (this.size > 3) {
            switch (rand.method_43048(3)) {
                case 0: {
                    this.decorateHangingChains(world, rand, this.height, sbb);
                    break;
                }
                case 1: {
                    this.decorateFloatingBooks(world, rand, this.height, sbb);
                    break;
                }
                case 2: {
                    this.decorateFloatingVines(world, rand, this.height, sbb);
                }
            }
        }
        this.decorateStairFloor(world, rand, sbb);
    }

    protected void decorateStairFloor(class_5281 world, class_5819 rand, class_3341 sbb) {
        if (this.size > 5) {
            if (rand.method_43048(3) == 0) {
                this.decorateStairWell(world, rand, sbb);
            } else if (rand.method_43048(3) > 0 || this.size >= 15) {
                this.decoratePlanter(world, rand, sbb);
            }
        }
    }

    protected void decorateChandelier(class_5281 world, class_5819 rand, int decoTop, class_3341 sbb) {
        if (decoTop < 8 || this.size < 8) {
            return;
        }
        int cx = this.size / 2;
        int cy = decoTop - rand.method_43048(decoTop - 7) - 2;
        int cz = this.size / 2;
        class_2680 oakFence = class_2246.field_10620.method_9564();
        this.surroundBlockCardinal(world, oakFence, cx, cy, cz, sbb);
        this.surroundBlockCardinal(world, oakFence, cx, cy + 1, cz, sbb);
        for (int y = cy; y < decoTop - 1; ++y) {
            this.method_14917(world, oakFence, cx, y, cz, sbb);
        }
    }

    protected void decorateHangingChains(class_5281 world, class_5819 rand, int decoTop, class_3341 sbb) {
        ArrayList<class_2338> chainList = new ArrayList<class_2338>();
        for (int i = 0; i < this.size + 2; ++i) {
            int filled = this.size < 15 ? 2 : 4;
            class_2338 chain = new class_2338(filled + rand.method_43048(this.size - filled * 2), decoTop - 2, filled + rand.method_43048(this.size - filled * 2));
            if (this.chainCollides(chain, chainList)) continue;
            int length = 1 + rand.method_43048(decoTop - 7);
            this.decorateOneChain(world, rand, chain.method_10263(), decoTop, length, chain.method_10260(), sbb);
            chainList.add(chain);
        }
    }

    protected boolean chainCollides(class_2338 coords, List<class_2338> list) {
        for (class_2338 existing : list) {
            if (coords.method_10260() == existing.method_10260() && Math.abs(coords.method_10263() - existing.method_10263()) <= 1) {
                return true;
            }
            if (coords.method_10263() != existing.method_10263() || Math.abs(coords.method_10260() - existing.method_10260()) > 1) continue;
            return true;
        }
        return false;
    }

    protected void decorateOneChain(class_5281 world, class_5819 rand, int dx, int decoTop, int length, int dz, class_3341 sbb) {
        for (int y = 1; y <= length; ++y) {
            this.method_14917(world, class_2246.field_10576.method_9564(), dx, decoTop - y - 1, dz, sbb);
        }
        class_2680 ballBlock = switch (rand.method_43048(10)) {
            case 0 -> class_2246.field_10085.method_9564();
            case 1 -> class_2246.field_10504.method_9564();
            case 2 -> class_2246.field_10515.method_9564();
            case 3 -> class_2246.field_10114.method_9564();
            case 4 -> class_2246.field_10033.method_9564();
            case 5 -> class_2246.field_10441.method_9564();
            case 6 -> class_2246.field_10387.method_9564();
            default -> class_2246.field_10171.method_9564();
        };
        this.method_14917(world, ballBlock, dx, decoTop - length - 2, dz, sbb);
    }

    protected void decorateFloatingBooks(class_5281 world, class_5819 rand, int decoTop, class_3341 sbb) {
        ArrayList<class_2338> shelfList = new ArrayList<class_2338>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            class_2338 shelf = new class_2338(filled + rand.method_43048(this.size - filled * 2), decoTop - 2, filled + rand.method_43048(this.size - filled * 2));
            if (this.chainCollides(shelf, shelfList)) continue;
            int bottom = 2 + rand.method_43048(decoTop - 7);
            for (int y = top = rand.method_43048(bottom - 1) + 2; y <= bottom; ++y) {
                this.method_14917(world, class_2246.field_10504.method_9564(), shelf.method_10263(), decoTop - y, shelf.method_10260(), sbb);
            }
            shelfList.add(shelf);
        }
    }

    protected void decorateFloatingVines(class_5281 world, class_5819 rand, int decoTop, class_3341 sbb) {
        class_2680 mossyCobbleStone = class_2246.field_9989.method_9564();
        class_2680 vine = class_2246.field_10597.method_9564();
        class_2680 vineNorth = (class_2680)vine.method_11657((class_2769)class_2541.field_11706, (Comparable)Boolean.valueOf(true));
        class_2680 vineSouth = (class_2680)vine.method_11657((class_2769)class_2541.field_11699, (Comparable)Boolean.valueOf(true));
        class_2680 vineEast = (class_2680)vine.method_11657((class_2769)class_2541.field_11702, (Comparable)Boolean.valueOf(true));
        class_2680 vineWest = (class_2680)vine.method_11657((class_2769)class_2541.field_11696, (Comparable)Boolean.valueOf(true));
        ArrayList<class_2338> mossList = new ArrayList<class_2338>();
        for (int i = 0; i < this.size + 2; ++i) {
            int top;
            int filled = this.size < 15 ? 2 : 4;
            class_2338 moss = new class_2338(filled + rand.method_43048(this.size - filled * 2), decoTop - 2, filled + rand.method_43048(this.size - filled * 2));
            if (this.chainCollides(moss, mossList)) continue;
            int bottom = 2 + rand.method_43048(decoTop - 7);
            for (int y = top = rand.method_43048(bottom - 1) + 2; y <= bottom; ++y) {
                this.method_14917(world, mossyCobbleStone, moss.method_10263(), decoTop - y, moss.method_10260(), sbb);
                this.method_14917(world, vineEast, moss.method_10263() + 1, decoTop - y, moss.method_10260(), sbb);
                this.method_14917(world, vineWest, moss.method_10263() - 1, decoTop - y, moss.method_10260(), sbb);
                this.method_14917(world, vineSouth, moss.method_10263(), decoTop - y, moss.method_10260() + 1, sbb);
                this.method_14917(world, vineNorth, moss.method_10263(), decoTop - y, moss.method_10260() - 1, sbb);
            }
            mossList.add(moss);
        }
        for (int y = this.highestOpening + 3; y < decoTop - 1; ++y) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (rand.method_43048(3) == 0) {
                    this.method_14917(world, vineSouth, x, y, 1, sbb);
                }
                if (rand.method_43048(3) != 0) continue;
                this.method_14917(world, vineNorth, x, y, this.size - 2, sbb);
            }
            for (int z = 1; z < this.size - 1; ++z) {
                if (rand.method_43048(3) == 0) {
                    this.method_14917(world, vineEast, 1, y, z, sbb);
                }
                if (rand.method_43048(3) != 0) continue;
                this.method_14917(world, vineWest, this.size - 2, y, z, sbb);
            }
        }
    }

    protected void decoratePlanter(class_5281 world, class_5819 rand, class_3341 sbb) {
        int cx = this.size / 2;
        this.surroundBlockCardinal(world, TFStructureHelper.stoneSlab, cx, 1, cx, sbb);
        if (this.size > 7) {
            this.surroundBlockCorners(world, TFStructureHelper.stoneSlabDouble, cx, 1, cx, sbb);
        }
        this.method_14917(world, class_2246.field_10219.method_9564(), cx, 1, cx, sbb);
        int i = rand.method_43048(6);
        boolean isTree = i > 4;
        class_2680 plant = isTree ? TFStructureHelper.randomSapling(i) : TFStructureHelper.randomMushroom(i);
        this.method_14917(world, plant, cx, 2, cx, sbb);
        class_2338 pos = this.getBlockPosWithOffset(cx, 2, cx);
        class_2680 whatHappened = this.method_14929((class_1922)world, cx, 2, cx, sbb);
        if (whatHappened.method_26204() == plant.method_26204() || whatHappened.method_26204() == class_2246.field_10124) {
            this.method_14917(world, class_2246.field_10495.method_9564(), cx, 2, cx, sbb);
        }
    }

    protected void decorateStairWell(class_5281 world, class_5819 rand, class_3341 sbb) {
        int cx = this.size / 2;
        int cy = 1;
        class_2680 waterOrLava = rand.method_43048(4) == 0 ? class_2246.field_10164.method_9564() : class_2246.field_10382.method_9564();
        class_2680 stoneSlab = class_2246.field_10136.method_9564();
        class_2680 stoneBrick = class_2246.field_10056.method_9564();
        if (this.size > 7) {
            this.method_14917(world, stoneBrick, cx - 1, cy, cx - 1, sbb);
            this.method_14917(world, stoneSlab, cx - 1, cy + 1, cx - 1, sbb);
            this.method_14917(world, stoneBrick, cx, cy, cx - 1, sbb);
            this.method_14917(world, stoneBrick, cx + 1, cy, cx - 1, sbb);
            this.method_14917(world, stoneSlab, cx + 1, cy + 1, cx - 1, sbb);
            this.method_14917(world, stoneBrick, cx - 1, cy, cx, sbb);
            this.method_14917(world, waterOrLava, cx, cy, cx, sbb);
            this.method_14917(world, stoneBrick, cx + 1, cy, cx, sbb);
            this.method_14917(world, stoneBrick, cx - 1, cy, cx + 1, sbb);
            this.method_14917(world, stoneSlab, cx - 1, cy + 1, cx + 1, sbb);
            this.method_14917(world, stoneBrick, cx, cy, cx + 1, sbb);
            this.method_14917(world, stoneBrick, cx + 1, cy, cx + 1, sbb);
            this.method_14917(world, stoneSlab, cx + 1, cy + 1, cx + 1, sbb);
        }
        this.method_14917(world, waterOrLava, cx, 0, cx, sbb);
    }

    public boolean isDeadEnd() {
        return this.openings.size() == 1;
    }

    protected void makeOpenings(class_5281 world, class_3341 sbb) {
        for (class_2338 door : this.openings) {
            this.makeDoorOpening(world, door.method_10263(), door.method_10264(), door.method_10260(), sbb);
        }
    }

    protected void makeDoorOpening(class_5281 world, int dx, int dy, int dz, class_3341 sbb) {
        this.method_14917(world, AIR, dx, dy, dz, sbb);
        this.method_14917(world, AIR, dx, dy + 1, dz, sbb);
        if (this.method_14929((class_1922)world, dx, dy + 2, dz, sbb).method_26204() != class_2246.field_10124) {
            class_2680 state = TFStructureHelper.stoneSlabDouble;
            this.method_14917(world, state, dx, dy + 2, dz, sbb);
        }
    }

    public int[] getValidOpening(class_5819 rand, class_2470 direction) {
        int wLength = this.size - 2;
        int offset = 1;
        if (this.size == 15) {
            wLength = 11;
            offset = 2;
        }
        if (direction == class_2470.field_11467 || direction == class_2470.field_11464) {
            int rx = direction == class_2470.field_11467 ? this.size - 1 : 0;
            int rz = offset + rand.method_43048(wLength);
            int ry = this.getYByStairs(rz, rand, direction);
            return new int[]{rx, ry, rz};
        }
        if (direction == class_2470.field_11463 || direction == class_2470.field_11465) {
            int rx = offset + rand.method_43048(wLength);
            int rz = direction == class_2470.field_11463 ? this.size - 1 : 0;
            int ry = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    protected int getYByStairs(int rx, class_5819 rand, class_2470 direction) {
        int rise = 1;
        int base = 0;
        if (this.size == 15) {
            rise = 10;
            int n = base = direction == class_2470.field_11467 || direction == class_2470.field_11464 ? 23 : 28;
        }
        if (this.size == 9) {
            rise = 6;
            int n = base = direction == class_2470.field_11467 || direction == class_2470.field_11464 ? 2 : 5;
        }
        if (this.size == 7) {
            rise = 4;
            int n = base = direction == class_2470.field_11467 || direction == class_2470.field_11464 ? 2 : 4;
        }
        if (this.size == 5) {
            rise = 4;
            base = switch (direction) {
                default -> throw new IncompatibleClassChangeError();
                case class_2470.field_11467 -> 3;
                case class_2470.field_11463 -> 2;
                case class_2470.field_11464 -> 5;
                case class_2470.field_11465 -> 4;
            };
        }
        int flights = (this.height - 6 - base) / rise + 1;
        if (base > 0 && flights > 0) {
            int flightChosen = rand.method_43048(flights);
            int dy = flightChosen * rise + base;
            dy = this.size == 15 ? (dy -= direction == class_2470.field_11467 || direction == class_2470.field_11465 ? (rx - 2) / 2 : (this.size - rx - 3) / 2) : (dy -= direction == class_2470.field_11467 || direction == class_2470.field_11465 ? (rx - 1) / 2 : (this.size - rx - 2) / 2);
            if (dy < 1) {
                dy = 1;
            }
            return dy;
        }
        return 0;
    }

    protected void makeWindows(class_5281 world, class_3341 sbb, boolean real) {
        for (class_2470 rotation : RotationUtil.ROTATIONS) {
            boolean realWindows = real && !this.openingTowards[rotation.ordinal()];
            this.makeWindowBlock(world, this.size - 1, 2, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, 3, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, 1, this.size / 2, rotation, sbb);
            if (this.height <= 8) continue;
            this.makeWindowBlock(world, this.size - 1, this.height - 3, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBlock(world, this.size - 1, this.height - 4, this.size / 2, rotation, sbb, realWindows);
            this.makeWindowBase(world, this.size - 1, this.height - 5, this.size / 2, rotation, sbb);
        }
    }

    protected void makeWindowBlock(class_5281 world, int x, int y, int z, class_2470 rotation, class_3341 sbb, boolean realWindows) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2248 outside = this.method_14929((class_1922)world, x + 1, y, z, sbb).method_26204();
        class_2248 inside = this.method_14929((class_1922)world, x - 1, y, z, sbb).method_26204();
        if (realWindows && inside == class_2246.field_10124 && outside == class_2246.field_10124) {
            this.method_14917(world, class_2246.field_10285.method_9564(), x, y, z, sbb);
        } else {
            this.method_14917(world, class_2246.field_10445.method_9564(), x, y, z, sbb);
        }
        this.method_14926(temp);
    }

    protected void makeWindowBase(class_5281 world, int x, int y, int z, class_2470 rotation, class_3341 sbb) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2680 state = TFStructureHelper.stoneSlabDouble;
        this.method_14917(world, state, x, y, z, sbb);
        this.method_14926(temp);
    }

    protected boolean makeStairs(class_5281 world, class_5819 rand, class_3341 sbb) {
        if (this.size == 15) {
            return this.makeStairs15(world, rand, sbb);
        }
        if (this.size == 9) {
            return this.makeStairs9(world, rand, sbb);
        }
        if (this.size == 7) {
            return this.makeStairs7(world, rand, sbb);
        }
        if (this.size == 5) {
            return this.makeStairs5(world, rand, sbb);
        }
        return false;
    }

    protected boolean makeStairs5(class_5281 world, class_5819 rand, class_3341 sbb) {
        int rise = 1;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs5flight(world, sbb, i * rise, this.getRotation(class_2470.field_11467, i * 3), true);
        }
        return true;
    }

    protected void makeStairs5flight(class_5281 world, class_3341 sbb, int height, class_2470 rotation, boolean useBirchWood) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2680 bottomSlab = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        class_2680 topSlab = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.method_14917(world, bottomSlab, 2, 1 + height, 3, sbb);
        this.method_14917(world, topSlab, 3, 1 + height, 3, sbb);
        this.method_14926(temp);
    }

    protected boolean makeStairs7(class_5281 world, class_5819 rand, class_3341 sbb) {
        this.method_14917(world, TFStructureHelper.birchSlab, 1, 1, 4, sbb);
        this.method_14917(world, TFStructureHelper.birchSlabTop, 1, 1, 5, sbb);
        this.method_14917(world, TFStructureHelper.stoneSlab, 5, 1, 2, sbb);
        this.method_14917(world, TFStructureHelper.stoneSlabTop, 5, 1, 1, sbb);
        int rise = 2;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs7flight(world, sbb, 1 + i * rise, this.getRotation(class_2470.field_11467, i * 3), true);
            this.makeStairs7flight(world, sbb, 1 + i * rise, this.getRotation(class_2470.field_11464, i * 3), false);
        }
        return true;
    }

    protected void makeStairs7flight(class_5281 world, class_3341 sbb, int height, class_2470 rotation, boolean useBirchWood) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2680 slabBottom = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        class_2680 slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.method_14917(world, slabBottom, 2, 1 + height, 5, sbb);
        this.method_14917(world, slabTop, 3, 1 + height, 5, sbb);
        this.method_14917(world, slabBottom, 4, 2 + height, 5, sbb);
        this.method_14917(world, slabTop, 5, 2 + height, 5, sbb);
        this.method_14926(temp);
    }

    protected boolean makeStairs9(class_5281 world, class_5819 rand, class_3341 sbb) {
        this.method_14917(world, TFStructureHelper.birchSlab, 1, 1, 6, sbb);
        this.method_14917(world, TFStructureHelper.birchSlabTop, 1, 1, 7, sbb);
        this.method_14917(world, TFStructureHelper.stoneSlab, 7, 1, 2, sbb);
        this.method_14917(world, TFStructureHelper.stoneSlabTop, 7, 1, 1, sbb);
        int rise = 3;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs9flight(world, sbb, 1 + i * rise, this.getRotation(class_2470.field_11467, i * 3), true);
            this.makeStairs9flight(world, sbb, 1 + i * rise, this.getRotation(class_2470.field_11464, i * 3), false);
        }
        return true;
    }

    protected void makeStairs9flight(class_5281 world, class_3341 sbb, int height, class_2470 rotation, boolean useBirchWood) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2680 slabBot = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        class_2680 slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        this.method_14917(world, slabBot, 2, 1 + height, 7, sbb);
        this.method_14917(world, slabTop, 3, 1 + height, 7, sbb);
        this.method_14917(world, slabBot, 4, 2 + height, 7, sbb);
        this.method_14917(world, slabTop, 5, 2 + height, 7, sbb);
        this.method_14917(world, slabBot, 6, 3 + height, 7, sbb);
        this.method_14917(world, slabTop, 7, 3 + height, 7, sbb);
        this.method_14926(temp);
    }

    protected boolean makeStairs15(class_5281 world, class_5819 rand, class_3341 sbb) {
        class_2680 planks = class_2246.field_10148.method_9564();
        class_2680 oakFence = class_2246.field_10620.method_9564();
        class_2680 birchSlab = TFStructureHelper.birchSlab;
        class_2680 stoneSlab = TFStructureHelper.stoneSlab;
        class_2680 doubleStoneSlab = TFStructureHelper.stoneSlabDouble;
        this.method_14917(world, birchSlab, 1, 1, 9, sbb);
        this.method_14917(world, birchSlab, 2, 1, 9, sbb);
        this.method_14917(world, planks, 1, 1, 10, sbb);
        this.method_14917(world, planks, 2, 1, 10, sbb);
        this.method_14917(world, birchSlab, 1, 2, 11, sbb);
        this.method_14917(world, birchSlab, 2, 2, 11, sbb);
        this.method_14917(world, planks, 1, 2, 12, sbb);
        this.method_14917(world, planks, 2, 2, 12, sbb);
        this.method_14917(world, planks, 1, 2, 13, sbb);
        this.method_14917(world, planks, 2, 2, 13, sbb);
        this.method_14917(world, planks, 3, 2, 11, sbb);
        this.method_14917(world, oakFence, 3, 3, 11, sbb);
        this.method_14917(world, oakFence, 3, 4, 11, sbb);
        this.method_14917(world, planks, 3, 1, 10, sbb);
        this.method_14917(world, oakFence, 3, 2, 10, sbb);
        this.method_14917(world, oakFence, 3, 3, 10, sbb);
        this.method_14917(world, planks, 3, 1, 9, sbb);
        this.method_14917(world, oakFence, 3, 2, 9, sbb);
        this.method_14917(world, stoneSlab, 13, 1, 5, sbb);
        this.method_14917(world, stoneSlab, 12, 1, 5, sbb);
        this.method_14917(world, doubleStoneSlab, 13, 1, 4, sbb);
        this.method_14917(world, doubleStoneSlab, 12, 1, 4, sbb);
        this.method_14917(world, stoneSlab, 13, 2, 3, sbb);
        this.method_14917(world, stoneSlab, 12, 2, 3, sbb);
        this.method_14917(world, doubleStoneSlab, 13, 2, 2, sbb);
        this.method_14917(world, doubleStoneSlab, 12, 2, 2, sbb);
        this.method_14917(world, doubleStoneSlab, 13, 2, 1, sbb);
        this.method_14917(world, doubleStoneSlab, 12, 2, 1, sbb);
        this.method_14917(world, doubleStoneSlab, 11, 2, 3, sbb);
        this.method_14917(world, oakFence, 11, 3, 3, sbb);
        this.method_14917(world, oakFence, 11, 4, 3, sbb);
        this.method_14917(world, doubleStoneSlab, 11, 1, 4, sbb);
        this.method_14917(world, oakFence, 11, 2, 4, sbb);
        this.method_14917(world, oakFence, 11, 3, 4, sbb);
        this.method_14917(world, doubleStoneSlab, 11, 1, 5, sbb);
        this.method_14917(world, oakFence, 11, 2, 5, sbb);
        int rise = 5;
        int numFlights = this.highestOpening / rise;
        for (int i = 0; i < numFlights; ++i) {
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, this.getRotation(class_2470.field_11467, i * 3), true);
            this.makeStairs15flight(world, rand, sbb, 2 + i * rise, this.getRotation(class_2470.field_11464, i * 3), false);
        }
        return true;
    }

    private class_2470 getRotation(class_2470 startRotation, int rotations) {
        int totalIncrements = startRotation.ordinal() + rotations;
        return RotationUtil.ROTATIONS[totalIncrements & 3];
    }

    protected void makeStairs15flight(class_5281 world, class_5819 rand, class_3341 sbb, int height, class_2470 rotation, boolean useBirchWood) {
        class_2350 temp = this.method_14934();
        this.method_14926(rotation.method_10503(temp));
        class_2680 oakFence = class_2246.field_10620.method_9564();
        class_2680 slabBot = useBirchWood ? TFStructureHelper.birchSlab : TFStructureHelper.stoneSlab;
        class_2680 slabTop = useBirchWood ? TFStructureHelper.birchSlabTop : TFStructureHelper.stoneSlabTop;
        class_2680 slabDoub = useBirchWood ? TFStructureHelper.birchPlanks : TFStructureHelper.stoneSlabDouble;
        this.method_14917(world, slabBot, 3, 1 + height, 13, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 4, 1 + height, 13, slabTop);
        this.method_14917(world, slabBot, 5, 2 + height, 13, sbb);
        this.method_14917(world, slabTop, 6, 2 + height, 13, sbb);
        this.method_14917(world, slabBot, 7, 3 + height, 13, sbb);
        this.method_14917(world, slabTop, 8, 3 + height, 13, sbb);
        this.method_14917(world, slabBot, 9, 4 + height, 13, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 10, 4 + height, 13, slabTop);
        this.method_14945(world, sbb, rand, 0.9f, 11, 5 + height, 13, slabBot);
        this.method_14917(world, slabTop, 12, 5 + height, 13, sbb);
        this.method_14917(world, slabTop, 13, 5 + height, 13, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 3, 1 + height, 12, slabBot);
        this.method_14917(world, slabTop, 4, 1 + height, 12, sbb);
        this.method_14917(world, slabBot, 5, 2 + height, 12, sbb);
        this.method_14917(world, slabTop, 6, 2 + height, 12, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 7, 3 + height, 12, slabBot);
        this.method_14917(world, slabTop, 8, 3 + height, 12, sbb);
        this.method_14917(world, slabBot, 9, 4 + height, 12, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 10, 4 + height, 12, slabTop);
        this.method_14917(world, slabBot, 11, 5 + height, 12, sbb);
        this.method_14917(world, slabTop, 12, 5 + height, 12, sbb);
        this.method_14917(world, slabTop, 13, 5 + height, 12, sbb);
        this.method_14917(world, slabDoub, 4, 1 + height, 11, sbb);
        this.method_14917(world, slabDoub, 5, 2 + height, 11, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 6, 2 + height, 11, slabTop);
        this.method_14917(world, slabDoub, 7, 3 + height, 11, sbb);
        this.method_14945(world, sbb, rand, 0.9f, 8, 3 + height, 11, slabTop);
        this.method_14917(world, slabDoub, 9, 4 + height, 11, sbb);
        this.method_14917(world, slabTop, 10, 4 + height, 11, sbb);
        this.method_14917(world, slabDoub, 11, 5 + height, 11, sbb);
        this.method_14917(world, oakFence, 4, 2 + height, 11, sbb);
        this.method_14917(world, oakFence, 5, 3 + height, 11, sbb);
        this.method_14917(world, oakFence, 6, 3 + height, 11, sbb);
        this.method_14917(world, oakFence, 7, 4 + height, 11, sbb);
        this.method_14917(world, oakFence, 8, 4 + height, 11, sbb);
        this.method_14917(world, oakFence, 9, 5 + height, 11, sbb);
        this.method_14917(world, oakFence, 10, 5 + height, 11, sbb);
        this.method_14917(world, oakFence, 11, 6 + height, 11, sbb);
        this.method_14917(world, oakFence, 4, 3 + height, 11, sbb);
        this.method_14917(world, oakFence, 6, 4 + height, 11, sbb);
        this.method_14917(world, oakFence, 8, 5 + height, 11, sbb);
        this.method_14917(world, oakFence, 10, 6 + height, 11, sbb);
        this.method_14917(world, oakFence, 11, 7 + height, 11, sbb);
        this.method_14926(temp);
    }

    protected void generatePaintingsOnWall(class_5281 world, class_5819 rand, int howMany, int floorLevel, class_2350 direction, int minSize, class_3341 sbb) {
        for (int i = 0; i < howMany; ++i) {
            class_2338 pCoords = this.getRandomWallSpot(rand, floorLevel, direction, sbb);
            class_5321<class_1535> art = this.getPaintingOfSize(rand, minSize);
            class_1534 painting = new class_1534(class_1299.field_6120, (class_1937)world.method_8410());
            painting.method_6892(direction);
            ((PaintingAccessor)painting).porting_lib$setVariant(class_2378.field_11150.method_40290(art));
            painting.method_5814((double)pCoords.method_10263(), (double)pCoords.method_10264(), (double)pCoords.method_10260());
            if (!this.checkPainting(world, painting)) continue;
            world.method_8649((class_1297)painting);
        }
    }

    protected class_5321<class_1535> getPaintingOfSize(class_5819 rand, int minSize) {
        ArrayList<class_5321> valid = new ArrayList<class_5321>();
        for (class_1535 art : class_2378.field_11150) {
            if (art.method_6945() < minSize && art.method_6943() < minSize) continue;
            valid.add(class_5321.method_29179((class_5321)class_2378.field_25074, (class_2960)class_2378.field_11150.method_10221((Object)art)));
        }
        if (valid.size() > 0) {
            return (class_5321)valid.get(rand.method_43048(valid.size()));
        }
        return null;
    }

    protected boolean checkPainting(class_5281 world, class_1534 painting) {
        if (painting == null) {
            return false;
        }
        class_238 largerBox = painting.method_5829();
        if (!world.method_8587((class_1297)painting, largerBox)) {
            return false;
        }
        List<class_1297> collidingEntities = this.getEntitiesInAABB(world, largerBox);
        for (class_1297 entityOnList : collidingEntities) {
            if (!(entityOnList instanceof class_1530)) continue;
            return false;
        }
        return true;
    }

    public List<class_1297> getEntitiesInAABB(class_5281 world, class_238 boundingBox) {
        ArrayList list = Lists.newArrayList();
        int i = class_3532.method_15357((double)((boundingBox.field_1323 - 2.0) / 16.0));
        int j = class_3532.method_15357((double)((boundingBox.field_1320 + 2.0) / 16.0));
        int k = class_3532.method_15357((double)((boundingBox.field_1321 - 2.0) / 16.0));
        int l = class_3532.method_15357((double)((boundingBox.field_1324 + 2.0) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                class_2791 chunk = world.method_22342(i1, j1, class_2806.field_16423);
                if (!(chunk instanceof class_2839)) continue;
                ((class_2839)chunk).method_12295().forEach(nbt -> {
                    class_1297 entity = class_1299.method_17842((class_2487)nbt, (class_1937)world.method_8410(), e -> e);
                    if (entity != null && boundingBox.method_994(entity.method_5829())) {
                        list.add(entity);
                    }
                });
            }
        }
        return list;
    }

    protected class_2338 getRandomWallSpot(class_5819 rand, int floorLevel, class_2350 direction, class_3341 sbb) {
        int minX = this.field_15315.method_35415() + 2;
        int maxX = this.field_15315.method_35418() - 2;
        int minY = this.field_15315.method_35416() + floorLevel + 2;
        int maxY = this.field_15315.method_35419() - 2;
        int minZ = this.field_15315.method_35417() + 2;
        int maxZ = this.field_15315.method_35420() - 2;
        if (direction == class_2350.field_11035) {
            minZ = this.field_15315.method_35417();
            maxZ = this.field_15315.method_35417();
        } else if (direction == class_2350.field_11039) {
            maxX = this.field_15315.method_35418();
            minX = this.field_15315.method_35418();
        } else if (direction == class_2350.field_11043) {
            maxZ = this.field_15315.method_35420();
            minZ = this.field_15315.method_35420();
        } else if (direction == class_2350.field_11034) {
            minX = this.field_15315.method_35415();
            maxX = this.field_15315.method_35415();
        }
        for (int i = 0; i < 30; ++i) {
            int cz;
            int cy;
            int cx = minX + (maxX > minX ? rand.method_43048(maxX - minX) : 0);
            class_2338 blockPos = new class_2338(cx, cy = minY + (maxY > minY ? rand.method_43048(maxY - minY) : 0), cz = minZ + (maxZ > minZ ? rand.method_43048(maxZ - minZ) : 0)).method_10093(direction);
            if (!sbb.method_14662((class_2382)blockPos)) continue;
            return blockPos;
        }
        TwilightForestMod.LOGGER.info("ComponentTFTowerWing#getRandomWallSpot - We didn't find a valid random spot on the wall.");
        return null;
    }

    protected void makeGlyphBranches(class_5281 world, class_5819 rand, class_2680 colour, class_3341 sbb) {
        class_2470 rotation = RotationUtil.ROTATIONS[rand.method_43048(4)];
        int startHeight = rand.method_43048((int)((float)this.height * 0.66f));
        int startZ = 3 + rand.method_43048(this.size - 6);
        int dx = this.getXWithOffsetRotated(0, startZ, rotation);
        int dz = this.getZWithOffsetRotated(0, startZ, rotation);
        if (sbb.method_14662((class_2382)new class_2338(dx, this.field_15315.method_35416() + 1, dz))) {
            class_2338 pos;
            for (int dy = this.method_14924(startHeight); dy > 0 && world.method_8320(pos = new class_2338(dx, dy, dz)).method_26164(BlockTagGenerator.CASTLE_BLOCKS) && world.method_8320(pos).method_26212((class_1922)world, pos); --dy) {
                world.method_8652(pos, colour, 2);
            }
        }
        int leftOffset = startZ - (1 + rand.method_43048(3));
        int leftHeight = rand.method_43048(this.height - startHeight);
        if (leftOffset >= 0) {
            for (int z = startZ; z > leftOffset; --z) {
                this.setBlockStateRotated(world, colour, 0, startHeight, z, rotation, sbb);
            }
            for (int y = startHeight; y < startHeight + leftHeight; ++y) {
                this.setBlockStateRotated(world, colour, 0, y, leftOffset, rotation, sbb);
            }
        }
        int rightOffset = startZ + (1 + rand.method_43048(3));
        int rightHeight = rand.method_43048(this.height - startHeight);
        if (rightOffset < this.size - 1) {
            for (int z = startZ; z < rightOffset; ++z) {
                this.setBlockStateRotated(world, colour, 0, startHeight, z, rotation, sbb);
            }
            for (int y = startHeight; y < startHeight + rightHeight; ++y) {
                this.setBlockStateRotated(world, colour, 0, y, rightOffset, rotation, sbb);
            }
        }
    }
}

