/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import twilightforest.init.TFLandmark;
import twilightforest.init.TFStructurePlacementTypes;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;

public class BiomeForcedLandmarkPlacement
extends class_6874 {
    public static final Codec<BiomeForcedLandmarkPlacement> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TFLandmark.CODEC.fieldOf("landmark_set").forGetter(p -> p.landmark), (App)Codec.intRange((int)-64, (int)256).fieldOf("scan_elevation").forGetter(p -> p.scanHeight)).apply((Applicative)inst, BiomeForcedLandmarkPlacement::new));
    private final TFLandmark landmark;
    private final int scanHeight;

    public BiomeForcedLandmarkPlacement(TFLandmark landmark, int biomeScanHeight) {
        super(class_2382.field_11176, class_6874.class_7154.field_37782, 1.0f, 0, Optional.empty());
        this.landmark = landmark;
        this.scanHeight = biomeScanHeight;
    }

    public boolean method_41639(class_2794 chunkGenerator, class_7138 randomState, long seed, int chunkX, int chunkZ) {
        return this.method_40168(chunkGenerator, randomState, seed, chunkX, chunkZ);
    }

    public boolean method_40168(class_2794 chunkGenerator, class_7138 randomState, long seed, int chunkX, int chunkZ) {
        if (chunkGenerator instanceof ChunkGeneratorTwilight) {
            ChunkGeneratorTwilight twilightGenerator = (ChunkGeneratorTwilight)chunkGenerator;
            return twilightGenerator.isLandmarkPickedForChunk(this.landmark, (class_6880<class_1959>)chunkGenerator.method_12098().method_38109(chunkX << 2, this.scanHeight, chunkZ << 2, randomState.method_42371()), chunkX, chunkZ, seed);
        }
        if (!LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkX, chunkZ)) {
            return false;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed) == this.landmark;
    }

    public class_6875<?> method_40166() {
        return (class_6875)TFStructurePlacementTypes.FORCED_LANDMARK_PLACEMENT_TYPE.get();
    }

    public TFLandmark getLandmark() {
        return this.landmark;
    }
}

