/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6880;
import twilightforest.init.BiomeKeys;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.registration.biomes.BiomeHelper;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<class_5321<class_1959>, class_1959> BIOMES = BiomeMaker.generateBiomes();

    public static List<TerrainColumn> makeBiomeList(class_2378<class_1959> biomeRegistry, class_6880<class_1959> undergroundBiome) {
        return List.of(BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.1f, 0.2f, biomeRegistry, BiomeKeys.DENSE_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.0625f, 0.05f, biomeRegistry, BiomeKeys.FIREFLY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.005f, 0.005f, biomeRegistry, BiomeKeys.CLEARING, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.1f, biomeRegistry, BiomeKeys.OAK_SAVANNAH, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.65f, 0.25f, biomeRegistry, BiomeKeys.STREAM, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.97f, 0.0f, biomeRegistry, BiomeKeys.LAKE, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.05f, biomeRegistry, BiomeKeys.DENSE_MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.ENCHANTED_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.SPOOKY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.9f, 0.15f, biomeRegistry, BiomeKeys.SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.2f, 0.05f, biomeRegistry, BiomeKeys.FIRE_SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, BiomeKeys.DARK_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, BiomeKeys.DARK_FOREST_CENTER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.15f, biomeRegistry, BiomeKeys.SNOWY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, BiomeKeys.GLACIER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(3.0f, 0.25f, biomeRegistry, BiomeKeys.HIGHLANDS, undergroundBiome), BiomeMaker.biomeColumnToBedrock(7.0f, 0.1f, biomeRegistry, BiomeKeys.THORNLANDS), BiomeMaker.biomeColumnToBedrock(13.75f, 0.025f, biomeRegistry, BiomeKeys.FINAL_PLATEAU));
    }

    private static TerrainColumn biomeColumnWithUnderground(float noiseDepth, float noiseScale, class_2378<class_1959> biomeRegistry, class_5321<class_1959> key, class_6880<class_1959> undergroundBiome) {
        class_6880.class_6883 biomeHolder = class_6880.class_6883.method_40234(biomeRegistry, key);
        biomeHolder.method_40236(key, (Object)BIOMES.get(key));
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (class_6880<class_1959>)biomeHolder, treeMap -> {
            treeMap.put(Math.min(noiseDepth - 1.0f, -1.0f), (Object)biomeHolder);
            treeMap.put(Math.min(noiseDepth - 3.0f, -3.0f), (Object)undergroundBiome);
        });
    }

    private static TerrainColumn biomeColumnToBedrock(float noiseDepth, float noiseScale, class_2378<class_1959> biomeRegistry, class_5321<class_1959> key) {
        class_6880.class_6883 biomeHolder = class_6880.class_6883.method_40234(biomeRegistry, key);
        biomeHolder.method_40236(key, (Object)BIOMES.get(key));
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (class_6880<class_1959>)biomeHolder, treeMap -> treeMap.put(0.0f, (Object)biomeHolder));
    }

    private static TerrainColumn makeColumn(float noiseDepth, float noiseScale, class_6880<class_1959> biomeHolder, Consumer<Float2ObjectSortedMap<class_6880<class_1959>>> layerBuilder) {
        return new TerrainColumn(biomeHolder, (Float2ObjectSortedMap<class_6880<class_1959>>)((Float2ObjectSortedMap)class_156.method_654((Object)new Float2ObjectAVLTreeMap(), layerBuilder)), noiseDepth, noiseScale);
    }

    public static class_6880<class_1959> registerUnderground(class_2378<class_1959> registry, boolean fullRegister) {
        class_6880.class_6883 holder = class_6880.class_6883.method_40234(registry, BiomeKeys.UNDERGROUND);
        class_1959 underground = BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.undergroundMobSpawning(), BiomeMaker.undergroundGen()).method_8747(0.7f).method_8727(0.0f).method_30972();
        if (fullRegister) {
            class_2378.method_39197(registry, BiomeKeys.UNDERGROUND, (Object)underground);
        }
        holder.method_40236(BiomeKeys.UNDERGROUND, (Object)underground);
        return holder;
    }

    private static Map<class_5321<class_1959>, class_1959> generateBiomes() {
        ImmutableMap.Builder biomes = ImmutableMap.builder();
        BiomeMaker.commonBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.mushroomBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.rareBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.swampBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.darkForestBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.snowRegionBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        BiomeMaker.highlandsBiomes((ImmutableMap.Builder<class_5321<class_1959>, class_1959>)biomes);
        return biomes.build();
    }

    private static void commonBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.twilightForestGen()).method_30972());
        biomes.put(BiomeKeys.DENSE_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).method_24395(21794), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseForestGen()).method_8747(0.7f).method_8727(0.8f).method_30972());
        biomes.put(BiomeKeys.FIREFLY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyForestParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.fireflyForestGen()).method_8747(0.5f).method_8727(1.0f).method_30972());
        biomes.put(BiomeKeys.CLEARING, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.clearingGen()).method_8747(0.8f).method_8727(0.4f).method_30972());
        biomes.put(BiomeKeys.OAK_SAVANNAH, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.oakSavannaGen()).method_8747(0.9f).method_8727(0.0f).method_30972());
    }

    private static void mushroomBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.mushroomForestGen()).method_8747(0.8f).method_8727(0.8f).method_30972());
        biomes.put(BiomeKeys.DENSE_MUSHROOM_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()), BiomeMaker.defaultMobSpawning(), BiomeMaker.denseMushroomForestGen()).method_8747(0.8f).method_8727(1.0f).method_30972());
    }

    private static void rareBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.SPOOKY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30822(12865827).method_30821(16745729).method_24395(12355671).method_30818(BiomeGrassColors.SPOOKY_FOREST), BiomeMaker.spookSpawning(), BiomeMaker.spookyForestGen()).method_8747(0.5f).method_8727(1.0f).method_30972());
        biomes.put(BiomeKeys.ENCHANTED_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.fireflyParticles(BiomeMaker.defaultAmbientBuilder()).method_30821(65535).method_30822(65535).method_30818(BiomeGrassColors.ENCHANTED_FOREST), BiomeMaker.defaultMobSpawning(), BiomeMaker.enchantedForestGen()).method_8735(class_1959.class_1963.field_9384).method_30972());
        biomes.put(BiomeKeys.STREAM, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(false)).method_8747(0.5f).method_8727(0.1f).method_30972());
        biomes.put(BiomeKeys.LAKE, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.streamsAndLakes(true)).method_8747(0.66f).method_8727(1.0f).method_30972());
    }

    private static void swampBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30820(8466).method_24392(16161).method_30822(6056270).method_30821(4809015).method_24395(9811295).method_30818(BiomeGrassColors.SWAMP), BiomeMaker.swampSpawning(), BiomeMaker.swampGen()).method_8747(0.8f).method_8727(0.9f).method_30972());
        biomes.put(BiomeKeys.FIRE_SWAMP, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.whiteAshParticles(BiomeMaker.defaultAmbientBuilder()).method_24395(2950912).method_24392(3672576).method_30822(5713443).method_30821(6563343).method_24395(0x6C2C2C), new class_5483.class_5496(), BiomeMaker.fireSwampGen()).method_8735(class_1959.class_1963.field_9384).method_8747(1.0f).method_8727(0.4f).method_30972());
    }

    private static void darkForestBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.DARK_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30820(0).method_24392(0).method_30822(4941652).method_30821(3890751).method_30818(BiomeGrassColors.DARK_FOREST), BiomeMaker.darkForestSpawning(), BiomeMaker.darkForestGen()).method_8747(0.7f).method_8727(0.8f).method_30972());
        biomes.put(BiomeKeys.DARK_FOREST_CENTER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30820(0).method_24392(4796416).method_30822(6714688).method_30821(16351774).method_30818(BiomeGrassColors.DARK_FOREST_CENTER), new class_5483.class_5496(), BiomeMaker.darkForestCenterGen()).method_30972());
    }

    private static void snowRegionBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.SNOWY_FOREST, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30820(0x808080).method_24392(0xFFFFFF).method_30821(0xFFFFFF).method_30822(0xFFFFFF), BiomeMaker.snowForestSpawning(), BiomeMaker.snowyForestGen()).method_8735(class_1959.class_1963.field_9383).method_8747(0.09f).method_8727(0.9f).method_30972());
        biomes.put(BiomeKeys.GLACIER, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder().method_30820(1248552).method_24392(3547016), BiomeMaker.penguinSpawning(), BiomeMaker.glacierGen()).method_8747(0.8f).method_8727(0.1f).method_8735(class_1959.class_1963.field_9383).method_30972());
    }

    private static void highlandsBiomes(ImmutableMap.Builder<class_5321<class_1959>, class_1959> biomes) {
        biomes.put(BiomeKeys.HIGHLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.defaultMobSpawning(), BiomeMaker.highlandsGen()).method_8747(0.4f).method_8727(0.7f).method_30972());
        biomes.put(BiomeKeys.THORNLANDS, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), new class_5483.class_5496(), BiomeMaker.thornlandsGen()).method_8747(0.3f).method_8727(0.2f).method_30972());
        biomes.put(BiomeKeys.FINAL_PLATEAU, (Object)BiomeMaker.biomeWithDefaults(BiomeMaker.defaultAmbientBuilder(), BiomeMaker.ravenSpawning(), BiomeMaker.plateauGen()).method_8747(1.0f).method_8727(0.2f).method_30972());
    }
}

