/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Random;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IResetUseOnDamage;
import net.blay09.mods.waystones.compat.Compat;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class WarpStoneItem
extends class_1792
implements IResetUseOnDamage {
    private final Random random = new Random();
    private static final BalmMenuProvider containerProvider = new BalmMenuProvider(){

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.waystones.waystone_selection");
        }

        public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
            return WaystoneSelectionMenu.createWaystoneSelection(i, playerEntity, WarpMode.WARP_STONE, null);
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.writeByte(WarpMode.WARP_STONE.ordinal());
        }
    };

    public WarpStoneItem(class_1792.class_1793 properties) {
        super(properties.method_7895(100));
    }

    public int method_7881(class_1799 itemStack) {
        return WaystonesConfig.getActive().warpStoneUseTime();
    }

    public class_1839 method_7853(class_1799 itemStack) {
        if (this.method_7881(itemStack) <= 0 || Compat.isVivecraftInstalled) {
            return class_1839.field_8952;
        }
        return class_1839.field_8953;
    }

    public void method_7852(class_1937 level, class_1309 entity, class_1799 itemStack, int remainingTicks) {
        if (level.field_9236) {
            int i;
            int duration = this.method_7881(itemStack);
            float progress = (float)(duration - remainingTicks) / (float)duration;
            boolean shouldMirror = entity.method_6058() == class_1268.field_5808 ^ entity.method_6068() == class_1306.field_6183;
            class_243 handOffset = new class_243(shouldMirror ? (double)0.3f : (double)-0.3f, 1.0, (double)0.52f);
            handOffset = handOffset.method_1024(-entity.method_36454() * ((float)Math.PI / 180));
            handOffset = handOffset.method_31033(entity.method_36455() * ((float)Math.PI / 180));
            int maxParticles = Math.max(4, (int)(progress * 48.0f));
            if (remainingTicks % 5 == 0) {
                for (i = 0; i < Math.min(4, maxParticles); ++i) {
                    level.method_8406((class_2394)class_2398.field_23190, entity.method_23317() + handOffset.field_1352 + (this.random.nextDouble() - 0.5) * 0.5, entity.method_23318() + handOffset.field_1351 + this.random.nextDouble(), entity.method_23321() + handOffset.field_1350 + (this.random.nextDouble() - 0.5) * 0.5, 0.0, (double)0.05f, 0.0);
                }
                if (progress >= 0.25f) {
                    for (i = 0; i < maxParticles; ++i) {
                        level.method_8406((class_2394)class_2398.field_22248, entity.method_23317() + (this.random.nextDouble() - 0.5) * 1.5, entity.method_23318() + this.random.nextDouble(), entity.method_23321() + (this.random.nextDouble() - 0.5) * 1.5, 0.0, this.random.nextDouble() * 0.5, 0.0);
                    }
                }
                if (progress >= 0.5f) {
                    for (i = 0; i < maxParticles; ++i) {
                        level.method_8406((class_2394)class_2398.field_23190, entity.method_23317() + (this.random.nextDouble() - 0.5) * 1.5, entity.method_23318() + this.random.nextDouble(), entity.method_23321() + (this.random.nextDouble() - 0.5) * 1.5, 0.0, this.random.nextDouble(), 0.0);
                    }
                }
                if (progress >= 0.75f) {
                    for (i = 0; i < maxParticles / 3; ++i) {
                        level.method_8406((class_2394)class_2398.field_11249, entity.method_23317() + (this.random.nextDouble() - 0.5) * 1.5, entity.method_23318() + 0.5 + this.random.nextDouble(), entity.method_23321() + (this.random.nextDouble() - 0.5) * 1.5, 0.0, this.random.nextDouble(), 0.0);
                    }
                }
            }
            if (remainingTicks == 1) {
                for (i = 0; i < maxParticles; ++i) {
                    level.method_8406((class_2394)class_2398.field_23190, entity.method_23317() + (this.random.nextDouble() - 0.5) * 1.5, entity.method_23318() + this.random.nextDouble() + 1.0, entity.method_23321() + (this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 0.0, this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 0.0);
                }
            }
        }
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 entity) {
        if (!world.field_9236 && entity instanceof class_3222) {
            Balm.getNetworking().openGui((class_1657)((class_3222)entity), (class_3908)containerProvider);
        }
        return stack;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_31549().field_7477) {
            PlayerWaystoneManager.setWarpStoneCooldownUntil(player, 0L);
        }
        if (PlayerWaystoneManager.canUseWarpStone(player, itemStack)) {
            if (!player.method_6115() && !world.field_9236) {
                world.method_43129(null, (class_1297)player, class_3417.field_14669, class_3419.field_15248, 0.1f, 2.0f);
            }
            if (this.method_7881(itemStack) <= 0 || Compat.isVivecraftInstalled) {
                this.method_7861(itemStack, world, (class_1309)player);
            } else {
                player.method_6019(hand);
            }
            return new class_1271(class_1269.field_5812, (Object)itemStack);
        }
        class_5250 chatComponent = class_2561.method_43471((String)"chat.waystones.warpstone_not_charged");
        chatComponent.method_27692(class_124.field_1061);
        player.method_7353((class_2561)chatComponent, true);
        return new class_1271(class_1269.field_5814, (Object)itemStack);
    }

    public boolean method_31567(class_1799 itemStack) {
        return this.method_31569(itemStack) < 13;
    }

    public int method_31569(class_1799 itemStack) {
        class_1657 player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return 13;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft(player);
        int maxCooldown = WaystonesConfig.getActive().warpStoneCooldown() * 1000;
        if (maxCooldown == 0) {
            return 13;
        }
        return Math.round(13.0f - (float)timeLeft * 13.0f / (float)maxCooldown);
    }

    public boolean method_7886(class_1799 itemStack) {
        class_1657 player = Balm.getProxy().getClientPlayer();
        return player != null ? PlayerWaystoneManager.canUseWarpStone(player, itemStack) || super.method_7886(itemStack) : super.method_7886(itemStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> list, class_1836 flag) {
        class_1657 player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        long timeLeft = PlayerWaystoneManager.getWarpStoneCooldownLeft(player);
        int secondsLeft = (int)(timeLeft / 1000L);
        if (secondsLeft > 0) {
            class_5250 secondsLeftText = class_2561.method_43469((String)"tooltip.waystones.cooldown_left", (Object[])new Object[]{secondsLeft});
            secondsLeftText.method_27692(class_124.field_1065);
            list.add((class_2561)secondsLeftText);
        }
    }
}

