/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.config;

import com.minecraftserverzone.weaponmaster.config.ModConfigProvider;
import com.minecraftserverzone.weaponmaster.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static String BLACKLIST;
    public static String WHITELIST;
    public static boolean SLOT1;
    public static boolean SLOT2;
    public static boolean SLOT3;
    public static boolean SLOT4;
    public static boolean SLOT5;
    public static boolean SLOT6;
    public static boolean SLOT7;
    public static boolean SLOT8;
    public static boolean SLOT9;
    public static boolean SHIELD;
    public static boolean BANNER;
    public static int[] positions;
    public static int[] rotations;
    public static String attachment;
    public static String slotMover;
    public static boolean CAN_HIDE_ITEMS;
    public static boolean CAN_CHANGE_POS_AND_ROT;
    public static boolean CAN_CHANGE_ATTACHMENT;
    public static boolean FORCE_WHITELIST;
    public static boolean FORCE_BLACKLIST;

    public static void changeConfig() throws IOException {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            String filename = "weaponmasterconfig.properties";
            FileWriter fw = new FileWriter(path + "\\" + filename, false);
            PrintWriter pw = new PrintWriter((Writer)fw, Boolean.parseBoolean("UTF-8"));
            pw.println("weaponmasterconfig.slot.1=" + SLOT1 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.2=" + SLOT2 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.3=" + SLOT3 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.4=" + SLOT4 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.5=" + SLOT5 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.6=" + SLOT6 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.7=" + SLOT7 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.8=" + SLOT8 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.9=" + SLOT9 + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.shield=" + SHIELD + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.banner=" + BANNER + " #boolean | default: true");
            for (int i = 0; i < 11; ++i) {
                pw.println("weaponmasterconfig.posx" + i * 3 + "=" + positions[i * 3] + " #int | default: 0");
                pw.println("weaponmasterconfig.posy" + (i * 3 + 1) + "=" + positions[i * 3 + 1] + " #int | default: 0");
                pw.println("weaponmasterconfig.posz" + (i * 3 + 2) + "=" + positions[i * 3 + 2] + " #int | default: 0");
                pw.println("weaponmasterconfig.rotx" + i * 3 + "=" + rotations[i * 3] + " #int | default: 0");
                pw.println("weaponmasterconfig.roty" + (i * 3 + 1) + "=" + rotations[i * 3 + 1] + " #int | default: 0");
                pw.println("weaponmasterconfig.rotz" + (i * 3 + 2) + "=" + rotations[i * 3 + 2] + " #int | default: 0");
            }
            pw.println("weaponmasterconfig.attachment=" + attachment + " #String | default: 1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head");
            pw.println("weaponmasterconfig.slotmover=" + slotMover + " #String | default: empty");
            pw.println("weaponmasterconfig.blacklist=" + BLACKLIST + " #String | default: empty");
            pw.println("weaponmasterconfig.whitelist=" + WHITELIST + " #String | default: empty,totem_of_undying");
            pw.println("weaponmasterconfig.slot.can_hide_items=" + CAN_HIDE_ITEMS + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.can_change_pos_and_rot=" + CAN_CHANGE_POS_AND_ROT + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.can_change_attachment=" + CAN_CHANGE_ATTACHMENT + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.force_whitelist=" + FORCE_WHITELIST + " #boolean | default: true");
            pw.println("weaponmasterconfig.slot.blacklist_whitelist=" + FORCE_BLACKLIST + " #boolean | default: true");
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("weaponmasterconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.1", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.2", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.3", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.4", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.5", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.6", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.7", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.8", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.9", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.shield", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.banner", (Object)true), "boolean");
        ModConfigs.initPositionsRotationsKeyValuePair(0, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(1, 35, 35, 0, 0, 0, 90);
        ModConfigs.initPositionsRotationsKeyValuePair(2, 1, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(3, 31, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(4, 1, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsKeyValuePair(5, 31, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsKeyValuePair(6, -13, 34, -1, 0, 0, -35);
        ModConfigs.initPositionsRotationsKeyValuePair(7, 25, 20, 12, 0, 0, 45);
        ModConfigs.initPositionsRotationsKeyValuePair(8, 1, -14, 20, 0, -90, 20);
        ModConfigs.initPositionsRotationsKeyValuePair(9, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsKeyValuePair(10, 0, 0, 0, 0, 0, 0);
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.attachment", (Object)"1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head"), "String");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slotmover", (Object)"none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-"), "String");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.can_hide_items", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.can_change_pos_and_rot", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.can_change_attachment", (Object)true), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.force_whitelist", (Object)false), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.slot.blacklist_whitelist", (Object)false), "boolean");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.blacklist", (Object)"empty"), "String");
        configs.addKeyValuePair(new Pair((Object)"weaponmasterconfig.whitelist", (Object)"empty,totem_of_undying"), "String");
    }

    private static void assignConfigs() {
        SLOT1 = CONFIG.getOrDefault("weaponmasterconfig.slot.1", true);
        SLOT2 = CONFIG.getOrDefault("weaponmasterconfig.slot.2", true);
        SLOT3 = CONFIG.getOrDefault("weaponmasterconfig.slot.3", true);
        SLOT4 = CONFIG.getOrDefault("weaponmasterconfig.slot.4", true);
        SLOT5 = CONFIG.getOrDefault("weaponmasterconfig.slot.5", true);
        SLOT6 = CONFIG.getOrDefault("weaponmasterconfig.slot.6", true);
        SLOT7 = CONFIG.getOrDefault("weaponmasterconfig.slot.7", true);
        SLOT8 = CONFIG.getOrDefault("weaponmasterconfig.slot.8", true);
        SLOT9 = CONFIG.getOrDefault("weaponmasterconfig.slot.9", true);
        SHIELD = CONFIG.getOrDefault("weaponmasterconfig.slot.shield", true);
        BANNER = CONFIG.getOrDefault("weaponmasterconfig.slot.banner", true);
        ModConfigs.initPositionsRotationsGetOrDefault(0, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(1, 35, 35, 0, 0, 0, 90);
        ModConfigs.initPositionsRotationsGetOrDefault(2, 1, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(3, 31, -20, 12, 0, -90, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(4, 1, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsGetOrDefault(5, 31, -24, 0, 0, -90, -30);
        ModConfigs.initPositionsRotationsGetOrDefault(6, -13, 34, -4, 0, 0, -35);
        ModConfigs.initPositionsRotationsGetOrDefault(7, 25, 20, 12, 0, 0, 45);
        ModConfigs.initPositionsRotationsGetOrDefault(8, 1, -14, 20, 0, -90, 20);
        ModConfigs.initPositionsRotationsGetOrDefault(9, 0, 0, 0, 0, 0, 0);
        ModConfigs.initPositionsRotationsGetOrDefault(10, 0, 0, 0, 0, 0, 0);
        attachment = CONFIG.getOrDefault("weaponmasterconfig.attachment", "1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head");
        slotMover = CONFIG.getOrDefault("weaponmasterconfig.slotmover", "none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-");
        CAN_HIDE_ITEMS = CONFIG.getOrDefault("weaponmasterconfig.slot.can_hide_items", true);
        CAN_CHANGE_POS_AND_ROT = CONFIG.getOrDefault("weaponmasterconfig.slot.can_change_pos_and_rot", true);
        CAN_CHANGE_ATTACHMENT = CONFIG.getOrDefault("weaponmasterconfig.slot.can_change_attachment", true);
        FORCE_WHITELIST = CONFIG.getOrDefault("weaponmasterconfig.slot.force_whitelist", false);
        FORCE_BLACKLIST = CONFIG.getOrDefault("weaponmasterconfig.slot.blacklist_whitelist", false);
        BLACKLIST = CONFIG.getOrDefault("weaponmasterconfig.blacklist", "empty");
        WHITELIST = CONFIG.getOrDefault("weaponmasterconfig.whitelist", "empty,totem_of_undying");
        System.out.println("All " + configs.getConfigsList().size() + " have been set properly");
    }

    public static void initPositionsRotationsGetOrDefault(int slot, int posx, int posy, int posz, int rotx, int roty, int rotz) {
        ModConfigs.positions[slot * 3] = CONFIG.getOrDefault("weaponmasterconfig.posx" + slot * 3, posx);
        ModConfigs.positions[slot * 3 + 1] = CONFIG.getOrDefault("weaponmasterconfig.posy" + (slot * 3 + 1), posy);
        ModConfigs.positions[slot * 3 + 2] = CONFIG.getOrDefault("weaponmasterconfig.posz" + (slot * 3 + 2), posz);
        ModConfigs.rotations[slot * 3] = CONFIG.getOrDefault("weaponmasterconfig.rotx" + slot * 3, rotx);
        ModConfigs.rotations[slot * 3 + 1] = CONFIG.getOrDefault("weaponmasterconfig.roty" + (slot * 3 + 1), roty);
        ModConfigs.rotations[slot * 3 + 2] = CONFIG.getOrDefault("weaponmasterconfig.rotz" + (slot * 3 + 2), rotz);
    }

    public static void initPositionsRotationsKeyValuePair(int slot, int posx, int posy, int posz, int rotx, int roty, int rotz) {
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.posx" + slot * 3), (Object)posx), "int");
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.posy" + (slot * 3 + 1)), (Object)posy), "int");
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.posz" + (slot * 3 + 2)), (Object)posz), "int");
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.rotx" + slot * 3), (Object)rotx), "int");
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.roty" + (slot * 3 + 1)), (Object)roty), "int");
        configs.addKeyValuePair(new Pair((Object)("weaponmasterconfig.rotz" + (slot * 3 + 2)), (Object)rotz), "int");
    }

    static {
        BLACKLIST = "empty";
        WHITELIST = "empty,totem_of_undying";
        SLOT1 = true;
        SLOT2 = true;
        SLOT3 = true;
        SLOT4 = true;
        SLOT5 = true;
        SLOT6 = true;
        SLOT7 = true;
        SLOT8 = true;
        SLOT9 = true;
        SHIELD = true;
        BANNER = true;
        positions = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        rotations = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        attachment = "1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head";
        slotMover = "none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-";
        CAN_HIDE_ITEMS = true;
        CAN_CHANGE_POS_AND_ROT = true;
        CAN_CHANGE_ATTACHMENT = true;
        FORCE_WHITELIST = false;
        FORCE_BLACKLIST = false;
    }
}

