/*
 * Decompiled with CFR 0.152.
 */
package io.github.shaksternano.wmitaf.client.util.fabric;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class ModNameUtil {
    private static final String EXTRA_ALCHEMY_BREAKABLE_POTION_ID = "extraalchemy:breakable_potion";
    private static final String PATCHOULI_BOOK_ID = "patchouli:guide_book";
    private static final String PATCHOULI_BOOK_TAG = "patchouli:book";

    public static Optional<String> getActualModName(class_1799 stack) {
        if (ModNameUtil.modNameNeedsToBeChanged(stack)) {
            return ModNameUtil.getActualModId(stack).map(modId -> ModNameUtil.getModNameFromId(modId).orElseGet(() -> StringUtils.capitalize((String)modId)));
        }
        return Optional.empty();
    }

    public static Optional<String> getActualModId(class_1799 stack) {
        if (ModNameUtil.modNameNeedsToBeChanged(stack)) {
            return ModNameUtil.getIdentifierFromStackData(stack).map(class_2960::method_12836);
        }
        return Optional.empty();
    }

    public static boolean modNameNeedsToBeChanged(class_1799 stack) {
        return stack.method_31574(class_1802.field_8598) || ModNameUtil.hasStatusEffects(stack) || ModNameUtil.hasId(stack.method_7909(), PATCHOULI_BOOK_ID);
    }

    private static Optional<class_2960> getIdentifierFromStackData(class_1799 stack) {
        Optional<class_2960> identifierOptional = Optional.empty();
        if (stack.method_31574(class_1802.field_8598)) {
            identifierOptional = ModNameUtil.getFirstEnchantmentId(stack);
        } else if (ModNameUtil.hasStatusEffects(stack)) {
            identifierOptional = ModNameUtil.getFirstEffectId(stack);
        } else if (ModNameUtil.hasId(stack.method_7909(), PATCHOULI_BOOK_ID)) {
            identifierOptional = ModNameUtil.getPatchouliBookId(stack);
        }
        return identifierOptional;
    }

    public static Optional<String> getModNameFromId(String namespace) {
        return FabricLoader.getInstance().getModContainer(namespace).map(container -> container.getMetadata().getName());
    }

    private static Optional<class_2960> getFirstEnchantmentId(class_1799 stack) {
        Set enchantments = class_1890.method_8222((class_1799)stack).keySet();
        for (class_1887 enchantment : enchantments) {
            class_2960 enchantmentId = class_1890.method_37423((class_1887)enchantment);
            if (enchantmentId == null) continue;
            return Optional.of(enchantmentId);
        }
        return Optional.empty();
    }

    private static Optional<class_2960> getFirstEffectId(class_1799 stack) {
        List effectInstances = class_1844.method_8067((class_1799)stack);
        for (class_1293 effectInstance : effectInstances) {
            class_1291 effect = effectInstance.method_5579();
            class_2960 effectId = class_2378.field_11159.method_10221((Object)effect);
            if (effectId == null) continue;
            if (effectId.method_12836().equals("minecraft")) {
                return Optional.of(class_2378.field_11142.method_10221((Object)stack.method_7909()));
            }
            return Optional.of(effectId);
        }
        return Optional.empty();
    }

    private static Optional<class_2960> getPatchouliBookId(class_1799 stack) {
        String bookId;
        if (stack.method_7985() && !(bookId = stack.method_7969().method_10558(PATCHOULI_BOOK_TAG)).equals("")) {
            return Optional.of(new class_2960(bookId));
        }
        return Optional.empty();
    }

    private static boolean hasStatusEffects(class_1799 stack) {
        return stack.method_31574(class_1802.field_8574) || stack.method_31574(class_1802.field_8436) || stack.method_31574(class_1802.field_8150) || stack.method_31574(class_1802.field_8087) || ModNameUtil.hasId(stack.method_7909(), EXTRA_ALCHEMY_BREAKABLE_POTION_ID);
    }

    private static boolean hasId(class_1792 item, String id) {
        return class_2378.field_11142.method_10221((Object)item).toString().equals(id);
    }
}

