/*
 * Decompiled with CFR 0.152.
 */
package io.github.shaksternano.wmitaf.client.util.fabric;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class PlayerMessages {
    private static final Map<String, String> PLAYER_MESSAGES = PlayerMessages.createPlayerMessagesMap();

    public static Optional<String> getMessage(String uuid) {
        return Optional.ofNullable(PLAYER_MESSAGES.get(uuid));
    }

    private static Map<String, String> createPlayerMessagesMap() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        PlayerMessages.addToBuilder(builder, "The Inept Brits", "65972a6e-02b9-4701-96a7-0f76c08c2e5d", "64e44de7-a634-4dff-86a5-0e607c7f1f19", "eea7537e-0219-46b4-90e1-fcaaa1221fe0", "a0d4d6e5-a9f6-4e51-8005-30ff2ec88833", "391cd817-d95b-4fa0-b044-513641feec3a", "9ecbd174-f1db-4c81-ab1f-05f49d3b9e76", "4ccc4e71-9259-44b5-9641-1941ad0bf37b");
        PlayerMessages.addToBuilder(builder, "fortnite battle pass", "0ebe52a9-7c23-4a15-ab31-aaa39c1bab2c", "1f2ee0cc-3011-4261-bc5c-50382288cab2", "4db72998-a62e-4be5-b6de-02ed1dd82847");
        PlayerMessages.addToBuilder(builder, "YOU SHOULD DOWNLOAD HAEMA... NOW!", "9b035372-0d8d-4513-8bd5-9808d7f4a9b3");
        PlayerMessages.addToBuilder(builder, "YOU SHOULD OPEN revolt.chat... NOW!", "438695b0-950e-4859-a119-49162ef58c25");
        PlayerMessages.addToBuilder(builder, "YOU SHOULD DOWNLOAD BALLS... NOW!", "dbafc5f2-8dfc-43a9-9f2f-71c81e6bf6df", "605ea77d-26cf-4401-86e4-7c6049d61146");
        PlayerMessages.addToBuilder(builder, "deez squared", "941b37c7-7cc7-40a6-9613-bb3ca43bf70e");
        PlayerMessages.addToBuilder(builder, "among us", "97dca97d-8ca1-4ddb-8b98-47e1922f37f1");
        PlayerMessages.addToBuilder(builder, "Segmentation fault (core dumped)", "1896f801-366d-47bc-b1e7-4ff731122c1d");
        PlayerMessages.addToBuilder(builder, "YOU SHOULD OPEN lightspeed.tv... NOW!", "ec99e171-40f1-47e5-a15c-bee4b846c932");
        return builder.buildOrThrow();
    }

    @SafeVarargs
    private static <K, V> void addToBuilder(ImmutableMap.Builder<K, V> builder, V value, K ... keys) {
        if (keys.length == 0) {
            throw new IllegalArgumentException("keys cannot be empty!");
        }
        for (K key : keys) {
            builder.put(key, value);
        }
    }
}

