/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.List;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IApiService;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

@ApiSide.ClientOnly
public class ItemListComponent
implements ITooltipComponent.HorizontalGrowing {
    private final List<class_1799> items;
    private final int maxHeight;
    private int gridWidth;
    private int gridHeight;
    private int maxIndex;

    public ItemListComponent(List<class_1799> items) {
        this(items, 3);
    }

    public ItemListComponent(List<class_1799> items, int maxHeight) {
        this.items = items;
        this.maxHeight = maxHeight;
    }

    @Override
    public int getMinimalWidth() {
        return Math.min(this.items.size(), 9) * 18;
    }

    @Override
    public void setGrownWidth(int grownWidth) {
        this.gridWidth = grownWidth / 18;
        this.gridHeight = this.items.isEmpty() ? 0 : Math.min(class_3532.method_38788((int)this.items.size(), (int)this.gridWidth), this.maxHeight);
        this.maxIndex = this.gridWidth * this.gridHeight - 1;
    }

    @Override
    public int getHeight() {
        return this.gridHeight * 18;
    }

    @Override
    public void render(class_4587 matrices, int x, int y, float delta) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 item = this.items.get(i);
            int ix = x + 18 * (i % this.gridWidth);
            int iy = y + 18 * (i / this.gridWidth);
            IApiService.INSTANCE.renderItem(ix, iy, item);
            if (i == this.maxIndex) break;
        }
    }
}

