/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.mcless.config.ConfigIo;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import org.jetbrains.annotations.Nullable;

public class JsonConfig<T>
implements IJsonConfig<T> {
    private static final Log LOG = Log.create();
    private static final ToIntFunction DEFAULT_VERSION_GETTER = t -> 0;
    private static final ObjIntConsumer DEFAULT_VERSION_SETTER = (t, v) -> {};
    private static final Gson DEFAULT_GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss");
    private final Path path;
    private final ConfigIo<T> io;
    private final CachedSupplier<T> getter;

    JsonConfig(Path path, Type clazz, Supplier<T> factory, Gson gson, int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
        this.path = path.toAbsolutePath();
        this.io = new ConfigIo<T>(LOG::warn, LOG::error, gson, clazz, factory, currentVersion, versionGetter, versionSetter);
        this.getter = new CachedSupplier<Object>(() -> this.io.read(this.path));
    }

    private void write(T t, Path path, boolean invalidate) {
        if (this.io.write(path, t) && invalidate) {
            this.invalidate();
        }
    }

    @Override
    public boolean isFileExists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    public void save() {
        this.write(this.get(), false);
    }

    @Override
    public void write(T t, boolean invalidate) {
        this.write(t, this.path, invalidate);
    }

    @Override
    public void invalidate() {
        this.getter.invalidate();
    }

    @Override
    public void backup(@Nullable String cause) {
        if (this.isFileExists()) {
            Path backupPath = Paths.get(this.path + "_" + DATE_FORMAT.format(new Date()), new String[0]);
            String msg = "Config " + this.path.getFileName() + " is getting backup to " + backupPath;
            if (cause != null) {
                msg = msg + " because of " + cause;
            }
            LOG.info(msg);
            this.write(this.get(), backupPath, true);
        }
    }

    public static class Builder<T>
    implements IJsonConfig.Builder0<T>,
    IJsonConfig.Builder1<T> {
        final Type type;
        Path path;
        Gson gson;
        int currentVersion;
        ToIntFunction<T> versionGetter;
        ObjIntConsumer<T> versionSetter;
        Supplier<T> factory;

        public Builder(Type type) {
            this.type = type;
            this.gson = DEFAULT_GSON;
            this.currentVersion = 0;
            this.versionGetter = DEFAULT_VERSION_GETTER;
            this.versionSetter = DEFAULT_VERSION_SETTER;
            if (type instanceof Class) {
                Class clazz = (Class)type;
                this.factory = () -> {
                    try {
                        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create new config instance", e);
                    }
                };
            }
        }

        @Override
        public IJsonConfig.Builder1<T> file(File file) {
            this.path = file.toPath();
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(Path path) {
            this.path = path;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> file(String fileName) {
            this.path = Waila.CONFIG_DIR.resolve(fileName + (fileName.endsWith(".json") ? "" : ".json"));
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> version(int currentVersion, ToIntFunction<T> versionGetter, ObjIntConsumer<T> versionSetter) {
            this.currentVersion = currentVersion;
            this.versionGetter = versionGetter;
            this.versionSetter = versionSetter;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> factory(Supplier<T> factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public IJsonConfig.Builder1<T> gson(Gson gson) {
            this.gson = gson;
            return this;
        }

        @Override
        public IJsonConfig<T> build() {
            Preconditions.checkNotNull(this.factory, (Object)"Default value factory must not be null");
            return new JsonConfig<T>(this.path, this.type, this.factory, this.gson, this.currentVersion, this.versionGetter, this.versionSetter);
        }
    }
}

