/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud.theme;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.gui.hud.theme.BuiltinThemeLoader;
import mcp.mobius.waila.gui.hud.theme.ThemeAccessor;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_2960;

public final class ThemeDefinition<T extends ITheme> {
    private static Map<class_2960, ThemeDefinition<?>> all;
    public final class_2960 id;
    public final ThemeType<T> type;
    public final boolean builtin;
    public final T instance;
    private boolean initialized = false;

    public ThemeDefinition(class_2960 id, ThemeType<T> type, boolean builtin, Map<String, Object> attr) {
        this.id = id;
        this.type = type;
        this.builtin = builtin;
        this.instance = type.create(attr);
    }

    public static Map<class_2960, ThemeDefinition<?>> getAll() {
        if (all == null) {
            all = new HashMap(BuiltinThemeLoader.THEMES);
            all.putAll(Waila.CONFIG.get().getOverlay().getColor().getCustomThemes());
        }
        return all;
    }

    public static void resetAll() {
        all = null;
    }

    public T getInitializedInstance() {
        if (!this.initialized) {
            this.initialized = true;
            this.instance.processProperties(ThemeAccessor.INSTANCE);
        }
        return this.instance;
    }

    public static class Adapter
    implements JsonSerializer<ThemeDefinition<?>>,
    JsonDeserializer<ThemeDefinition<?>> {
        public static ThemeDefinition<?> deserialize(class_2960 id, JsonElement json, boolean builtin) {
            JsonObject object = json.getAsJsonObject();
            class_2960 typeId = object.has("type") ? new class_2960(object.get("type").getAsString()) : WailaConstants.THEME_TYPE_GRADIENT;
            ThemeType type = (ThemeType)Registrar.get().themeTypes.get((Object)typeId);
            HashMap<String, Object> values = new HashMap<String, Object>();
            type.properties.forEach((key, prop) -> {
                if (object.has(key)) {
                    Class propType = prop.type;
                    JsonElement value = object.get(key);
                    if (propType == Integer.TYPE) {
                        values.put((String)key, value.getAsInt());
                        return;
                    } else if (propType == Boolean.TYPE) {
                        values.put((String)key, value.getAsBoolean());
                        return;
                    } else if (propType == Double.TYPE) {
                        values.put((String)key, value.getAsDouble());
                        return;
                    } else if (propType == String.class) {
                        values.put((String)key, value.getAsString());
                        return;
                    } else {
                        if (!propType.isEnum()) throw new IllegalArgumentException("Invalid property type " + propType.getSimpleName());
                        values.put((String)key, Enum.valueOf((Class)TypeUtil.uncheckedCast(propType), value.getAsString()));
                    }
                    return;
                } else {
                    values.put((String)key, Preconditions.checkNotNull(prop.defaultValue, (Object)("Property " + key + " is missing")));
                }
            });
            return new ThemeDefinition(id, type, builtin, values);
        }

        public ThemeDefinition<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            class_2960 id = new class_2960(object.get("id").getAsString());
            return Adapter.deserialize(id, json, false);
        }

        public JsonElement serialize(ThemeDefinition<?> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("id", src.id.toString());
            object.addProperty("type", ((class_2960)Registrar.get().themeTypes.inverse().get(src.type)).toString());
            src.type.properties.forEach((key, prop) -> {
                Class propType = prop.type;
                Object propValue = prop.get(src.instance);
                if (propType == Integer.TYPE) {
                    object.addProperty(key, (Number)TypeUtil.uncheckedCast(propValue));
                } else if (propType == Boolean.TYPE) {
                    object.addProperty(key, (Boolean)TypeUtil.uncheckedCast(propValue));
                } else if (propType == Double.TYPE) {
                    object.addProperty(key, (Number)TypeUtil.uncheckedCast(propValue));
                } else if (propType == String.class) {
                    object.addProperty(key, (String)TypeUtil.uncheckedCast(propValue));
                } else if (propType.isEnum()) {
                    object.addProperty(key, ((Enum)TypeUtil.uncheckedCast(propValue)).name());
                } else {
                    throw new IllegalArgumentException("Invalid property type " + propType.getSimpleName());
                }
            });
            return object;
        }
    }
}

