/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_2960;

public class PluginInfo
implements IPluginInfo {
    private static final Log LOG = Log.create();
    private static final class_2960 CORE = Waila.id("core");
    private static final IJsonConfig<Map<class_2960, Boolean>> TOGGLE = IJsonConfig.of(new TypeToken<Map<class_2960, Boolean>>(){}).file("waila/plugin_toggle").factory(LinkedHashMap::new).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create()).build();
    private static final Map<class_2960, IPluginInfo> PLUGIN_ID_TO_PLUGIN_INFO = new LinkedHashMap<class_2960, IPluginInfo>();
    private static final CachedSupplier<Map<String, List<IPluginInfo>>> MOD_ID_TO_PLUGIN_INFOS = new CachedSupplier<Map>(() -> PLUGIN_ID_TO_PLUGIN_INFO.values().stream().collect(Collectors.groupingBy(p -> p.getModInfo().getId())));
    private final ModInfo modInfo;
    private final class_2960 pluginId;
    private final IPluginInfo.Side side;
    private final IWailaPlugin initializer;
    private final List<String> requiredModIds;
    private final boolean legacy;
    private boolean disabledOnServer;

    private PluginInfo(ModInfo modInfo, class_2960 pluginId, IPluginInfo.Side side, IWailaPlugin initializer, List<String> requiredModIds, boolean legacy) {
        this.modInfo = modInfo;
        this.pluginId = pluginId;
        this.side = side;
        this.initializer = initializer;
        this.requiredModIds = requiredModIds;
        this.legacy = legacy;
    }

    public static void register(String modId, String pluginIdStr, IPluginInfo.Side side, String initializerStr, List<String> required, boolean defaultEnabled, boolean legacy) {
        try {
            class_2960 rl = new class_2960(pluginIdStr);
            if (PLUGIN_ID_TO_PLUGIN_INFO.containsKey(rl)) {
                LOG.error("Duplicate plugin id " + rl);
                return;
            }
            if (rl.method_12836().equals("minecraft")) {
                LOG.warn("Plugin " + initializerStr + " is using the default namespace " + rl);
            }
            IWailaPlugin initializer = (IWailaPlugin)Class.forName(initializerStr).getConstructor(new Class[0]).newInstance(new Object[0]);
            PLUGIN_ID_TO_PLUGIN_INFO.put(rl, new PluginInfo(ModInfo.get(modId), rl, side, initializer, required, legacy));
            TOGGLE.get().putIfAbsent(rl, defaultEnabled);
        }
        catch (Throwable t) {
            LOG.error("Error creating instance of plugin " + pluginIdStr, t);
        }
    }

    public static IPluginInfo get(class_2960 pluginId) {
        return PLUGIN_ID_TO_PLUGIN_INFO.get(pluginId);
    }

    public static Collection<IPluginInfo> getAllFromMod(String modId) {
        return MOD_ID_TO_PLUGIN_INFOS.get().get(modId);
    }

    public static Collection<IPluginInfo> getAll() {
        return PLUGIN_ID_TO_PLUGIN_INFO.values();
    }

    @Override
    public IModInfo getModInfo() {
        return this.modInfo;
    }

    @Override
    public class_2960 getPluginId() {
        return this.pluginId;
    }

    @Override
    public IPluginInfo.Side getSide() {
        return this.side;
    }

    @Override
    public IWailaPlugin getInitializer() {
        return this.initializer;
    }

    @Override
    public List<String> getRequiredModIds() {
        return this.requiredModIds;
    }

    @Override
    public boolean isEnabled() {
        if (this.disabledOnServer) {
            return false;
        }
        return this.isLocked() || TOGGLE.get().get(this.getPluginId()) != false;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public boolean isLocked() {
        return this.pluginId.equals((Object)CORE);
    }

    public boolean isDisabledOnServer() {
        return this.disabledOnServer;
    }

    public void setDisabledOnServer(boolean disabledOnServer) {
        this.disabledOnServer = disabledOnServer;
    }

    public void setEnabled(boolean enabled) {
        TOGGLE.get().put(this.getPluginId(), enabled);
    }

    public static void refresh() {
        TOGGLE.invalidate();
        PluginInfo.getAll().forEach(it -> {
            ((PluginInfo)it).disabledOnServer = false;
        });
    }

    public static void saveToggleConfig() {
        TOGGLE.save();
    }
}

