/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.__internal__.Internals;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.ICommonService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public abstract class PluginLoader {
    public static final PluginLoader INSTANCE = Internals.loadService(PluginLoader.class);
    private static final Log LOG = Log.create();
    protected static final String[] PLUGIN_JSON_FILES = new String[]{"waila_plugins.json", "wthit_plugins.json"};
    protected static final String KEY_INITIALIZER = "initializer";
    protected static final String KEY_SIDE = "side";
    protected static final String KEY_REQUIRED = "required";
    protected static final String KEY_DEFAULT_ENABLED = "defaultEnabled";
    protected static final Map<String, IPluginInfo.Side> SIDES = Map.of("client", IPluginInfo.Side.CLIENT, "server", IPluginInfo.Side.SERVER, "both", IPluginInfo.Side.BOTH, "*", IPluginInfo.Side.BOTH);
    private boolean gathered = false;

    public static void reloadServerPlugins(MinecraftServer server) {
        PluginInfo.refresh();
        INSTANCE.loadPlugins();
        server.method_3760().method_14571().forEach(player -> {
            PacketSender sender = PacketSender.s2c((class_3222)player);
            if (!sender.canSend(Packets.PLUGIN)) {
                return;
            }
            if (!server.method_19466(player.method_7334())) {
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_34062(PluginInfo.getAll().stream().filter(it -> !it.isEnabled()).map(IPluginInfo::getPluginId).toList(), class_2540::method_10812);
                sender.send(Packets.PLUGIN, buf);
            }
            Packets.sendConfig(sender);
        });
    }

    public static void reloadClientPlugins() {
        INSTANCE.loadPlugins();
        if (class_310.method_1551().method_1562() != null && PacketSender.c2s().canSend(Packets.CONFIG_SYNC_REQ)) {
            PacketSender.c2s().send(Packets.CONFIG_SYNC_REQ, new class_2540(Unpooled.buffer()));
        }
    }

    protected abstract void gatherPlugins();

    protected void readPluginsJson(String modId, Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            block7: for (String pluginId : object.keySet()) {
                IPluginInfo.Side side;
                JsonObject plugin = object.getAsJsonObject(pluginId);
                String initializer = plugin.getAsJsonPrimitive(KEY_INITIALIZER).getAsString();
                IPluginInfo.Side side2 = side = plugin.has(KEY_SIDE) ? Objects.requireNonNull(SIDES.get(plugin.get(KEY_SIDE).getAsString()), () -> PluginLoader.readError(path) + ", invalid side, available: " + SIDES.keySet().stream().collect(Collectors.joining(", ", "[", "]"))) : IPluginInfo.Side.BOTH;
                if (!side.matches(ICommonService.INSTANCE.getSide())) continue;
                ArrayList<String> required = new ArrayList<String>();
                if (plugin.has(KEY_REQUIRED)) {
                    JsonArray array = plugin.getAsJsonArray(KEY_REQUIRED);
                    for (JsonElement element : array) {
                        String requiredModId = element.getAsString();
                        if (!ModInfo.get(requiredModId).isPresent()) continue block7;
                        required.add(requiredModId);
                    }
                }
                boolean defaultEnabled = !plugin.has(KEY_DEFAULT_ENABLED) || plugin.get(KEY_DEFAULT_ENABLED).getAsBoolean();
                PluginInfo.register(modId, pluginId, side, initializer, required, defaultEnabled, false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(PluginLoader.readError(path), e);
        }
    }

    public final void loadPlugins() {
        Registrar.destroy();
        if (!this.gathered) {
            this.gathered = true;
            this.gatherPlugins();
        }
        PluginInfo.saveToggleConfig();
        IPluginInfo extraPlugin = null;
        ArrayList<String> legacyPlugins = new ArrayList<String>();
        for (IPluginInfo info : PluginInfo.getAll()) {
            if (info.getPluginId().equals((Object)Waila.id("extra"))) {
                extraPlugin = info;
            } else {
                this.initialize(info);
            }
            if (!((PluginInfo)info).isLegacy()) continue;
            legacyPlugins.add(info.getPluginId().toString());
        }
        if (extraPlugin != null) {
            this.initialize(extraPlugin);
        }
        if (Waila.DEV && !legacyPlugins.isEmpty()) {
            LOG.warn("Found plugins registered via legacy platform-dependant method:");
            LOG.warn(legacyPlugins.stream().collect(Collectors.joining(", ", "[", "]")));
            LOG.warn("The method will be removed on Minecraft 1.21");
        }
        Registrar.get().lock();
        PluginConfig.reload();
    }

    private void initialize(IPluginInfo info) {
        Registrar.get().attach(info);
        if (info.isEnabled()) {
            LOG.info("Initializing plugin {} at {}", info.getPluginId(), info.getInitializer().getClass().getCanonicalName());
        } else {
            LOG.info("Skipping disabled plugin {}", info.getPluginId());
        }
        info.getInitializer().register(Registrar.get());
        Registrar.get().attach(null);
    }

    private static String readError(Path path) {
        return "Failed to read [" + path + "]";
    }
}

