/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_124;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_6025;

public enum PetOwnerProvider implements IEntityComponentProvider
{
    INSTANCE;

    static final Supplier<HttpClient> HTTP;
    static final Map<UUID, Future<class_2561>> NAMES;
    static final class_2561 UNKNOWN;
    static final class_2561 LOADING;
    static final class_2561 KEY;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PET_OWNER)) {
            Object entity = accessor.getEntity();
            UUID uuid = null;
            if (entity instanceof class_1496) {
                class_1496 horse = (class_1496)entity;
                uuid = horse.method_6768();
            } else if (entity instanceof class_6025) {
                class_6025 ownableEntity = (class_6025)entity;
                uuid = ownableEntity.method_6139();
            }
            if (uuid == null) {
                return;
            }
            class_2561 name = LOADING;
            if (NAMES.containsKey(uuid)) {
                Future<class_2561> future = NAMES.get(uuid);
                if (future.isDone()) {
                    name = (class_2561)Futures.getUnchecked(future);
                }
            } else {
                NAMES.put(uuid, this.requestOwner(uuid));
            }
            if (name != UNKNOWN && name != LOADING || !config.getBoolean(Options.PET_HIDE_UNKNOWN_OWNER)) {
                tooltip.addLine(new PairComponent(KEY, name));
            }
        }
    }

    private Future<class_2561> requestOwner(UUID uuid) {
        return ((CompletableFuture)HTTP.get().sendAsync(HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid)).GET().build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApplyAsync(res -> {
            String nameStr;
            JsonObject object;
            JsonElement element = JsonParser.parseString((String)((String)res.body()));
            if (element.isJsonObject() && (object = element.getAsJsonObject()).has("name") && (element = object.get("name")).isJsonPrimitive() && !(nameStr = element.getAsString()).isBlank()) {
                return class_2561.method_43470((String)nameStr);
            }
            return UNKNOWN;
        })).handle((component, throwable) -> {
            if (component != null) {
                return component;
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
            return UNKNOWN;
        });
    }

    static {
        HTTP = Suppliers.memoize(HttpClient::newHttpClient);
        NAMES = new HashMap<UUID, Future<class_2561>>();
        UNKNOWN = class_2561.method_43470((String)"???");
        LOADING = class_2561.method_43471((String)"tooltip.waila.owner.loading").method_27692(class_124.field_1056);
        KEY = class_2561.method_43471((String)"tooltip.waila.owner");
    }
}

