/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.IRayCastVectorProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IThemeType;
import mcp.mobius.waila.api.IntFormat;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.config.BlacklistConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.hud.theme.ThemeType;
import mcp.mobius.waila.registry.InstanceRegistry;
import mcp.mobius.waila.util.CachedSupplier;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.TypeUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class Registrar
implements IRegistrar {
    private static final CachedSupplier<Registrar> INSTANCE = new CachedSupplier<Registrar>(Registrar::new);
    private static final Log LOG = Log.create();
    public final InstanceRegistry<IBlockComponentProvider> blockRedirect = new InstanceRegistry();
    public final InstanceRegistry<IBlockComponentProvider> blockOverride = new InstanceRegistry();
    public final InstanceRegistry<IBlockComponentProvider> blockIcon = new InstanceRegistry();
    public final InstanceRegistry<IBlockComponentProvider> blockDataCtx = new InstanceRegistry();
    public final InstanceRegistry<IDataProvider<class_2586>> blockData = new InstanceRegistry();
    public final Map<TooltipPosition, InstanceRegistry<IBlockComponentProvider>> blockComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new InstanceRegistry());
        }
    });
    public final InstanceRegistry<IEntityComponentProvider> entityRedirect = new InstanceRegistry();
    public final InstanceRegistry<IEntityComponentProvider> entityOverride = new InstanceRegistry();
    public final InstanceRegistry<IEntityComponentProvider> entityIcon = new InstanceRegistry();
    public final InstanceRegistry<IEntityComponentProvider> entityDataCtx = new InstanceRegistry();
    public final InstanceRegistry<IDataProvider<class_1297>> entityData = new InstanceRegistry();
    public final Map<TooltipPosition, InstanceRegistry<IEntityComponentProvider>> entityComponent = (Map)class_156.method_654(new EnumMap(TooltipPosition.class), map -> {
        for (TooltipPosition key : TooltipPosition.values()) {
            map.put(key, new InstanceRegistry());
        }
    });
    public final InstanceRegistry<IEventListener> eventListeners = (InstanceRegistry)class_156.method_654(new InstanceRegistry(), InstanceRegistry::reversed);
    public final InstanceRegistry<IRayCastVectorProvider> raycastVectorProviders = new InstanceRegistry();
    public final BlacklistConfig blacklist = new BlacklistConfig();
    public final Map<class_2960, IntFormat> intConfigFormats = new HashMap<class_2960, IntFormat>();
    public final BiMap<class_2960, ThemeType<?>> themeTypes = HashBiMap.create();
    public final Map<Class<? extends IData>, Class<? extends IData>> impl2ApiDataType = new HashMap<Class<? extends IData>, Class<? extends IData>>();
    public final Map<Class<? extends IData>, class_2960> dataType2Id = new HashMap<Class<? extends IData>, class_2960>();
    public final Map<class_2960, IData.Serializer<?>> dataId2Serializer = new HashMap();
    @Nullable
    public IObjectPicker picker = null;
    private int pickerPriority = Integer.MAX_VALUE;
    @Nullable
    private IPluginInfo plugin;
    private boolean locked = false;

    public static Registrar get() {
        return INSTANCE.get();
    }

    public static void destroy() {
        INSTANCE.invalidate();
    }

    public void attach(@Nullable IPluginInfo plugin) {
        this.plugin = plugin;
    }

    private <T> void addConfig(class_2960 key, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged, ConfigEntry.Type<T> type) {
        this.assertLock();
        PluginConfig.addConfig(type.create(this.plugin, key, defaultValue, clientOnlyValue, serverRequired, merged));
    }

    @SafeVarargs
    private <T> void addBlacklist(Set<String> set, class_2378<T> registry, T ... values) {
        this.assertLock();
        for (T value : values) {
            set.add(Objects.requireNonNull(registry.method_10221(value)).toString());
        }
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addConfig(class_2960 key, double defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addConfig(class_2960 key, T defaultValue) {
        this.addConfig(key, defaultValue, defaultValue, false, false, ConfigEntry.ENUM);
    }

    @Override
    public void addConfig(class_2960 key, Path path) {
        this.addConfig(key, path, path, false, false, ConfigEntry.PATH);
    }

    @Override
    public void addFeatureConfig(class_2960 key, boolean clientOnly) {
        this.addConfig(key, true, clientOnly, !clientOnly, true, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(class_2960 key, boolean defaultValue, boolean clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.BOOLEAN);
    }

    @Override
    public void addSyncedConfig(class_2960 key, int defaultValue, int clientOnlyValue, IntFormat format) {
        this.intConfigFormats.put(key, format);
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.INTEGER);
    }

    @Override
    public void addSyncedConfig(class_2960 key, double defaultValue, double clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.DOUBLE);
    }

    @Override
    public void addSyncedConfig(class_2960 key, String defaultValue, String clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.STRING);
    }

    @Override
    public <T extends Enum<T>> void addSyncedConfig(class_2960 key, T defaultValue, T clientOnlyValue) {
        this.addConfig(key, defaultValue, clientOnlyValue, true, false, ConfigEntry.ENUM);
    }

    @Override
    public void addEventListener(IEventListener listener, int priority) {
        if (this.skip()) {
            return;
        }
        this.assertLock();
        this.eventListeners.add(Object.class, listener, priority);
    }

    @Override
    public void addBlacklist(class_2248 ... blocks) {
        this.addBlacklist((Set<String>)this.blacklist.blocks, (class_2378)class_2378.field_11146, (T[])blocks);
    }

    @Override
    public void addBlacklist(class_2591<?> ... blockEntityTypes) {
        this.addBlacklist(this.blacklist.blockEntityTypes, class_2378.field_11137, blockEntityTypes);
    }

    @Override
    public <T> void addRedirect(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockRedirect.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addOverride(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.blockOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IBlockComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.warnTargetClass(provider, clazz);
            this.blockIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IBlockComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.warnTargetClass(provider, clazz);
            this.blockComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDataContext(IBlockComponentProvider provider, Class<T> clazz) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.warnTargetClass(provider, clazz);
            this.blockDataCtx.add(clazz, provider, 0);
        }
    }

    @Override
    public <T, BE extends class_2586> void addBlockData(IDataProvider<BE> provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        this.assertLock();
        this.assertPriority(priority);
        this.warnTargetClass(provider, clazz);
        this.blockData.add(clazz, provider, priority);
    }

    @Override
    public void addBlacklist(class_1299<?> ... entityTypes) {
        this.addBlacklist((Set<String>)this.blacklist.entityTypes, (class_2378)class_2378.field_11145, (T[])entityTypes);
    }

    @Override
    public <T> void addRedirect(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.entityRedirect.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addOverride(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.warnTargetClass(provider, clazz);
            this.entityOverride.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addIcon(IEntityComponentProvider provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.warnTargetClass(provider, clazz);
            this.entityIcon.add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addComponent(IEntityComponentProvider provider, TooltipPosition position, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            this.warnTargetClass(provider, clazz);
            this.entityComponent.get((Object)position).add(clazz, provider, priority);
        }
    }

    @Override
    public <T> void addDataContext(IEntityComponentProvider provider, Class<T> clazz) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.warnTargetClass(provider, clazz);
            this.entityDataCtx.add(clazz, provider, 0);
        }
    }

    @Override
    public <T, E extends class_1297> void addEntityData(IDataProvider<E> provider, Class<T> clazz, int priority) {
        if (this.skip()) {
            return;
        }
        this.assertLock();
        this.assertPriority(priority);
        this.warnTargetClass(provider, clazz);
        this.entityData.add(clazz, provider, priority);
    }

    @Override
    public <A extends IData, I extends A> void addDataType(class_2960 id, Class<A> apiType, Class<I> implType, IData.Serializer<I> serializer) {
        this.assertLock();
        Preconditions.checkArgument((!this.dataId2Serializer.containsKey(id) ? 1 : 0) != 0, (String)"Data type with id %s already present", (Object)id);
        this.impl2ApiDataType.put(implType, apiType);
        this.dataType2Id.put(apiType, id);
        this.dataType2Id.put(implType, id);
        this.dataId2Serializer.put(id, serializer);
    }

    @Override
    public <T extends ITheme> void addThemeType(class_2960 id, IThemeType<T> type) {
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            ThemeType casted = (ThemeType)TypeUtil.uncheckedCast(type);
            this.themeTypes.put((Object)id, (Object)casted);
        }
    }

    @Override
    public void addRayCastVector(IRayCastVectorProvider provider, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.raycastVectorProviders.add(Object.class, provider, priority);
        }
    }

    @Override
    public void replacePicker(IObjectPicker picker, int priority) {
        if (this.skip()) {
            return;
        }
        if (Waila.CLIENT_SIDE) {
            this.assertLock();
            this.assertPriority(priority);
            if (priority <= this.pickerPriority) {
                this.picker = picker;
                this.pickerPriority = priority;
            }
        }
    }

    public void lock() {
        this.locked = true;
        if (Waila.CLIENT_SIDE) {
            if (this.picker != null) {
                LOG.info("Using {} as the object picker", this.picker.getClass().getName());
            } else {
                Preconditions.checkState((!this.raycastVectorProviders.get(Object.class).isEmpty() ? 1 : 0) != 0, (Object)"No raycast vector provider found");
            }
        }
        int[] hash = new int[]{0, 0, 0};
        hash[0] = this.blacklist.blocks.hashCode();
        hash[1] = this.blacklist.blockEntityTypes.hashCode();
        hash[2] = this.blacklist.entityTypes.hashCode();
        BlacklistConfig userBlacklist = Waila.BLACKLIST_CONFIG.get();
        if (!Arrays.equals(userBlacklist.pluginHash, hash)) {
            if (!Arrays.equals(userBlacklist.pluginHash, new int[]{0, 0, 0})) {
                Waila.BLACKLIST_CONFIG.backup("plugin hash mismatch");
            }
            BlacklistConfig newBlacklist = Waila.BLACKLIST_CONFIG.get();
            newBlacklist.pluginHash = hash;
            newBlacklist.blocks.addAll(this.blacklist.blocks);
            newBlacklist.blockEntityTypes.addAll(this.blacklist.blockEntityTypes);
            newBlacklist.entityTypes.addAll(this.blacklist.entityTypes);
        }
        Waila.BLACKLIST_CONFIG.save();
    }

    private void assertPlugin() {
        Preconditions.checkNotNull((Object)this.plugin, (Object)"Tried to register things outside the register method");
    }

    private boolean skip() {
        this.assertPlugin();
        return !this.plugin.isEnabled();
    }

    private void assertLock() {
        this.assertPlugin();
        Preconditions.checkState((!this.locked ? 1 : 0) != 0, (Object)"Tried to register new component after the registrar is locked");
    }

    private void assertPriority(int priority) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority must be equals or more than 0");
    }

    private void warnTargetClass(Object object, Class<?> clazz) {
        if (Waila.DEV && clazz.isInstance(object)) {
            LOG.warn("The target class {} is the same as the provider class, this is probably an error", clazz.getSimpleName());
        }
    }
}

