/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.gui;

import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.config.Colour;
import org.enginehub.worldeditcui.gui.SettingsEntry;
import org.enginehub.worldeditcui.gui.SettingsWidget;
import org.slf4j.Logger;

public class CUIConfigPanel
extends class_437
implements Supplier<class_437> {
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2561 TRUE = class_5244.field_24332.method_27661().method_27694(s -> s.method_27706(class_124.field_1077));
    private static final class_2561 FALSE = class_5244.field_24333.method_27661().method_27694(s -> s.method_27706(class_124.field_1079));
    private final class_437 parent;
    private final Set<String> options;
    private final CUIConfiguration configuration;
    private double scrollPercent = 0.0;
    private SettingsWidget configList;
    private class_339 done;
    private final class_2561 screenTitle;

    public CUIConfigPanel(class_437 parent, CUIConfiguration configuration) {
        super((class_2561)class_2561.method_43470((String)"WorldEditCUI"));
        this.parent = parent;
        this.configuration = configuration;
        this.options = this.configuration.getConfigArray().keySet();
        this.screenTitle = class_2561.method_43471((String)"worldeditcui.options.title");
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.configList.method_25405(mouseX, mouseY)) {
            return this.configList.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.configList = new SettingsWidget(this.field_22787, this.field_22789 - 8, this.field_22790, 48, this.field_22790 - 36, 25, this.configuration, this);
        this.configList.method_25333(0);
        if (this.field_22787.field_1687 != null) {
            this.configList.method_31322(false);
        }
        this.done = (class_339)this.method_37063((class_364)new class_339((this.field_22789 - 200) / 2, this.field_22790 - 27, 200, 20, class_5244.field_24334){

            public void method_37020(class_6382 builder) {
                this.method_37021(builder);
            }

            public void method_25348(double mouseX, double mouseY) {
                for (class_364 button : CUIConfigPanel.this.method_25396()) {
                    class_342 widget;
                    if (!(button instanceof class_342) || !(widget = (class_342)button).method_25370()) continue;
                    widget.method_25407(false);
                }
                CUIConfigPanel.this.configuration.configChanged();
                assert (CUIConfigPanel.this.field_22787 != null);
                CUIConfigPanel.this.field_22787.method_1507(CUIConfigPanel.this.parent);
            }
        });
        int y = 0;
        for (final String text : this.options) {
            class_339 element;
            int buttonX = this.field_22789 - 140 - 20;
            Object value = this.configuration.getConfigArray().get(text);
            class_2561 textTemp = this.configuration.getDescription(text);
            if (value == null) {
                LOGGER.warn("value of '{}' null, adding nothing", (Object)text);
                continue;
            }
            if (value instanceof Boolean) {
                element = (class_339)this.method_37063((class_364)new class_339(buttonX, y, 70, 20, (Boolean)value != false ? TRUE : FALSE){

                    public void method_37020(class_6382 builder) {
                        this.method_37021(builder);
                    }

                    public void method_25348(double mouseX, double mouseY) {
                        if (((Boolean)CUIConfigPanel.this.configuration.getConfigArray().get(text)).booleanValue()) {
                            CUIConfigPanel.this.configuration.changeValue(text, false);
                        } else {
                            CUIConfigPanel.this.configuration.changeValue(text, true);
                        }
                        this.method_25407(true);
                    }

                    protected void method_25363(boolean bl) {
                        this.method_25355((Boolean)CUIConfigPanel.this.configuration.getConfigArray().get(text) != false ? TRUE : FALSE);
                        super.method_25363(bl);
                    }
                });
            } else if (value instanceof Colour) {
                element = (class_339)this.method_37063((class_364)new TextFieldWidgetTemp(this.field_22793, buttonX, y, 70, 20, (class_2561)class_2561.method_43470((String)((Colour)value).hexString()), ((Colour)value).hexString()){

                    protected void method_25363(boolean bl) {
                        if (bl) {
                            this.method_1852(((Colour)CUIConfigPanel.this.configuration.getConfigArray().get(text)).hexString());
                        } else {
                            CUIConfigPanel.this.configuration.changeValue(text, Colour.parseRgbaOrNull(this.method_1882()));
                        }
                        super.method_25363(bl);
                    }

                    public boolean method_25400(char chr, int keyCode) {
                        boolean result = super.method_25400(chr, keyCode);
                        CUIConfigPanel.this.configuration.changeValue(text, Colour.parseRgbaOrNull(this.method_1882()));
                        return result;
                    }

                    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                        boolean result = super.method_25404(keyCode, scanCode, modifiers);
                        CUIConfigPanel.this.configuration.changeValue(text, Colour.parseRgbaOrNull(this.method_1882()));
                        return result;
                    }
                });
            } else {
                LOGGER.warn("WorldEditCUI has option {} with unknown data type {}", (Object)text, (Object)value.getClass().getName());
                continue;
            }
            this.configList.addEntry(new SettingsEntry(this.configList, (class_2561)(textTemp != null ? textTemp : class_2561.method_43470((String)text)), element, (class_339)this.method_37063((class_364)new class_339(buttonX + 75, y, 20, 20, (class_2561)class_2561.method_43473()){

                public void method_37020(class_6382 builder) {
                    this.method_37021(builder);
                }

                public void method_25348(double mouseX, double mouseY) {
                    CUIConfigPanel.this.configuration.changeValue(text, CUIConfigPanel.this.configuration.getDefaultValue(text));
                    element.method_25407(false);
                }
            })));
        }
        this.method_25395(null);
        this.method_37060((class_4068)this.configList);
    }

    @Override
    public class_437 get() {
        return this;
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.configList.method_25394(matrices, mouseX, mouseY, delta);
        CUIConfigPanel.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.screenTitle, (int)(this.configList.getWidth() / 2), (int)20, (int)0xFFFFFF);
        this.done.method_25394(matrices, mouseX, mouseY, delta);
    }

    double getScrollPercent() {
        return this.scrollPercent;
    }

    void updateScrollPercent(double scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    static class TextFieldWidgetTemp
    extends class_342 {
        public TextFieldWidgetTemp(class_327 textRenderer, int x, int y, int width, int height, class_2561 message, String text) {
            super(textRenderer, x, y, width, height, message);
            this.method_1852(text);
        }
    }
}

