/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.mixin;

import com.ishland.earlyloadingscreen.Launch;
import com.ishland.earlyloadingscreen.LoadingScreenManager;
import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.platform_cl.Config;
import com.ishland.earlyloadingscreen.platform_cl.LaunchPoint;
import com.ishland.earlyloadingscreen.util.WindowCreationUtil;
import net.minecraft.class_1041;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1041.class})
public class MixinWindow {
    @Shadow
    private int field_5182;
    @Shadow
    private int field_5197;
    @Shadow
    private int field_5184;
    @Shadow
    private int field_5174;

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J"))
    private long redirectCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        if (Config.WINDOW_CREATION_POINT.ordinal() <= LaunchPoint.off.ordinal()) {
            Launch.init();
        }
        if (Config.WINDOW_CREATION_POINT == LaunchPoint.off) {
            long newHandle = WindowCreationUtil.warpGlfwCreateWindow(width, height, title, monitor, share);
            MixinWindow.initGLFWHandle(newHandle);
            return newHandle;
        }
        long context = LoadingScreenManager.takeContext();
        if (context != 0L) {
            if (Config.REUSE_EARLY_WINDOW) {
                GLFW.glfwSetWindowTitle((long)context, (CharSequence)title);
                return context;
            }
            long newHandle = WindowCreationUtil.warpGlfwCreateWindow(width, height, title, monitor, share);
            MixinWindow.initGLFWHandle(newHandle);
            SharedConstants.LOGGER.info("Destroying early window");
            GLFW.glfwDestroyWindow((long)context);
            return newHandle;
        }
        return WindowCreationUtil.warpGlfwCreateWindow(width, height, title, monitor, share);
    }

    @Unique
    private static void initGLFWHandle(long newHandle) {
        GLFW.glfwMakeContextCurrent((long)newHandle);
        GL.createCapabilities();
        GLFW.glfwSwapBuffers((long)newHandle);
        LoadingScreenManager.reInitLoop();
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;updateWindowRegion()V")})
    private void syncSettingsFromEarlyWindow(CallbackInfo ci) {
        if (Config.REUSE_EARLY_WINDOW) {
            LoadingScreenManager.WindowSettings settings = LoadingScreenManager.getWindowSettings();
            this.field_5174 = this.field_5182 = settings.windowWidth();
            this.field_5184 = this.field_5197 = settings.windowHeight();
        }
    }
}

