/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.mixin.progress;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1059;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1088.class})
public abstract class MixinModelLoader {
    @Shadow
    @Final
    public static class_1091 field_5374;
    @Shadow
    @Final
    private static Map<class_2960, class_2689<class_2248, class_2680>> field_5383;
    @Shadow
    @Final
    private Map<class_2960, class_1100> field_5394;
    @Nullable
    private LoadingProgressManager.ProgressHolder modelLoadProgressHolder;
    @Nullable
    private LoadingProgressManager.ProgressHolder modelAdditionalLoadProgressHolder;
    private int modelLoadProgress = 0;
    private int modelLoadTotalEstimate;
    private int modelDependencyResolveProgress = 0;

    @Shadow
    protected abstract void method_4727(class_1091 var1);

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Ljava/lang/Object;<init>()V", shift=At.Shift.AFTER)})
    private void earlyInit(CallbackInfo ci) {
        this.modelLoadProgressHolder = LoadingProgressManager.tryCreateProgressHolder();
        this.modelAdditionalLoadProgressHolder = LoadingProgressManager.tryCreateProgressHolder();
        if (this.modelLoadProgressHolder != null) {
            this.modelLoadProgressHolder.update(() -> "Preparing models...");
        }
        for (Map.Entry<class_2960, class_2689<class_2248, class_2680>> entry : field_5383.entrySet()) {
            this.modelLoadTotalEstimate += entry.getValue().method_11662().size();
        }
        for (class_2248 block : class_2378.field_11146) {
            this.modelLoadTotalEstimate += block.method_9595().method_11662().size();
        }
        this.modelLoadTotalEstimate += class_2378.field_11142.method_10235().size();
        this.modelLoadTotalEstimate += 4;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void postInit(CallbackInfo ci) {
        if (this.modelLoadProgressHolder != null) {
            this.modelLoadProgressHolder.close();
            this.modelLoadProgressHolder = null;
        }
        if (this.modelAdditionalLoadProgressHolder != null) {
            this.modelAdditionalLoadProgressHolder.close();
            this.modelAdditionalLoadProgressHolder = null;
        }
    }

    @Inject(method={"addModel"}, at={@At(value="HEAD")})
    private void progressAddModel(class_1091 modelId, CallbackInfo ci) {
        ++this.modelLoadProgress;
        if (this.modelLoadProgressHolder != null) {
            this.modelLoadProgressHolder.update(() -> String.format("Loading model (%d/~%d): %s", this.modelLoadProgress, this.modelLoadTotalEstimate, modelId));
            this.modelLoadProgressHolder.updateProgress(() -> Float.valueOf((float)this.modelLoadProgress / (float)this.modelLoadTotalEstimate));
        }
    }

    @Inject(method={"method_4732"}, at={@At(value="HEAD")})
    private void progressModelResolution(Set<Pair<String, String>> set, class_1100 model, CallbackInfoReturnable<Stream<class_4730>> cir) {
        ++this.modelDependencyResolveProgress;
        if (this.modelLoadProgressHolder != null) {
            int size = this.field_5394.size();
            this.modelLoadProgressHolder.update(() -> String.format("Resolving model dependencies (%d/%d): %s", this.modelDependencyResolveProgress, size, model));
            this.modelLoadProgressHolder.updateProgress(() -> Float.valueOf((float)this.modelDependencyResolveProgress / (float)size));
        }
    }

    @Redirect(method={"upload"}, at=@At(value="INVOKE", target="Ljava/util/Set;forEach(Ljava/util/function/Consumer;)V"))
    private void redirectIteration(Set<class_2960> instance, Consumer<class_2960> consumer) {
        try (LoadingProgressManager.ProgressHolder progressHolder = LoadingProgressManager.tryCreateProgressHolder();){
            int index = 0;
            int size = instance.size();
            for (class_2960 identifier : instance) {
                if (progressHolder != null) {
                    int finalIndex = index;
                    progressHolder.update(() -> String.format("Baking model (%d/%d): %s", finalIndex, size, identifier));
                    progressHolder.updateProgress(() -> Float.valueOf((float)finalIndex / (float)size));
                }
                ++index;
                consumer.accept(identifier);
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/texture/SpriteAtlasTexture;stitch(Lnet/minecraft/resource/ResourceManager;Ljava/util/stream/Stream;Lnet/minecraft/util/profiler/Profiler;I)Lnet/minecraft/client/texture/SpriteAtlasTexture$Data;")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void captureStitching(class_3300 resourceManager, class_324 blockColors, class_3695 profiler, int mipmapLevel, CallbackInfo ci, Set<Pair<String, String>> set, Set<class_4730> set2, Map<class_2960, List<class_4730>> map, Iterator<Map.Entry<class_2960, List<class_4730>>> var8, Map.Entry<class_2960, List<class_4730>> entry, class_1059 spriteAtlasTexture) {
        if (this.modelLoadProgressHolder != null) {
            this.modelLoadProgressHolder.update(() -> "Stitching texture %s...".formatted(entry.getKey()));
            this.modelLoadProgressHolder.updateProgress(null);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V", ordinal=0)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/texture/SpriteAtlasTexture;stitch(Lnet/minecraft/resource/ResourceManager;Ljava/util/stream/Stream;Lnet/minecraft/util/profiler/Profiler;I)Lnet/minecraft/client/texture/SpriteAtlasTexture$Data;"))})
    private void capturePostStitching(CallbackInfo ci) {
        if (this.modelLoadProgressHolder != null) {
            this.modelLoadProgressHolder.update(() -> "Finalizing model load...");
        }
    }

    @Inject(method={"loadModel"}, at={@At(value="HEAD")})
    private void captureAdditionalLoadModelsPre(class_2960 id, CallbackInfo ci) {
        if (this.modelLoadProgress > this.modelLoadTotalEstimate && this.modelAdditionalLoadProgressHolder != null) {
            this.modelAdditionalLoadProgressHolder.update(() -> "Loading additional model %s...".formatted(id));
        }
    }

    @Inject(method={"loadModel"}, at={@At(value="RETURN")})
    private void captureAdditionalLoadModelsPost(class_2960 id, CallbackInfo ci) {
        if (this.modelLoadProgress > this.modelLoadTotalEstimate && this.modelAdditionalLoadProgressHolder != null) {
            this.modelAdditionalLoadProgressHolder.update(() -> "Loaded additional model %s".formatted(id));
        }
    }
}

