/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.mixin.progress;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.minecraft.class_1055;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1055.class})
public class MixinTextureStitcher {
    @Shadow
    @Final
    private Set<class_1055.class_1056> field_5237;
    private LoadingProgressManager.ProgressHolder progressHolder;

    @Inject(method={"stitch"}, at={@At(value="HEAD")})
    private void preStitch(CallbackInfo ci) {
        this.progressHolder = LoadingProgressManager.tryCreateProgressHolder();
        if (this.progressHolder != null) {
            this.progressHolder.update(() -> "Stitiching textures...");
        }
    }

    @Redirect(method={"stitch"}, at=@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private <E> Iterator<E> redirectStitchIterator(List<E> instance) {
        return instance.listIterator();
    }

    @Inject(method={"stitch"}, at={@At(value="INVOKE", target="Ljava/util/Iterator;next()Ljava/lang/Object;", shift=At.Shift.BY, by=3)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void monitorStitch(CallbackInfo ci, List<class_1055.class_1056> list, Iterator<class_1055.class_1056> var2, class_1055.class_1056 holder) {
        if (this.progressHolder != null && var2 instanceof ListIterator) {
            ListIterator iterator = (ListIterator)var2;
            int previousIndex = iterator.previousIndex();
            int size = list.size();
            this.progressHolder.update(() -> "Stitiching textures (%d/%d): %s".formatted(previousIndex, size, holder.field_5249.method_24121()));
            this.progressHolder.updateProgress(() -> Float.valueOf((float)previousIndex / (float)size));
        }
    }

    @Inject(method={"stitch"}, at={@At(value="RETURN")})
    private void postStitch(CallbackInfo ci) {
        if (this.progressHolder != null) {
            this.progressHolder.close();
        }
    }
}

