/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.patch;

import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.deps.bytebuddy.agent.ByteBuddyAgent;
import com.ishland.earlyloadingscreen.patch.BytecodeTransformer;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class PatchUtil {
    private static final Path transformerOutputPath = Path.of(".", ".earlyloadingscreen-transformer-output");
    static final CopyOnWriteArrayList<BytecodeTransformer> transformers = new CopyOnWriteArrayList();
    static final Instrumentation instrumentation;

    private static void deleteDirectory(Path path) throws IOException {
        Iterator iterator = Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).iterator();
        while (iterator.hasNext()) {
            Files.delete((Path)iterator.next());
        }
    }

    static {
        if (Files.isDirectory(transformerOutputPath, new LinkOption[0])) {
            try {
                PatchUtil.deleteDirectory(transformerOutputPath);
            }
            catch (IOException e) {
                SharedConstants.LOGGER.warn("Failed to delete transformer output directory", (Throwable)e);
            }
        }
        try {
            Files.createDirectories(transformerOutputPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            SharedConstants.LOGGER.warn("Failed to create transformer output directory", (Throwable)e);
        }
        Instrumentation inst = null;
        try {
            inst = ByteBuddyAgent.install();
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.warn("Failed to install ByteBuddyAgent, patching will not work", t);
        }
        instrumentation = inst;
        if (inst != null) {
            inst.addTransformer(new ClassFileTransformer(){

                @Override
                public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                    try {
                        ClassNode node = new ClassNode();
                        new ClassReader(classfileBuffer).accept((ClassVisitor)node, 0);
                        boolean transformed = false;
                        for (BytecodeTransformer transformer : transformers) {
                            transformed |= transformer.transform(className, node);
                        }
                        if (transformed) {
                            ClassWriter writer = new ClassWriter(3);
                            node.accept((ClassVisitor)writer);
                            byte[] buf = writer.toByteArray();
                            try {
                                Path path = transformerOutputPath.resolve(className + ".class");
                                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                                Files.write(path, buf, new OpenOption[0]);
                            }
                            catch (Throwable t) {
                                SharedConstants.LOGGER.warn("Failed to write transformed class %s to disk".formatted(className), t);
                            }
                            return buf;
                        }
                        return null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        SharedConstants.LOGGER.warn("Failed to transform class " + className, t);
                        return null;
                    }
                }
            }, true);
        }
    }
}

