/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.patch;

import com.ishland.earlyloadingscreen.LoadingProgressManager;
import com.ishland.earlyloadingscreen.SharedConstants;
import com.ishland.earlyloadingscreen.patch.BytecodeTransformer;
import com.ishland.earlyloadingscreen.patch.PatchUtil;
import com.ishland.earlyloadingscreen.util.RemapUtil;
import java.lang.instrument.Instrumentation;
import java.util.Arrays;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SodiumOSDetectionPatch
implements BytecodeTransformer {
    private static final SodiumOSDetectionPatch INSTANCE = new SodiumOSDetectionPatch();
    private static final String[] SODIUM_WORKAROUNDS_CLASSES = new String[]{"me/jellysquid/mods/sodium/client/util/workarounds/Workarounds", "me/jellysquid/mods/sodium/client/compatibility/workarounds/Workarounds", "me/jellysquid/mods/sodium/client/util/workarounds/driver/nvidia/NvidiaWorkarounds", "me/jellysquid/mods/sodium/client/compatibility/workarounds/nvidia/NvidiaWorkarounds", "me/jellysquid/mods/sodium/client/util/workarounds/driver/nvidia/NvidiaWorkarounds$1", "me/jellysquid/mods/sodium/client/compatibility/workarounds/nvidia/NvidiaWorkarounds$1", "me/jellysquid/mods/sodium/client/util/workarounds/probe/GraphicsAdapterProbe", "me/jellysquid/mods/sodium/client/compatibility/environment/probe/GraphicsAdapterProbe"};
    public static final boolean INITIALIZED = SodiumOSDetectionPatch.initTransformer();

    private SodiumOSDetectionPatch() {
    }

    public static void init() {
    }

    private static boolean initTransformer() {
        Instrumentation inst = PatchUtil.instrumentation;
        if (inst == null) {
            SharedConstants.LOGGER.warn("Instrumentation unavailable, sodium workarounds will not be available");
            LoadingProgressManager.showMessageAsProgress("Instrumentation unavailable, sodium workarounds may not be available");
            return false;
        }
        PatchUtil.transformers.add(INSTANCE);
        if (!Arrays.stream(SODIUM_WORKAROUNDS_CLASSES).allMatch(name -> SodiumOSDetectionPatch.tryRetransform(inst, name))) {
            SharedConstants.LOGGER.warn("Failed to retransform sodium workarounds, sodium workarounds will not be available");
            LoadingProgressManager.showMessageAsProgress("Failed to retransform sodium workarounds, sodium workarounds may not be available");
            PatchUtil.transformers.remove(INSTANCE);
            for (String s : SODIUM_WORKAROUNDS_CLASSES) {
                SodiumOSDetectionPatch.tryRetransform(inst, s);
            }
            return false;
        }
        return true;
    }

    private static boolean tryRetransform(Instrumentation inst, String name) {
        try {
            inst.retransformClasses(Class.forName(name.replace('/', '.')));
            return true;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        catch (Throwable t) {
            SharedConstants.LOGGER.warn("Failed to retransform class %s".formatted(name), t);
            return false;
        }
    }

    @Override
    public boolean transform(String className, ClassNode node) {
        if (Arrays.asList(SODIUM_WORKAROUNDS_CLASSES).contains(className)) {
            SharedConstants.LOGGER.info("Patching %s to allow early usage".formatted(className));
            MappingResolver resolver = FabricLoader.getInstance().getMappingResolver();
            String intermediary = "intermediary";
            for (MethodNode method : node.methods) {
                String remappedMCOS = resolver.mapClassName("intermediary", "net.minecraft.class_156$class_158").replace('.', '/');
                for (LocalVariableNode localVariableNode : method.localVariables) {
                    if (!localVariableNode.desc.equals(String.format("L%s;", remappedMCOS))) continue;
                    localVariableNode.desc = "Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;";
                }
                method.desc = method.desc.replace(String.format("L%s;", remappedMCOS), "Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;");
                if (method.signature != null) {
                    method.signature = method.signature.replace(String.format("L%s;", remappedMCOS), "Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;");
                }
                for (AbstractInsnNode insn : method.instructions) {
                    FieldInsnNode fieldInsnNode;
                    if (insn instanceof MethodInsnNode) {
                        MethodInsnNode methodInsnNode = (MethodInsnNode)insn;
                        if (methodInsnNode.getOpcode() == 184 && methodInsnNode.owner.equals(resolver.mapClassName("intermediary", "net.minecraft.class_156").replace('.', '/')) && methodInsnNode.name.equals(resolver.mapMethodName("intermediary", "net.minecraft.class_156", "method_668", "()Lnet/minecraft/class_156$class_158;")) && methodInsnNode.desc.equals(RemapUtil.remapMethodDescriptor("()Lnet/minecraft/class_156$class_158;"))) {
                            methodInsnNode.owner = "com/ishland/earlyloadingscreen/util/OSDetectionUtil";
                            methodInsnNode.name = "getOperatingSystem";
                            methodInsnNode.desc = "()Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;";
                        }
                        if (methodInsnNode.getOpcode() == 182 && methodInsnNode.owner.equals(remappedMCOS) && methodInsnNode.name.equals(resolver.mapMethodName("intermediary", "net.minecraft.class_156$class_158", "ordinal", "()I")) && methodInsnNode.desc.equals(RemapUtil.remapMethodDescriptor("()I"))) {
                            methodInsnNode.owner = "com/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem";
                        }
                        if (methodInsnNode.getOpcode() == 184 && methodInsnNode.owner.equals(remappedMCOS) && methodInsnNode.name.equals(resolver.mapMethodName("intermediary", "net.minecraft.class_156$class_158", "values", "()[Lnet/minecraft/class_156$class_158;")) && methodInsnNode.desc.equals(RemapUtil.remapMethodDescriptor("()[Lnet/minecraft/class_156$class_158;"))) {
                            methodInsnNode.owner = "com/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem";
                            methodInsnNode.desc = "()[Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;";
                        }
                        methodInsnNode.desc = methodInsnNode.desc.replace(String.format("L%s;", remappedMCOS), "Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;");
                    }
                    if (!(insn instanceof FieldInsnNode) || (fieldInsnNode = (FieldInsnNode)insn).getOpcode() != 178 || !fieldInsnNode.owner.equals(remappedMCOS) || !fieldInsnNode.desc.equals(RemapUtil.remapFieldDescriptor("Lnet/minecraft/class_156$class_158;"))) continue;
                    fieldInsnNode.owner = "com/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem";
                    fieldInsnNode.desc = "Lcom/ishland/earlyloadingscreen/util/OSDetectionUtil$OperatingSystem;";
                    if (fieldInsnNode.name.equals(resolver.mapFieldName("intermediary", "net.minecraft.class_156$class_158", "field_1135", "Lnet/minecraft/class_156$class_158;"))) {
                        fieldInsnNode.name = "LINUX";
                        continue;
                    }
                    if (fieldInsnNode.name.equals(resolver.mapFieldName("intermediary", "net.minecraft.class_156$class_158", "field_1134", "Lnet/minecraft/class_156$class_158;"))) {
                        fieldInsnNode.name = "SOLARIS";
                        continue;
                    }
                    if (fieldInsnNode.name.equals(resolver.mapFieldName("intermediary", "net.minecraft.class_156$class_158", "field_1133", "Lnet/minecraft/class_156$class_158;"))) {
                        fieldInsnNode.name = "WINDOWS";
                        continue;
                    }
                    if (fieldInsnNode.name.equals(resolver.mapFieldName("intermediary", "net.minecraft.class_156$class_158", "field_1132", "Lnet/minecraft/class_156$class_158;"))) {
                        fieldInsnNode.name = "OSX";
                        continue;
                    }
                    if (fieldInsnNode.name.equals(resolver.mapFieldName("intermediary", "net.minecraft.class_156$class_158", "field_1131", "Lnet/minecraft/class_156$class_158;"))) {
                        fieldInsnNode.name = "UNKNOWN";
                        continue;
                    }
                    throw new RuntimeException("Unknown field name: " + fieldInsnNode.name);
                }
            }
            return true;
        }
        return false;
    }
}

