/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.platform_cl;

import java.io.Closeable;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public class AppLoaderAccessSupport {
    private static final String shareKey = "early-loadingscreen:accessor";

    public static void setAccess(LoadingScreenAccessor access) {
        FabricLoader.getInstance().getObjectShare().put(shareKey, (Object)access);
    }

    public static ProgressHolderAccessor tryCreateProgressHolder() {
        Object o = FabricLoader.getInstance().getObjectShare().get(shareKey);
        if (o instanceof LoadingScreenAccessor) {
            LoadingScreenAccessor accessor = (LoadingScreenAccessor)o;
            return accessor.tryCreateProgressHolder();
        }
        if (o != null) {
            System.err.println(String.format("[EarlyLoadingScreen] Share %s exists but is not a LoadingScreenAccessor (found %s), entrypoint information will not be available.", shareKey, o));
        } else {
            System.err.println(String.format("[EarlyLoadingScreen] Share %s does not exist, entrypoint information will not be available.", shareKey));
        }
        return null;
    }

    public static <T> void onEntrypointInvoke(EntrypointContainer<T> container, ProgressHolderAccessor progressHolder, List<?> list, ListIterator<?> listIterator, String entrypointName) {
        if (progressHolder != null) {
            int prevIdx = listIterator.previousIndex();
            int size = list.size();
            progressHolder.update(() -> String.format("Running entrypoint %s (%d/%d) for mod %s", entrypointName, prevIdx, size, container.getProvider().getMetadata().getId()));
            progressHolder.updateProgress(() -> Float.valueOf((float)prevIdx / (float)size));
        }
    }

    static {
        if (AppLoaderAccessSupport.class.getClassLoader() != FabricLoader.class.getClassLoader()) {
            System.err.println(String.format("[EarlyLoadingScreen] AppLoaderAccessSupport is loaded by %s but expected to be loaded by %s! Entrypoint information may not be available. ", AppLoaderAccessSupport.class.getClassLoader(), FabricLoader.class.getClassLoader()));
        }
        LoadingScreenAccessor.class.getName();
        ProgressHolderAccessor.class.getName();
    }

    public static interface LoadingScreenAccessor {
        public ProgressHolderAccessor tryCreateProgressHolder();
    }

    public static interface ProgressHolderAccessor
    extends Closeable {
        public void update(Supplier<String> var1);

        public void updateProgress(Supplier<Float> var1);
    }
}

