/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.platform_cl;

import java.util.Locale;

public class PlatformUtil {
    private static final String NORMALIZED_OS = PlatformUtil.normalizeOs(System.getProperty("os.name", ""));
    public static final boolean IS_WINDOWS = "windows".equals(NORMALIZED_OS);
    public static final boolean IS_OSX = "osx".equals(NORMALIZED_OS);

    private static String normalize(String value) {
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeOs(String value) {
        if ((value = PlatformUtil.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (!value.startsWith("os400") || value.length() > 5 && Character.isDigit(value.charAt(5))) {
            if (value.startsWith("linux")) {
                return "linux";
            }
            if (!(value.startsWith("macosx") || value.startsWith("osx") || value.startsWith("darwin"))) {
                if (value.startsWith("freebsd")) {
                    return "freebsd";
                }
                if (value.startsWith("openbsd")) {
                    return "openbsd";
                }
                if (value.startsWith("netbsd")) {
                    return "netbsd";
                }
                if (!value.startsWith("solaris") && !value.startsWith("sunos")) {
                    return value.startsWith("windows") ? "windows" : "unknown";
                }
                return "sunos";
            }
            return "osx";
        }
        return "os400";
    }
}

