/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.render;

import org.lwjgl.opengl.GL32;

public class Simple2DDraw {
    private final int shaderProgram;
    private final int projectionUniformLocation;

    public Simple2DDraw() {
        int vertexShader = GL32.glCreateShader((int)35633);
        GL32.glShaderSource((int)vertexShader, (CharSequence)"#version 150 core\nin vec2 position;\nin vec4 color;\n\nuniform mat4 projection;\n\nout vec4 fColor;\n\nvoid main() {\n    gl_Position = projection * vec4(position, 0.0, 1.0);\n    fColor = color;\n}\n");
        GL32.glCompileShader((int)vertexShader);
        int[] success = new int[1];
        GL32.glGetShaderiv((int)vertexShader, (int)35713, (int[])success);
        if (success[0] == 0) {
            RuntimeException e = new RuntimeException("Failed to compile vertex shader: " + GL32.glGetShaderInfoLog((int)vertexShader));
            GL32.glDeleteShader((int)vertexShader);
            throw e;
        }
        int fragmentShader = GL32.glCreateShader((int)35632);
        GL32.glShaderSource((int)fragmentShader, (CharSequence)"#version 150 core\nin vec4 fColor;\n\nout vec4 FragColor;\n\nvoid main() {\n    if (fColor.a < 0.01)\n        discard;\n    FragColor = fColor;\n}\n");
        GL32.glCompileShader((int)fragmentShader);
        GL32.glGetShaderiv((int)fragmentShader, (int)35713, (int[])success);
        if (success[0] == 0) {
            RuntimeException e = new RuntimeException("Failed to compile fragment shader: " + GL32.glGetShaderInfoLog((int)fragmentShader));
            GL32.glDeleteShader((int)vertexShader);
            GL32.glDeleteShader((int)fragmentShader);
            throw e;
        }
        this.shaderProgram = GL32.glCreateProgram();
        GL32.glAttachShader((int)this.shaderProgram, (int)vertexShader);
        GL32.glAttachShader((int)this.shaderProgram, (int)fragmentShader);
        GL32.glLinkProgram((int)this.shaderProgram);
        GL32.glGetProgramiv((int)this.shaderProgram, (int)35714, (int[])success);
        if (success[0] == 0) {
            RuntimeException e = new RuntimeException("Failed to link shader program: " + GL32.glGetProgramInfoLog((int)this.shaderProgram));
            GL32.glDeleteShader((int)vertexShader);
            GL32.glDeleteShader((int)fragmentShader);
            GL32.glDeleteProgram((int)this.shaderProgram);
            throw e;
        }
        GL32.glDeleteShader((int)vertexShader);
        GL32.glDeleteShader((int)fragmentShader);
        this.projectionUniformLocation = GL32.glGetUniformLocation((int)this.shaderProgram, (CharSequence)"projection");
    }

    public void viewport(int width, int height) {
        GL32.glUseProgram((int)this.shaderProgram);
        GL32.glUniformMatrix4fv((int)this.projectionUniformLocation, (boolean)false, (float[])new float[]{2.0f / (float)width, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f / (float)height, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f});
        GL32.glUseProgram((int)0);
    }

    public void destroy() {
        GL32.glDeleteProgram((int)this.shaderProgram);
    }

    public class BufferBuilder {
        private static final int INITIAL_SIZE = 1024;
        private float[] buffer = new float[1024];
        private final int vbo = GL32.glGenBuffers();
        private final int vao = GL32.glGenVertexArrays();
        private boolean destroyed = false;
        private boolean building = false;
        private int pos = 0;

        public BufferBuilder() {
            GL32.glBindVertexArray((int)this.vao);
            GL32.glBindBuffer((int)34962, (int)this.vbo);
            GL32.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)24, (long)0L);
            GL32.glEnableVertexAttribArray((int)0);
            GL32.glVertexAttribPointer((int)1, (int)4, (int)5126, (boolean)false, (int)24, (long)8L);
            GL32.glEnableVertexAttribArray((int)1);
            GL32.glBindBuffer((int)34962, (int)0);
            GL32.glBindVertexArray((int)0);
        }

        private void ensureCapacity(int capacity) {
            if (this.buffer.length < capacity) {
                float[] newBuffer = new float[this.buffer.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                this.buffer = newBuffer;
            }
        }

        public BufferBuilder begin() {
            if (this.building) {
                throw new IllegalStateException("Already building");
            }
            this.building = true;
            this.pos = 0;
            return this;
        }

        public BufferBuilder vertex(float x, float y, float r, float g, float b, float a) {
            this.ensureCapacity(this.pos + 6);
            this.buffer[this.pos++] = x;
            this.buffer[this.pos++] = y;
            this.buffer[this.pos++] = r;
            this.buffer[this.pos++] = g;
            this.buffer[this.pos++] = b;
            this.buffer[this.pos++] = a;
            return this;
        }

        public BufferBuilder triangle(float x1, float y1, float x2, float y2, float x3, float y3, float r, float g, float b, float a) {
            this.ensureCapacity(this.pos + 18);
            this.vertex(x1, y1, r, g, b, a);
            this.vertex(x2, y2, r, g, b, a);
            this.vertex(x3, y3, r, g, b, a);
            return this;
        }

        public BufferBuilder rect(float x, float y, float width, float height, float r, float g, float b, float a) {
            this.ensureCapacity(this.pos + 24);
            this.triangle(x, y, x, y + height, x + width, y, r, g, b, a);
            this.triangle(x + width, y + height, x + width, y, x, y + height, r, g, b, a);
            return this;
        }

        public void end() {
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed");
            }
            if (!this.building) {
                throw new IllegalStateException("Not building");
            }
            this.building = false;
            GL32.glBindBuffer((int)34962, (int)this.vbo);
            GL32.glBufferData((int)34962, (float[])this.buffer, (int)35048);
            GL32.glBindBuffer((int)34962, (int)0);
        }

        public void draw() {
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed");
            }
            if (this.building) {
                throw new IllegalStateException("Still building");
            }
            GL32.glUseProgram((int)Simple2DDraw.this.shaderProgram);
            GL32.glBindVertexArray((int)this.vao);
            GL32.glDrawArrays((int)4, (int)0, (int)(this.pos / 6));
            GL32.glBindVertexArray((int)0);
            GL32.glUseProgram((int)0);
        }

        public void destroy() {
            GL32.glDeleteBuffers((int)this.vbo);
            GL32.glDeleteVertexArrays((int)this.vao);
            this.destroyed = true;
        }
    }
}

