/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.earlyloadingscreen.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.fabricmc.loader.api.FabricLoader;

public class AppLoaderUtil {
    public static void init() {
        try {
            AppLoaderUtil.defineClass("com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport");
            AppLoaderUtil.defineClass("com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport$LoadingScreenAccessor");
            AppLoaderUtil.defineClass("com.ishland.earlyloadingscreen.platform_cl.AppLoaderAccessSupport$ProgressHolderAccessor");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to init AppLoaderUtil", t);
        }
    }

    private static void defineClass(String name) throws IllegalAccessException, InvocationTargetException, IOException, NoSuchMethodException {
        if (AppLoaderUtil.isAlreadyLoaded(name)) {
            return;
        }
        Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        defineClass.setAccessible(true);
        defineClass.invoke((Object)FabricLoader.class.getClassLoader(), name, AppLoaderUtil.getClassFile(name), 0, AppLoaderUtil.getClassFile(name).length);
    }

    private static boolean isAlreadyLoaded(String name) {
        try {
            Class.forName(name, false, FabricLoader.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static byte[] getClassFile(String name) throws IOException {
        try (InputStream in = AppLoaderUtil.class.getClassLoader().getResourceAsStream(name.replace('.', '/') + ".class");){
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }
}

