/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.render;

import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.versionless.render.CustomModelPart;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class CustomizableModelPart
extends CustomModelPart
implements Mesh {
    private final List<class_630.class_628> cubes;
    private final Map<String, class_630> children;
    private class_1162[] vector4f = new class_1162[]{new class_1162(), new class_1162(), new class_1162(), new class_1162()};

    public CustomizableModelPart(List<class_630.class_628> list, List<CustomizableCube> customCubes, Map<String, class_630> map) {
        super(customCubes);
        this.cubes = list;
        this.children = map;
    }

    @Override
    public void loadPose(class_5603 partPose) {
        this.x = partPose.field_27702;
        this.y = partPose.field_27703;
        this.z = partPose.field_27704;
        this.xRot = partPose.field_27705;
        this.yRot = partPose.field_27706;
        this.zRot = partPose.field_27707;
    }

    @Override
    public void copyFrom(class_630 modelPart) {
        this.xRot = modelPart.field_3654;
        this.yRot = modelPart.field_3675;
        this.zRot = modelPart.field_3674;
        this.x = modelPart.field_3657;
        this.y = modelPart.field_3656;
        this.z = modelPart.field_3655;
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexConsumer, int i, int j) {
        this.render(null, poseStack, vertexConsumer, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private int convertFloatColorToInteger(float color) {
        return color > 1.0f ? 255 : Math.round(color * 255.0f);
    }

    @Deprecated(forRemoval=true)
    public void render(class_630 vanillaModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        int color = (this.convertFloatColorToInteger(alpha) & 0xFF) << 24 | (this.convertFloatColorToInteger(red) & 0xFF) << 16 | (this.convertFloatColorToInteger(green) & 0xFF) << 8 | this.convertFloatColorToInteger(blue) & 0xFF;
        this.render(vanillaModel, poseStack, vertexConsumer, light, overlay, color);
    }

    @Override
    public void render(class_630 vanillaModel, class_4587 poseStack, class_4588 vertexConsumer, int light, int overlay, int color) {
        if (!this.visible) {
            return;
        }
        poseStack.method_22903();
        this.translateAndRotate(poseStack);
        this.compile(vanillaModel, poseStack.method_23760(), vertexConsumer, light, overlay, color);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        for (class_630 modelPart : this.children.values()) {
            modelPart.method_22699(poseStack, vertexConsumer, light, overlay, r, g, b, a);
        }
        poseStack.method_22909();
    }

    public void translateAndRotate(class_4587 poseStack) {
        poseStack.method_22904((double)(this.x / 16.0f), (double)(this.y / 16.0f), (double)(this.z / 16.0f));
        if (this.zRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20707.method_23626(this.zRot));
        }
        if (this.yRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20705.method_23626(this.yRot));
        }
        if (this.xRot != 0.0f) {
            poseStack.method_22907(class_1160.field_20703.method_23626(this.xRot));
        }
    }

    private void compile(class_630 vanillaModel, class_4587.class_4665 pose, class_4588 vertexConsumer, int light, int overlay, int color) {
        MeshTransformer transformer = SkinLayersAPI.getMeshTransformerProvider().prepareTransformer(vanillaModel);
        class_1159 matrix4f = pose.method_23761();
        class_4581 matrix3f = pose.method_23762();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        for (int id = 0; id < this.polygonData.length; id += 23) {
            int o;
            class_1160 vector3f = new class_1160(this.polygonData[id + 0], this.polygonData[id + 1], this.polygonData[id + 2]);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].method_23851(this.polygonData[id + 3 + o * 5 + 0], this.polygonData[id + 3 + o * 5 + 1], this.polygonData[id + 3 + o * 5 + 2], 1.0f);
            }
            transformer.transform(vector3f, this.vector4f);
            vector3f.method_23215(matrix3f);
            for (o = 0; o < 4; ++o) {
                this.vector4f[o].method_22674(matrix4f);
                vertexConsumer.method_23919(this.vector4f[o].method_4953(), this.vector4f[o].method_4956(), this.vector4f[o].method_4957(), red, green, blue, alpha, this.polygonData[id + 3 + o * 5 + 3], this.polygonData[id + 3 + o * 5 + 4], overlay, light, vector3f.method_4943(), vector3f.method_4945(), vector3f.method_4947());
            }
        }
        for (class_630.class_628 cube : this.cubes) {
            transformer.transform(cube);
            cube.method_32089(pose, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }
}

