/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static File configFile;
    private static Gson gson;

    public static void init() {
        configFile = new File(FabricLoader.getInstance().getConfigDirectory(), "fpsreducer.json");
        ConfigManager.load();
    }

    public static void load() {
        if (!configFile.exists()) {
            ConfigManager.save();
        }
        if (configFile.exists()) {
            try {
                BufferedReader bufReader = new BufferedReader(new FileReader(configFile));
                Config loadedConfig = (Config)gson.fromJson((Reader)bufReader, Config.class);
                bufReader.close();
                if (loadedConfig != null) {
                    Config.setInstance(loadedConfig);
                    Config.getInstance().correctProfile();
                    Config.getInstance().update();
                    ConfigManager.save();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        Config.getInstance().prepareSave();
        try {
            Config config = Config.getInstance();
            FileWriter writer = new FileWriter(configFile);
            writer.write(gson.toJson((Object)config));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }
}

