/*
 * Decompiled with CFR 0.152.
 */
package org.spoorn.climbladdersfast.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spoorn.climbladdersfast.config.ModConfig;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    private LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"applyClimbingSpeed"}, at={@At(value="TAIL")}, cancellable=true)
    public void adjustClimbingSpeed(class_243 motion, CallbackInfoReturnable<class_243> cir) {
        class_2680 climbingBlockState;
        class_1309 livingEntity = (class_1309)this;
        if (!livingEntity.method_6101() || livingEntity.method_5715() || !(livingEntity instanceof class_1657)) {
            return;
        }
        boolean disableScaffolding = ModConfig.get().disableScaffoldingFastClimbing;
        boolean disableVines = ModConfig.get().disableVinesFastClimbing;
        if ((disableScaffolding || disableVines) && (climbingBlockState = super.method_36601()) != null) {
            String id = class_2378.field_11146.method_10221((Object)climbingBlockState.method_26204()).toString();
            if (disableScaffolding && id.equals(class_2378.field_11146.method_10221((Object)class_2246.field_16492).toString()) || disableVines && id.contains("vine")) {
                return;
            }
        }
        if (this.isEntityLookingUpOrDown(livingEntity) && this.isEntityStill(livingEntity)) {
            class_243 vec3d = (class_243)cir.getReturnValue();
            double y = vec3d.method_10214();
            if (this.isEntityLookingUp(livingEntity)) {
                y = this.getNormalizedPitch(livingEntity.method_36455()) * ModConfig.get().climbUpSpeed;
            } else if (this.isEntityLookingDown(livingEntity)) {
                y = this.getNormalizedPitch(livingEntity.method_36455()) * ModConfig.get().climbDownSpeed * -1.0;
            }
            cir.setReturnValue((Object)new class_243(vec3d.method_10216(), y, vec3d.method_10215()));
        }
    }

    private boolean isEntityLookingUp(class_1309 livingEntity) {
        return livingEntity.method_36455() < 0.0f;
    }

    private boolean isEntityLookingDown(class_1309 livingEntity) {
        return livingEntity.method_36455() > 0.0f;
    }

    private boolean isEntityLookingUpOrDown(class_1309 livingEntity) {
        return livingEntity.method_36455() != 0.0f;
    }

    private boolean isEntityStill(class_1309 livingEntity) {
        return livingEntity.field_6250 == 0.0f;
    }

    private double getNormalizedPitch(float pitch) {
        return Math.abs((double)pitch / 90.0);
    }
}

