/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config;

import java.util.function.Predicate;
import java.util.function.Supplier;
import terrails.healthoverlay.HOExpectPlatform;

public class ConfigOption<T> {
    private final Supplier<T> supplier;
    private final Supplier<T> defaultSupplier;
    private final Predicate<T> predicate;

    public ConfigOption(Supplier<T> supplier, Supplier<T> defaultSupplier, Predicate<T> predicate) {
        this.supplier = supplier;
        this.defaultSupplier = defaultSupplier;
        this.predicate = predicate;
    }

    public T get() {
        return this.supplier.get();
    }

    public T getDefault() {
        return this.defaultSupplier.get();
    }

    public boolean set(T value) {
        boolean ret = this.predicate.test(value);
        if (ret) {
            HOExpectPlatform.applyConfig();
        }
        return ret;
    }
}

