/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.config.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import terrails.healthoverlay.config.ConfigOption;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.base.ColorSelectionList;
import terrails.healthoverlay.config.screen.widgets.HeartColorEditBox;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.heart.HeartType;

public class ColorSelectionScreen
extends class_437 {
    private final class_437 lastScreen;
    private final boolean health;
    private List<HeartColorEditBox> editBoxes;
    private boolean vanillaHeart;
    private boolean hasChanged;
    private List<class_4185> heartTypeButtons;
    private class_4185 saveButton;
    private ColorSelectionList colorSelectionList;
    private HeartType heartType;

    public ColorSelectionScreen(class_437 lastScreen, boolean health) {
        super((class_2561)class_2561.method_43471((String)(health ? "healthoverlay.screen.title.health" : "healthoverlay.screen.title.absorption")));
        this.lastScreen = lastScreen;
        this.health = health;
        this.updateHeartType(HeartType.NORMAL);
    }

    protected void method_25426() {
        super.method_25426();
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int marginY = 40;
        double prevScrollAmount = this.colorSelectionList == null ? 0.0 : this.colorSelectionList.method_25341();
        this.colorSelectionList = (ColorSelectionList)this.method_37063((class_364)new ColorSelectionList(class_310.method_1551(), width, height, marginY, height - marginY, 26));
        this.addColorElements();
        this.colorSelectionList.method_25307(prevScrollAmount);
        int BUTTON_SPACING = 10;
        int BUTTON_WIDTH = 80;
        int startX = (width - BUTTON_WIDTH * 4 - BUTTON_SPACING * 3) / 2;
        int y = (marginY - 20) / 2;
        this.heartTypeButtons = new ArrayList<class_4185>();
        class_4185 normalHearts = new class_4185(startX, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.option.button.normal"), btn -> this.updateHeartType(HeartType.NORMAL));
        normalHearts.field_22763 = this.heartType != HeartType.NORMAL;
        this.method_37063((class_364)normalHearts);
        this.heartTypeButtons.add(normalHearts);
        int x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        class_4185 poisonedHearts = new class_4185(x, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.option.button.poisoned"), btn -> this.updateHeartType(HeartType.POISONED));
        poisonedHearts.field_22763 = this.heartType != HeartType.POISONED;
        this.method_37063((class_364)poisonedHearts);
        this.heartTypeButtons.add(poisonedHearts);
        class_4185 witheredHearts = new class_4185(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.option.button.withered"), btn -> this.updateHeartType(HeartType.WITHERED));
        witheredHearts.field_22763 = this.heartType != HeartType.WITHERED;
        this.method_37063((class_364)witheredHearts);
        this.heartTypeButtons.add(witheredHearts);
        class_4185 frozenHearts = new class_4185(x += BUTTON_WIDTH + BUTTON_SPACING, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.option.button.frozen"), btn -> this.updateHeartType(HeartType.FROZEN));
        frozenHearts.field_22763 = this.heartType != HeartType.FROZEN;
        this.method_37063((class_364)frozenHearts);
        this.heartTypeButtons.add(frozenHearts);
        BUTTON_WIDTH = 120;
        BUTTON_SPACING = 30;
        startX = (width - BUTTON_WIDTH * 2 - BUTTON_SPACING) / 2;
        y = height - (marginY - 20) / 2 - marginY / 2;
        class_4185 saveButton = new class_4185(startX, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.options.button.confirm"), btn -> {
            this.saveConfig();
            this.method_25419();
        });
        saveButton.field_22763 = false;
        this.method_37063((class_364)saveButton);
        this.saveButton = saveButton;
        x = startX + BUTTON_WIDTH + BUTTON_SPACING;
        class_4185 cancelButton = new class_4185(x, y, BUTTON_WIDTH, 20, (class_2561)class_2561.method_43471((String)"healthoverlay.options.button.cancel"), btn -> this.method_25419());
        this.method_37063((class_364)cancelButton);
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.field_22763 = false;
            });
        }
        if (this.canSave()) {
            this.saveButton.field_22763 = true;
        }
    }

    public void updateHeartType(HeartType type) {
        this.heartType = type;
        this.vanillaHeart = this.hasVanillaHeartVariant() && this.heartColorsContainVanilla();
        this.editBoxes = null;
        this.method_41843();
    }

    public boolean canSave() {
        boolean invalidColorsPresent = this.editBoxes.stream().anyMatch(box -> !box.isValidHex());
        long colorCount = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).count();
        boolean hasEnoughColors = colorCount > 0L && (this.health && (this.heartType == HeartType.NORMAL || this.vanillaHeart || colorCount == 2L) || !this.health && (this.heartType == HeartType.NORMAL || colorCount == 2L));
        return this.hasChanged && !invalidColorsPresent && hasEnoughColors;
    }

    public boolean hasVanillaHeartVariant() {
        return this.health || this.heartType == HeartType.NORMAL;
    }

    private boolean haveValuesChanged() {
        boolean hasVanillaOptionChanged;
        List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
        boolean isSizeEqual = pieces.size() == this.editBoxes.size();
        boolean bl = hasVanillaOptionChanged = !this.hasVanillaHeartVariant() || this.heartType == HeartType.NORMAL && this.vanillaHeart == this.configVanillaHeart().get() || this.heartType != HeartType.NORMAL && this.vanillaHeart == this.heartColorsContainVanilla();
        if (isSizeEqual && hasVanillaOptionChanged) {
            for (int i = 0; i < pieces.size(); ++i) {
                HeartColorEditBox box = this.editBoxes.get(i);
                HeartPiece piece = pieces.get(i);
                if (box.isValidHex() && piece.getHexColor().equalsIgnoreCase(box.method_1882())) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private List<HeartPiece> heartColorsWithoutVanilla() {
        ArrayList<HeartPiece> pieces = new ArrayList<HeartPiece>((Collection)this.configHeartColor().get());
        if (this.health) {
            pieces.remove(HeartPiece.VANILLA_HEALTH);
        } else {
            pieces.remove(HeartPiece.VANILLA_ABSORPTION);
        }
        return pieces;
    }

    private boolean heartColorsContainVanilla() {
        ArrayList pieces = new ArrayList(this.configHeartColor().get());
        if (this.health) {
            return pieces.contains(HeartPiece.VANILLA_HEALTH);
        }
        return pieces.contains(HeartPiece.VANILLA_ABSORPTION);
    }

    private ConfigOption<Boolean> configVanillaHeart() {
        if (this.health) {
            return Configuration.HEALTH.vanillaHearts;
        }
        return Configuration.ABSORPTION.vanillaHearts;
    }

    private ConfigOption<List<HeartPiece>> configHeartColor() {
        ConfigOption<List<HeartPiece>> heartColors = null;
        if (this.health) {
            switch (this.heartType) {
                case NORMAL: {
                    heartColors = Configuration.HEALTH.normalColors;
                    break;
                }
                case POISONED: {
                    heartColors = Configuration.HEALTH.poisonedColors;
                    break;
                }
                case WITHERED: {
                    heartColors = Configuration.HEALTH.witheredColors;
                    break;
                }
                case FROZEN: {
                    heartColors = Configuration.HEALTH.frozenColors;
                }
            }
        } else {
            switch (this.heartType) {
                case NORMAL: {
                    heartColors = Configuration.ABSORPTION.normalColors;
                    break;
                }
                case POISONED: {
                    heartColors = Configuration.ABSORPTION.poisonedColors;
                    break;
                }
                case WITHERED: {
                    heartColors = Configuration.ABSORPTION.witheredColors;
                    break;
                }
                case FROZEN: {
                    heartColors = Configuration.ABSORPTION.frozenColors;
                }
            }
        }
        return heartColors;
    }

    private void saveConfig() {
        List heartPieces = this.editBoxes.stream().filter(HeartColorEditBox::isValidHex).map(HeartColorEditBox::getHeartPiece).collect(Collectors.toList());
        if (this.hasVanillaHeartVariant() && this.vanillaHeart) {
            if (this.health) {
                heartPieces.add(0, HeartPiece.VANILLA_HEALTH);
            } else {
                heartPieces.add(0, HeartPiece.VANILLA_ABSORPTION);
            }
        }
        if (this.health) {
            if (this.heartType != HeartType.NORMAL && this.vanillaHeart) {
                heartPieces.remove(heartPieces.size() - 1);
            }
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.HEALTH.normalColors.set(heartPieces);
                    Configuration.HEALTH.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.HEALTH.poisonedColors.set(heartPieces);
                    break;
                }
                case WITHERED: {
                    Configuration.HEALTH.witheredColors.set(heartPieces);
                    break;
                }
                case FROZEN: {
                    Configuration.HEALTH.frozenColors.set(heartPieces);
                }
            }
        } else {
            switch (this.heartType) {
                case NORMAL: {
                    Configuration.ABSORPTION.normalColors.set(heartPieces);
                    Configuration.ABSORPTION.vanillaHearts.set(this.vanillaHeart);
                    break;
                }
                case POISONED: {
                    Configuration.ABSORPTION.poisonedColors.set(heartPieces);
                    break;
                }
                case WITHERED: {
                    Configuration.ABSORPTION.witheredColors.set(heartPieces);
                    break;
                }
                case FROZEN: {
                    Configuration.ABSORPTION.frozenColors.set(heartPieces);
                }
            }
        }
    }

    private void addColorElements() {
        int ELEMENTS_PER_ROW = 4;
        int ELEMENT_SPACING = 6;
        int EDIT_BOX_WIDTH = 60;
        int BUTTON_DIMS = 20;
        int BUTTON_SPACING = 3;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int totalElementWidth = 350;
        int startX = (screenWidth - totalElementWidth) / 2;
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        int OFFSET = 0;
        if (this.hasVanillaHeartVariant()) {
            OFFSET = 1;
            Supplier<class_2561> componentSupplier = () -> {
                if (this.vanillaHeart) {
                    return class_2561.method_43471((String)"healthoverlay.options.button.vanilla_heart.on");
                }
                return class_2561.method_43471((String)"healthoverlay.options.button.vanilla_heart.off");
            };
            class_4185 vanillaHeart = new class_4185(startX, 0, 83, 20, componentSupplier.get(), btn -> {
                this.vanillaHeart = !this.vanillaHeart;
                this.hasChanged = this.haveValuesChanged();
                btn.method_25355((class_2561)componentSupplier.get());
                this.method_41843();
            });
            widgets.add((class_339)vanillaHeart);
        }
        if (this.editBoxes == null) {
            this.editBoxes = new ArrayList<HeartColorEditBox>();
            List<HeartPiece> pieces = this.heartColorsWithoutVanilla();
            for (HeartPiece piece : pieces) {
                HeartColorEditBox box = new HeartColorEditBox(this.field_22793, 0, 0, 0, 0, (class_2561)class_2561.method_43473(), this.heartType, this.health);
                box.method_1852(piece.getHexColor());
                this.editBoxes.add(box);
            }
        }
        int elementCount = this.editBoxes.size();
        for (int i = 0; i < elementCount; ++i) {
            boolean canHaveMoreHearts;
            boolean isRowDone;
            boolean stopRendering;
            boolean bl = stopRendering = this.health && this.heartType != HeartType.NORMAL && (i > 0 && this.vanillaHeart || i > 1);
            if (stopRendering) {
                this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
                break;
            }
            int index = i;
            int column = (i + OFFSET) % 4;
            int x = startX + column * 89;
            class_4185 button = new class_4185(x, 0, 20, 20, (class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1061), btn -> {
                this.editBoxes.remove(index);
                this.hasChanged = this.haveValuesChanged();
                this.method_41843();
            });
            HeartColorEditBox box = this.editBoxes.get(index);
            box = new HeartColorEditBox(this.field_22793, x + 20 + 3, 0, 58, 20, box, (class_2561)class_2561.method_43473(), this.heartType, this.health);
            box.method_1863(str -> {
                this.hasChanged = this.haveValuesChanged();
            });
            this.editBoxes.set(index, box);
            widgets.add((class_339)button);
            widgets.add((class_339)box);
            boolean isFinished = index + 1 == elementCount;
            boolean bl2 = isRowDone = column + 1 == 4;
            if (isRowDone) {
                this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
                widgets.clear();
            }
            if (!isFinished) continue;
            boolean bl3 = canHaveMoreHearts = this.heartType == HeartType.NORMAL || elementCount < 2 && !this.vanillaHeart;
            if (canHaveMoreHearts) {
                column = (column + 1) % 4;
                x = startX + column * 60 + column * 20 + column * 6 + column * 3;
                class_4185 addButton = new class_4185(x, 0, 20, 20, (class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1060), btn -> {
                    this.editBoxes.add(new HeartColorEditBox(this.field_22793, 0, 0, 38, 20, (class_2561)class_2561.method_43473(), this.heartType, this.health));
                    this.hasChanged = this.haveValuesChanged();
                    this.method_41843();
                });
                widgets.add((class_339)addButton);
            }
            this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
        }
        if (this.editBoxes.size() == 0) {
            int x = startX + 60 + 20 + 6 + 3;
            class_4185 addButton = new class_4185(x, 0, 20, 20, (class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1060), btn -> {
                this.editBoxes.add(new HeartColorEditBox(this.field_22793, 0, 0, 38, 20, (class_2561)class_2561.method_43473(), this.heartType, this.health));
                this.method_41843();
            });
            widgets.add((class_339)addButton);
            this.colorSelectionList.addEntry(new ColorSelectionList.Entry(widgets));
        }
    }

    public void method_25394(@NotNull class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.hasChanged) {
            this.heartTypeButtons.forEach(btn -> {
                btn.field_22763 = false;
            });
            this.saveButton.field_22763 = this.canSave();
        } else if (this.saveButton.field_22763) {
            this.method_41843();
        }
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.lastScreen);
    }
}

