/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import terrails.healthoverlay.HOExpectPlatform;
import terrails.healthoverlay.config.Configuration;
import terrails.healthoverlay.config.screen.HeartBarPlacementScreen;
import terrails.healthoverlay.heart.Heart;
import terrails.healthoverlay.heart.HeartType;
import terrails.healthoverlay.render.RenderUtils;
import terrails.healthoverlay.utilities.Vec2i;

public class HeartRenderer {
    public static HeartRenderer INSTANCE = new HeartRenderer();
    private final class_310 client = class_310.method_1551();
    private final Random random = new Random();
    private long lastHealthTime;
    private long healthBlinkTime;
    private int displayHealthTicks;
    private int displayAbsorptionTicks;
    private int displayHealth;
    private int lastHealth;
    private List<Heart> hearts = Lists.newArrayList();
    private int previousHealth;
    private int previousMaxHealth;
    private int previousAbsorption;
    private HeartType previousHeartType;

    public void renderPlayerHearts(class_4587 poseStack, class_1657 player) {
        if (this.client.field_1755 instanceof HeartBarPlacementScreen) {
            return;
        }
        int currentHealth = class_3532.method_15386((float)player.method_6032());
        long tickCount = this.client.field_1705.method_1738();
        boolean blinking = this.healthBlinkTime > tickCount && (this.healthBlinkTime - tickCount) / 3L % 2L == 1L;
        long currentTime = class_156.method_658();
        if (currentHealth < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 20L;
        } else if (currentHealth > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 10L;
        }
        this.lastHealth = currentHealth;
        if (currentTime - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealth;
            this.lastHealthTime = currentTime;
        }
        this.random.setSeed(tickCount * 312871L);
        int maxHealth = Math.max((int)player.method_6063(), Math.max(this.displayHealth, currentHealth));
        int absorption = class_3532.method_15386((float)player.method_6067());
        int regenerationIndex = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regenerationIndex = (int)tickCount % class_3532.method_15386((float)((float)maxHealth + 5.0f));
        }
        Vec2i healthCoords = RenderUtils.getRenderCoords(true);
        Vec2i absorptionCoords = RenderUtils.getRenderCoords(false);
        int xPos = healthCoords.getX();
        int yPos = healthCoords.getY();
        this.renderLabels(poseStack, xPos, yPos, currentHealth, maxHealth, absorption);
        HeartType heartType = HeartType.forPlayer(player);
        if (this.previousHealth != currentHealth || this.previousMaxHealth != maxHealth || this.previousAbsorption != absorption || this.previousHeartType != heartType) {
            this.hearts = RenderUtils.calculateHearts(absorption, currentHealth, maxHealth, heartType);
            this.previousHealth = currentHealth;
            this.previousMaxHealth = maxHealth;
            this.previousAbsorption = absorption;
            this.previousHeartType = heartType;
        }
        HOExpectPlatform.modifyStatusBarYPos(absorption);
        RenderSystem.enableBlend();
        for (int index = 0; index < this.hearts.size(); ++index) {
            Heart heart = this.hearts.get(index);
            if (index > 9) {
                xPos = absorptionCoords.getX();
                yPos = absorptionCoords.getY();
            }
            int regenOffset = index < 10 && index == regenerationIndex ? -2 : 0;
            int yPosition = yPos + regenOffset;
            int xPosition = xPos + index % 10 * 8;
            if (Configuration.ABSORPTION.renderOverHealth.get().booleanValue() || index < 10) {
                if (currentHealth <= 4) {
                    yPosition += this.random.nextInt(2);
                }
                if (index == regenerationIndex) {
                    yPosition -= 2;
                }
            }
            heart.draw(poseStack, xPosition, yPosition, blinking, heartType);
        }
        RenderSystem.disableBlend();
    }

    public void renderLabels(class_4587 poseStack, int xPos, int yPos, int currentHealth, int maxHealth, int absorption) {
        Configuration.HeartDisplayMode rowDisplayMode = Configuration.COMMON.displayMode.get();
        if (rowDisplayMode != Configuration.HeartDisplayMode.OFF) {
            int ticks = this.client.field_1705.method_1738();
            int bgColorHealth = 0;
            int textColorHealth = 0;
            int bgColorAbsorption = 0;
            int textColorAbsorption = 0;
            if (rowDisplayMode == Configuration.HeartDisplayMode.ON_CHANGE) {
                int alpha;
                int timeLeft;
                if (currentHealth != 0 && maxHealth != 0 && (this.previousHealth != currentHealth || this.previousMaxHealth != maxHealth)) {
                    this.displayHealthTicks = ticks + 120;
                }
                if (this.displayHealthTicks >= ticks) {
                    timeLeft = this.displayHealthTicks - ticks;
                    alpha = 255;
                    if (timeLeft <= 30) {
                        alpha = (int)Math.ceil((double)timeLeft * 8.5);
                    }
                    if (alpha < 9) {
                        this.displayHealthTicks = 0;
                    } else {
                        bgColorHealth = alpha < 180 ? (alpha & 0xFF) << 24 | 0x101010 : -1274015728;
                        textColorHealth = alpha < 255 ? (alpha & 0xFF) << 24 | 0xFFFFFF : -1;
                    }
                }
                if (absorption != 0 && this.previousAbsorption != absorption) {
                    this.displayAbsorptionTicks = ticks + 120;
                }
                if (this.displayAbsorptionTicks >= ticks) {
                    timeLeft = this.displayAbsorptionTicks - ticks;
                    alpha = 255;
                    if (timeLeft <= 30) {
                        alpha = (int)Math.ceil((double)timeLeft * 8.5);
                    }
                    if (alpha < 9) {
                        this.displayAbsorptionTicks = 0;
                    } else {
                        bgColorAbsorption = alpha < 180 ? (alpha & 0xFF) << 24 | 0x101010 : -1274015728;
                        textColorAbsorption = alpha < 255 ? (alpha & 0xFF) << 24 | 0xFFFFFF : -1;
                    }
                }
            } else {
                bgColorHealth = -1274015728;
                textColorHealth = -1;
                bgColorAbsorption = -1274015728;
                textColorAbsorption = -1;
                this.displayHealthTicks = 0;
                this.displayAbsorptionTicks = 0;
            }
            int healthStartXPos = --xPos;
            String healthDisplayText = Configuration.HEALTH.displayText.get();
            if (bgColorHealth != 0 && !healthDisplayText.isBlank()) {
                String text = healthDisplayText.replace("[HEALTH]", Integer.toString(currentHealth)).replace("[MAX]", Integer.toString(maxHealth)).replace("[HEARTS]", HeartRenderer.parseDouble((double)currentHealth / 2.0)).replace("[MAX_HEARTS]", HeartRenderer.parseDouble((double)maxHealth / 2.0)).replace("[ROW]", Integer.toString((int)Math.ceil((double)currentHealth / 20.0))).replace("[MAX_ROW]", Integer.toString((int)Math.ceil((double)maxHealth / 20.0)));
                healthStartXPos = HeartRenderer.renderTextBox(poseStack, xPos, yPos, text, bgColorHealth, textColorHealth);
            }
            String absorptionDisplayText = Configuration.ABSORPTION.displayText.get();
            if (absorption != 0 && bgColorAbsorption != 0 && !absorptionDisplayText.isBlank()) {
                String text = absorptionDisplayText.replace("[ABSORPTION]", Integer.toString(absorption)).replace("[HEARTS]", HeartRenderer.parseDouble((double)absorption / 2.0)).replace("[ROW]", Integer.toString((int)Math.ceil((double)absorption / 20.0)));
                if (Configuration.ABSORPTION.renderOverHealth.get().booleanValue()) {
                    HeartRenderer.renderTextBox(poseStack, healthStartXPos - 2, yPos, text, bgColorAbsorption, textColorAbsorption);
                } else {
                    HeartRenderer.renderTextBox(poseStack, xPos, yPos - 10, text, bgColorAbsorption, textColorAbsorption);
                }
            }
        } else {
            this.displayHealthTicks = 0;
            this.displayAbsorptionTicks = 0;
        }
    }

    public static void renderLabel(class_4587 poseStack, int xPos, int yPos, boolean isHealth, int value, int maxValue, int backgroundColor, int textColor) {
        if (backgroundColor == 0) {
            return;
        }
        String healthDisplayText = Configuration.HEALTH.displayText.get();
        String absorptionDisplayText = Configuration.ABSORPTION.displayText.get();
        if (isHealth) {
            if (!healthDisplayText.isBlank()) {
                String text = healthDisplayText.replace("[HEALTH]", Integer.toString(value)).replace("[MAX]", Integer.toString(maxValue)).replace("[HEARTS]", HeartRenderer.parseDouble((double)value / 2.0)).replace("[MAX_HEARTS]", HeartRenderer.parseDouble((double)maxValue / 2.0)).replace("[ROW]", Integer.toString((int)Math.ceil((double)value / 20.0))).replace("[MAX_ROW]", Integer.toString((int)Math.ceil((double)maxValue / 20.0)));
                HeartRenderer.renderTextBox(poseStack, xPos, yPos, text, backgroundColor, textColor);
            }
        } else if (value != 0 && !absorptionDisplayText.isBlank()) {
            String text = absorptionDisplayText.replace("[ABSORPTION]", Integer.toString(value)).replace("[HEARTS]", HeartRenderer.parseDouble((double)value / 2.0)).replace("[ROW]", Integer.toString((int)Math.ceil((double)value / 20.0)));
            HeartRenderer.renderTextBox(poseStack, xPos, yPos, text, backgroundColor, textColor);
        }
    }

    public static int renderTextBox(class_4587 poseStack, int xPos, int yPos, String text, int backgroundColor, int textColor) {
        class_327 font = class_310.method_1551().field_1772;
        int width = font.method_1727(text);
        Objects.requireNonNull(font);
        int height = 9;
        int x = xPos - width;
        class_332.method_25294((class_4587)poseStack, (int)(x - 1), (int)yPos, (int)(x + width), (int)(yPos + height), (int)backgroundColor);
        font.method_1729(poseStack, text, (float)x, (float)(yPos + 1), textColor);
        return x;
    }

    public static String parseDouble(double num) {
        return (double)((int)num) == num ? Integer.toString((int)num) : Double.toString(num);
    }
}

