/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectingQuadProcessor;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

public class VerticalQuadProcessor
extends ConnectingQuadProcessor {
    protected static final int[] SPRITE_INDEX_MAP = new int[]{3, 2, 0, 1};

    public VerticalQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams) {
        super(sprites, processingPredicate, connectionPredicate, innerSeams);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        class_2350[] directions = DirectionMaps.getDirections((QuadView)quad);
        class_2338.class_2339 mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        int connections = this.getConnections(directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        class_1058 newSprite = this.sprites[SPRITE_INDEX_MAP[connections]];
        return SimpleQuadProcessor.process(quad, sprite, newSprite);
    }

    protected int getConnections(class_2350[] directions, class_2338.class_2339 mutablePos, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        int connections = 0;
        for (int i = 0; i < 2; ++i) {
            mutablePos.method_25505((class_2382)pos, directions[i * 2 + 1]);
            if (!this.connectionPredicate.shouldConnect(blockView, state, pos, mutablePos, face, quadSprite, this.innerSeams)) continue;
            connections |= 1 << i;
        }
        return connections;
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardConnectingCTMProperties properties, class_1058[] sprites) {
            return new VerticalQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams());
        }

        @Override
        public int getTextureAmount(StandardConnectingCTMProperties properties) {
            return 4;
        }
    }
}

